/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ProjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.RuntimeServerSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ClientRuntimeSelectionWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private String INFOPOP_PWRS_GROUP_CLIENT = String.valueOf(this.pluginId_) + ".PWRS0003";
    private Group clientGroup_;
    private RuntimeServerSelectionWidget runtimeWidget_;
    private ProjectSelectionWidget projectWidget_;
    private boolean isVisible_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.clientGroup_ = uiUtils.createGroup(parent, ConsumptionUIMessages.LABEL_CLIENT_SELECTION_VIEW_TITLE, null, this.INFOPOP_PWRS_GROUP_CLIENT, 2, 5, 5);
        this.runtimeWidget_ = new RuntimeServerSelectionWidget(true);
        this.runtimeWidget_.addControls((Composite)this.clientGroup_, statusListener);
        this.runtimeWidget_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientRuntimeSelectionWidget.this.handleUpdateProjectWidget();
            }
        });
        this.projectWidget_ = new ProjectSelectionWidget(true);
        this.projectWidget_.addControls((Composite)this.clientGroup_, statusListener);
        return this;
    }

    public void setVisible(boolean value) {
        this.clientGroup_.setVisible(value);
        this.isVisible_ = value;
    }

    public boolean isVisible() {
        return this.isVisible_;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.runtimeWidget_.setTypeRuntimeServer(ids);
        this.projectWidget_.setTypeRuntimeServer(ids);
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.runtimeWidget_.getTypeRuntimeServer();
    }

    public String getClientRuntimeId() {
        String projectName = this.projectWidget_.getProjectName();
        String templateId = this.projectWidget_.getComponentType();
        return WebServiceRuntimeExtensionUtils2.getClientRuntimeId(this.runtimeWidget_.getTypeRuntimeServer(), projectName, templateId);
    }

    public boolean getClientNeedEAR() {
        return this.projectWidget_.getNeedEAR();
    }

    public void setClientNeedEAR(boolean b) {
        this.projectWidget_.setNeedEAR(b);
    }

    public String getClientProjectName() {
        return this.projectWidget_.getProjectName();
    }

    public void setClientProjectName(String name) {
        this.projectWidget_.setProjectName(name);
    }

    public String getClientEarProjectName() {
        return this.projectWidget_.getEarProjectName();
    }

    public void setClientEarProjectName(String name) {
        this.projectWidget_.setEarProjectName(name);
    }

    public String getClientComponentType() {
        return this.projectWidget_.getComponentType();
    }

    public void setClientComponentType(String type) {
        this.projectWidget_.setComponentType(type);
    }

    public void setInstallClient(boolean b) {
        this.runtimeWidget_.setInstall(b);
    }

    private void handleUpdateProjectWidget() {
        this.projectWidget_.setTypeRuntimeServer(this.runtimeWidget_.getTypeRuntimeServer());
        this.projectWidget_.refreshProjectItems();
    }

    public ProjectSelectionWidget getProjectSelectionWidget() {
        return this.projectWidget_;
    }

    public IStatus getStatus() {
        ValidationUtils valUtils = new ValidationUtils();
        IStatus finalStatus = Status.OK_STATUS;
        IStatus projectStatus = this.projectWidget_.getStatus();
        IStatus runtimeStatus = this.runtimeWidget_.getStatus();
        if (runtimeStatus.getSeverity() == 4) {
            finalStatus = runtimeStatus;
        } else if (projectStatus.getSeverity() == 4) {
            finalStatus = projectStatus;
        } else {
            String projectName = this.projectWidget_.getProjectName();
            if (projectName != null && projectName.length() > 0) {
                IProject project = ProjectUtilities.getProject((String)projectName);
                String typeId = this.getClientTypeRuntimeServer().getTypeId();
                String runtimeId = this.getClientTypeRuntimeServer().getRuntimeId();
                String serverFactoryId = this.getClientTypeRuntimeServer().getServerId();
                if (project.exists()) {
                    if (!WebServiceRuntimeExtensionUtils2.doesClientTypeAndRuntimeSupportProject(typeId, runtimeId, projectName)) {
                        String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(runtimeId);
                        finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_RUNTIME_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{runtimeLabel, projectName}));
                    }
                    if (serverFactoryId != null && serverFactoryId.length() > 0 && !valUtils.doesServerSupportProject(serverFactoryId, projectName)) {
                        String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverFactoryId);
                        finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_SERVER_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{serverLabel, projectName}));
                    }
                } else {
                    String templateId = this.getClientComponentType();
                    if (templateId != null && templateId.length() > 0) {
                        String templateLabel;
                        if (!WebServiceRuntimeExtensionUtils2.doesClientTypeAndRuntimeSupportTemplate(typeId, runtimeId, templateId)) {
                            String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(runtimeId);
                            templateLabel = FacetUtils.getTemplateLabelById((String)templateId);
                            finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_RUNTIME_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{runtimeLabel, templateLabel}));
                        }
                        if (serverFactoryId != null && serverFactoryId.length() > 0 && !valUtils.doesServerSupportTemplate(serverFactoryId, templateId)) {
                            String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverFactoryId);
                            templateLabel = FacetUtils.getTemplateLabelById((String)templateId);
                            finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_SERVER_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{serverLabel, templateLabel}));
                        }
                    }
                }
            }
            if (finalStatus.getSeverity() != 4 && runtimeStatus.getSeverity() == 2) {
                finalStatus = runtimeStatus;
            }
        }
        return finalStatus;
    }
}

