/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.TypeSelectionFilter;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientType;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceType;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeInfo;
import org.eclipse.jst.ws.internal.data.LabelsAndIds;
import org.eclipse.wst.command.internal.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.env.core.selection.SelectionListChoices;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;

public class WebServiceRuntimeExtensionUtils {
    private static WebServiceRuntimeExtensionRegistry registry = WebServiceRuntimeExtensionRegistry.getInstance();
    private static SelectionListChoices serverToRuntimeToJ2EE_;
    private static Hashtable serverFactoryIdByLabel_;
    private static Hashtable runtimeIdByLabel_;

    public static IWebServiceRuntime getWebServiceRuntime(String runtimeId) {
        WebServiceRuntimeInfo wsrtInfo = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        IWebServiceRuntime webserviceRuntime = null;
        if (wsrtInfo != null) {
            webserviceRuntime = wsrtInfo.getWebServiceRuntime();
        }
        return webserviceRuntime;
    }

    public static WebServiceImpl getWebServiceImplById(String id) {
        Object result = WebServiceRuntimeExtensionUtils.registry.webServiceImpls_.get(id);
        if (result != null) {
            return (WebServiceImpl)result;
        }
        return null;
    }

    public static int getScenarioFromTypeId(String typeId) {
        return Integer.parseInt(typeId.substring(0, typeId.indexOf("/")));
    }

    public static String getImplIdFromTypeId(String typeId) {
        return typeId.substring(typeId.indexOf("/") + 1);
    }

    public static ServiceType getServiceType(String runtimeId, String typeId) {
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        if (wsrt != null) {
            int scenario = WebServiceRuntimeExtensionUtils.getScenarioFromTypeId(typeId);
            String implId = WebServiceRuntimeExtensionUtils.getImplIdFromTypeId(typeId);
            ServiceType[] sts = wsrt.getServiceTypes();
            if (sts != null) {
                int i = 0;
                while (i < sts.length) {
                    String thisImplId = sts[i].getWebServiceImpl().getId();
                    if (implId.equals(thisImplId) && sts[i].supportsScenario(scenario)) {
                        return sts[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public static WebServiceRuntimeInfo getWebServiceRuntimeById(String id) {
        Object result = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.get(id);
        if (result != null) {
            return (WebServiceRuntimeInfo)result;
        }
        return null;
    }

    public static WebServiceRuntimeInfo getWebServiceRuntimeByLabel(String label) {
        Iterator iter = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.values().iterator();
        while (iter.hasNext()) {
            WebServiceRuntimeInfo wsr = (WebServiceRuntimeInfo)iter.next();
            if (wsr == null || !label.equals(wsr.getLabel())) continue;
            return wsr;
        }
        return null;
    }

    public static String[] getRuntimesByType(String typeId) {
        int scenario = WebServiceRuntimeExtensionUtils.getScenarioFromTypeId(typeId);
        String implId = WebServiceRuntimeExtensionUtils.getImplIdFromTypeId(typeId);
        ArrayList<String> ids = new ArrayList<String>();
        Iterator iter = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.values().iterator();
        block0: while (iter.hasNext()) {
            WebServiceRuntimeInfo wsr = (WebServiceRuntimeInfo)iter.next();
            ServiceType[] sts = wsr.getServiceTypes();
            if (sts == null) continue;
            int i = 0;
            while (i < sts.length) {
                String thisImplId = sts[i].getWebServiceImpl().getId();
                if (implId.equals(thisImplId) && sts[i].supportsScenario(scenario)) {
                    ids.add(wsr.getId());
                    continue block0;
                }
                ++i;
            }
        }
        if (ids.size() > 0) {
            String[] runtimeIds = ids.toArray(new String[0]);
            return runtimeIds;
        }
        return null;
    }

    public static boolean isRuntimeSupportedForType(String typeId, String runtimeId) {
        String[] runtimeIds = WebServiceRuntimeExtensionUtils.getRuntimesByType(typeId);
        if (runtimeIds != null) {
            int i = 0;
            while (i < runtimeIds.length) {
                if (runtimeIds[i].equals(runtimeId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] getServerFactoryIdsByType(String typeId) {
        String[] wsrts = WebServiceRuntimeExtensionUtils.getRuntimesByType(typeId);
        if (wsrts == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        int i = 0;
        while (i < wsrts.length) {
            String[] fIds = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(wsrts[i]).getServerFactoryIds();
            if (fIds != null) {
                int j = 0;
                while (j < fIds.length) {
                    if (!ids.contains(fIds[j])) {
                        ids.add(fIds[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (ids.size() > 0) {
            String[] serverFactoryIds = ids.toArray(new String[0]);
            return serverFactoryIds;
        }
        return null;
    }

    public static boolean isServerSupportedForChosenType(String typeId, String serverFactoryId) {
        String[] fIds = WebServiceRuntimeExtensionUtils.getServerFactoryIdsByType(typeId);
        if (fIds == null) {
            return false;
        }
        int i = 0;
        while (i < fIds.length) {
            if (serverFactoryId.equals(fIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isServerRuntimeTypeSupported(String serverFactoryId, String runtimeId, String typeId) {
        String[] rIds = WebServiceRuntimeExtensionUtils.getRuntimesByType(typeId);
        if (rIds == null) {
            return false;
        }
        int i = 0;
        while (i < rIds.length) {
            String[] fIds;
            if (runtimeId.equals(rIds[i]) && (fIds = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(rIds[i]).getServerFactoryIds()) != null) {
                int j = 0;
                while (j < fIds.length) {
                    if (serverFactoryId.equals(fIds[j])) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean doesRuntimeSupportJ2EELevel(String j2eeVersionId, String runtimeId) {
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        if (wsrt == null) {
            return false;
        }
        String[] j2eeVersions = wsrt.getJ2eeLevels();
        if (j2eeVersions == null || j2eeVersions.length == 0) {
            return true;
        }
        int i = 0;
        while (i < j2eeVersions.length) {
            if (j2eeVersions[i].equals(j2eeVersionId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean doesRuntimeSupportServerTarget(String serverTargetId, String runtimeId) {
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        if (wsrt == null) {
            return false;
        }
        String[] fIds = wsrt.getServerFactoryIds();
        int i = 0;
        while (i < fIds.length) {
            String thisServerTargetId;
            IServerType serverType = ServerCore.findServerType((String)fIds[i]);
            if (serverType != null && (thisServerTargetId = serverType.getRuntimeType().getId()).equals(serverTargetId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IProject[] getAllProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> validProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].getName().equals("Servers") && !projects[i].getName().startsWith(".")) {
                validProjects.add(projects[i]);
            }
            ++i;
        }
        return validProjects.toArray(new IProject[0]);
    }

    public static LabelsAndIds getServiceTypeLabels() {
        String pluginId = "org.eclipse.jst.ws.internal.consumption.ui";
        MessageUtils msgUtils = new MessageUtils(String.valueOf(pluginId) + ".ConsumptionUI", (Object)registry);
        LabelsAndIds labelIds = new LabelsAndIds();
        Iterator iterator = WebServiceRuntimeExtensionUtils.registry.webServiceTypesList_.iterator();
        int size = WebServiceRuntimeExtensionUtils.registry.webServiceTypesList_.size();
        String[] labels = new String[size];
        String[] ids = new String[size];
        int index = 0;
        labelIds.setLabels_(labels);
        labelIds.setIds_(ids);
        while (iterator.hasNext()) {
            String wst = (String)iterator.next();
            int scenario = WebServiceRuntimeExtensionUtils.getScenarioFromTypeId(wst);
            String implId = WebServiceRuntimeExtensionUtils.getImplIdFromTypeId(wst);
            WebServiceImpl wsimpl = WebServiceRuntimeExtensionUtils.getWebServiceImplById(implId);
            String impllabel = wsimpl.getLabel();
            ids[index] = wst;
            String scenLabel = "";
            switch (scenario) {
                case 0: {
                    scenLabel = msgUtils.getMessage("BOTTOMUP_LABEL");
                    break;
                }
                case 1: {
                    scenLabel = msgUtils.getMessage("TOPDOWN_LABEL");
                }
            }
            labels[index] = msgUtils.getMessage("COMBINED_TYPE_AND_RUNTIME_LABEL", (Object[])new String[]{scenLabel, impllabel});
            ++index;
        }
        return labelIds;
    }

    public static String getDefaultRuntimeValueFor(String typeId) {
        String[] rIds = WebServiceRuntimeExtensionUtils.getRuntimesByType(typeId);
        if (rIds == null) {
            return null;
        }
        return rIds[0];
    }

    public static String getDefaultServerValueFor(String typeId) {
        String[] fIds = WebServiceRuntimeExtensionUtils.getServerFactoryIdsByType(typeId);
        if (fIds == null) {
            return null;
        }
        return fIds[0];
    }

    public static String[] getWebServiceTypeBySelection(IStructuredSelection selection) {
        TypeSelectionFilter tsf = new TypeSelectionFilter();
        String[] wst = tsf.getWebServiceTypeByInitialSelection(selection, WebServiceRuntimeExtensionUtils.registry.webServiceTypesList_);
        return wst == null ? null : wst;
    }

    public static boolean requiresEJBProject(String runtimeId, String typeId) {
        String[] includedNatures;
        ServiceType st = WebServiceRuntimeExtensionUtils.getServiceType(runtimeId, typeId);
        return st != null && (includedNatures = st.getModuleTypesInclude(WebServiceRuntimeExtensionUtils.getScenarioFromTypeId(typeId))) != null && includedNatures.length > 0 && includedNatures[0].equals("jst.ejb");
    }

    public static boolean requiresEJBModuleFor(String serverFactoryId, String runtimeId, String typeId) {
        return false;
    }

    public static String getRuntimeLabelById(String runtimeId) {
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        if (wsrt == null) {
            return null;
        }
        return wsrt.getLabel();
    }

    public static String getServerLabelById(String serverFactoryId) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType == null) {
            return null;
        }
        String serverLabel = ServerUICore.getLabelProvider().getText((Object)serverType);
        return serverLabel;
    }

    public static String getServerInstanceLabelFromInstanceId(String instanceId) {
        IServer server = ServerCore.findServer((String)instanceId);
        return server.getName();
    }

    public static boolean doesRuntimeSupportServer(String runtimeId, String factoryId) {
        String[] fids;
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        if (wsrt != null && (fids = wsrt.getServerFactoryIds()) != null) {
            int i = 0;
            while (i < fids.length) {
                if (fids[i].equals(factoryId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getFirstSupportedServer(String runtimeId) {
        String[] fids;
        WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        if (wsrt != null && (fids = wsrt.getServerFactoryIds()) != null && fids.length > 0) {
            return fids[0];
        }
        return null;
    }

    public static String[] getRuntimesByClientType(String clientImplId) {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator iter = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.values().iterator();
        block0: while (iter.hasNext()) {
            WebServiceRuntimeInfo wsr = (WebServiceRuntimeInfo)iter.next();
            ClientType[] cts = wsr.getClientTypes();
            if (cts == null) continue;
            int i = 0;
            while (i < cts.length) {
                String wsClientImplId = cts[i].getWebServiceClientImpl().getId();
                if (wsClientImplId.equals(clientImplId)) {
                    ids.add(wsr.getId());
                    continue block0;
                }
                ++i;
            }
        }
        if (ids.size() > 0) {
            String[] runtimeIds = ids.toArray(new String[0]);
            return runtimeIds;
        }
        return null;
    }

    public static boolean webServiceClientRuntimeTypeExists(String serverFactoryId, String runtimeId, String clientTypeId) {
        String[] rIds = WebServiceRuntimeExtensionUtils.getRuntimesByClientType(clientTypeId);
        if (rIds == null) {
            return false;
        }
        int i = 0;
        while (i < rIds.length) {
            String[] fIds;
            if (runtimeId.equals(rIds[i]) && (fIds = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(rIds[i]).getServerFactoryIds()) != null) {
                int j = 0;
                while (j < fIds.length) {
                    if (serverFactoryId.equals(fIds[j])) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static String[] getAllClientRuntimes() {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator iter = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.values().iterator();
        while (iter.hasNext()) {
            WebServiceRuntimeInfo wsr = (WebServiceRuntimeInfo)iter.next();
            ClientType[] cts = wsr.getClientTypes();
            if (cts == null || cts.length <= 0) continue;
            ids.add(wsr.getId());
        }
        if (ids.size() > 0) {
            String[] runtimeIds = ids.toArray(new String[0]);
            return runtimeIds;
        }
        return null;
    }

    public static String[] getAllClientServerFactoryIds() {
        String[] rIds = WebServiceRuntimeExtensionUtils.getAllClientRuntimes();
        if (rIds == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        int i = 0;
        while (i < rIds.length) {
            String[] fIds = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(rIds[i]).getServerFactoryIds();
            if (fIds != null) {
                int j = 0;
                while (j < fIds.length) {
                    if (!ids.contains(fIds[j])) {
                        ids.add(fIds[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (ids.size() > 0) {
            String[] serverFactoryIds = ids.toArray(new String[0]);
            return serverFactoryIds;
        }
        return null;
    }

    public static String[] getClientProjectTypes(String clientImplId, String runtimeId) {
        String[] rIds = WebServiceRuntimeExtensionUtils.getRuntimesByClientType(clientImplId);
        if (rIds == null) {
            return null;
        }
        int i = 0;
        while (i < rIds.length) {
            ClientType[] cts;
            if (runtimeId.equals(rIds[i]) && (cts = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(rIds[i]).getClientTypes()) != null) {
                int j = 0;
                while (j < cts.length) {
                    String thisClientImplId = cts[j].getWebServiceClientImpl().getId();
                    if (clientImplId.equals(thisClientImplId)) {
                        String[] projectTypes = cts[j].getModuleTypesInclude();
                        return projectTypes;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean doesRuntimeSupportComponentType(String clientImplId, String runtimeId, String componentTypeId) {
        String[] compTypeIds = WebServiceRuntimeExtensionUtils.getClientProjectTypes(clientImplId, runtimeId);
        if (compTypeIds != null) {
            int i = 0;
            while (i < compTypeIds.length) {
                if (compTypeIds[i].equals(componentTypeId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static LabelsAndIds getClientTypeLabels() {
        LabelsAndIds labelIds = new LabelsAndIds();
        String[] idsArray = new String[]{};
        String[] labelsArray = new String[]{};
        labelIds.setIds_(idsArray);
        labelIds.setLabels_(labelsArray);
        String[] rIds = WebServiceRuntimeExtensionUtils.getAllClientRuntimes();
        if (rIds == null) {
            return labelIds;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        int i = 0;
        while (i < rIds.length) {
            WebServiceRuntimeInfo wsrt = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(rIds[i]);
            ClientType[] cts = wsrt.getClientTypes();
            if (cts != null) {
                int j = 0;
                while (j < cts.length) {
                    ClientType ct = cts[j];
                    String id = ct.getWebServiceClientImpl().getId();
                    if (!ids.contains(id)) {
                        ids.add(id);
                        labels.add(ct.getWebServiceClientImpl().getLabel());
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (ids.size() > 0) {
            idsArray = ids.toArray(new String[0]);
            labelsArray = labels.toArray(new String[0]);
            labelIds.setIds_(idsArray);
            labelIds.setLabels_(labelsArray);
        }
        return labelIds;
    }

    public static SelectionListChoices getServerToRuntimeToJ2EE() {
        if (serverToRuntimeToJ2EE_ != null) {
            return serverToRuntimeToJ2EE_;
        }
        String[] servers = WebServiceRuntimeExtensionUtils.getAllServerFactoryIds();
        SelectionList serversList = new SelectionList(servers, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int i = 0;
        while (i < servers.length) {
            choices.add(WebServiceRuntimeExtensionUtils.getRuntimeChoices(servers[i]));
            ++i;
        }
        serverToRuntimeToJ2EE_ = new SelectionListChoices(serversList, choices);
        return serverToRuntimeToJ2EE_;
    }

    private static SelectionListChoices getRuntimeChoices(String serverFactoryId) {
        String[] runtimes = WebServiceRuntimeExtensionUtils.getRuntimeIDsByServerFactoryID(serverFactoryId);
        SelectionList runtimesList = new SelectionList(runtimes, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int i = 0;
        while (i < runtimes.length) {
            choices.add(WebServiceRuntimeExtensionUtils.getJ2EEChoices(runtimes[i]));
            ++i;
        }
        return new SelectionListChoices(runtimesList, choices);
    }

    private static SelectionListChoices getJ2EEChoices(String runtimeId) {
        WebServiceRuntimeInfo wsr = WebServiceRuntimeExtensionUtils.getWebServiceRuntimeById(runtimeId);
        if (wsr == null) {
            return null;
        }
        String[] j2eeVersions = wsr.getJ2eeLevels();
        SelectionList j2eeVersionsList = new SelectionList(j2eeVersions, 0);
        return new SelectionListChoices(j2eeVersionsList, null);
    }

    private static String[] getAllServerFactoryIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (serverFactoryIdByLabel_ == null) {
            serverFactoryIdByLabel_ = new Hashtable();
            Iterator iter = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.values().iterator();
            while (iter.hasNext()) {
                WebServiceRuntimeInfo wsr = (WebServiceRuntimeInfo)iter.next();
                String[] sfids = wsr.getServerFactoryIds();
                int i = 0;
                while (i < sfids.length) {
                    String label;
                    if (!ids.contains(sfids[i]) && (label = WebServiceRuntimeExtensionUtils.getServerLabelById(sfids[i])) != null) {
                        ids.add(sfids[i]);
                        serverFactoryIdByLabel_.put(label, sfids[i]);
                    }
                    ++i;
                }
            }
        } else {
            Iterator fids = serverFactoryIdByLabel_.values().iterator();
            while (fids.hasNext()) {
                String fid = (String)fids.next();
                ids.add(fid);
            }
        }
        if (ids.size() > 0) {
            String[] serverFactoryIds = ids.toArray(new String[0]);
            return serverFactoryIds;
        }
        return null;
    }

    private static String[] getRuntimeIDsByServerFactoryID(String serverFactoryID) {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator iter = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.values().iterator();
        while (iter.hasNext()) {
            WebServiceRuntimeInfo wsr = (WebServiceRuntimeInfo)iter.next();
            if (!WebServiceRuntimeExtensionUtils.doesRuntimeSupportServer(wsr.getId(), serverFactoryID)) continue;
            ids.add(wsr.getId());
        }
        if (ids.size() > 0) {
            String[] runtimeIds = ids.toArray(new String[0]);
            return runtimeIds;
        }
        return null;
    }

    public static String getServerFactoryId(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        if (serverFactoryIdByLabel_ == null) {
            WebServiceRuntimeExtensionUtils.getAllServerFactoryIds();
        }
        if (serverFactoryIdByLabel_.containsKey(label)) {
            return (String)serverFactoryIdByLabel_.get(label);
        }
        return null;
    }

    public static String getRuntimeId(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        if (runtimeIdByLabel_ == null) {
            runtimeIdByLabel_ = new Hashtable();
            Iterator iter = WebServiceRuntimeExtensionUtils.registry.webServiceRuntimes_.values().iterator();
            while (iter.hasNext()) {
                WebServiceRuntimeInfo wsr = (WebServiceRuntimeInfo)iter.next();
                runtimeIdByLabel_.put(wsr.getLabel(), wsr.getId());
            }
        }
        return (String)runtimeIdByLabel_.get(label);
    }
}

