/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;

public class OutputPreference
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private static final String DESCRIPTION = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.OUTPUT.DESCRIPTION");
    private static final String LIMIT_ROWS = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.OUTPUT.LIMIT_ROWS_RETRIEVED");
    private static final String MAX_ROWS = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.OUTPUT.MAX_ROW_RETRIEVED");
    private static final String MAX_LOB_LENGTH = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.OUTPUT.MAX_LOB_LENGTH");
    private static final String ERROR_INVALID_INT = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.PREFERENCES.OUTPUT.ERROR_INVALID_INT");
    protected Button bLimitRows;
    protected Text tMaxRows;
    protected Text tMaxLobLength;
    protected Label lMaxRows;

    protected Control createContents(Composite arg0) {
        Composite cmp = new Composite(arg0, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        cmp.setLayout((Layout)gl);
        GridData gd01 = new GridData();
        gd01.horizontalSpan = 2;
        gd01.horizontalAlignment = 4;
        Label lblDescr = new Label(cmp, 64);
        lblDescr.setText(DESCRIPTION);
        lblDescr.setLayoutData((Object)gd01);
        GridData gd02 = new GridData();
        gd02.horizontalSpan = 2;
        Label placeholder = new Label(cmp, 0);
        placeholder.setText("");
        placeholder.setLayoutData((Object)gd02);
        GridData gd11 = new GridData();
        gd11.horizontalSpan = 2;
        this.bLimitRows = new Button(cmp, 32);
        this.bLimitRows.setText(LIMIT_ROWS);
        this.bLimitRows.setLayoutData((Object)gd11);
        GridData gd12 = new GridData();
        this.lMaxRows = new Label(cmp, 0);
        this.lMaxRows.setText("\t" + MAX_ROWS);
        this.lMaxRows.setLayoutData((Object)gd12);
        GridData gd13 = new GridData();
        gd13.horizontalAlignment = 4;
        gd13.grabExcessHorizontalSpace = true;
        gd13.widthHint = 50;
        this.tMaxRows = new Text(cmp, 2048);
        this.tMaxRows.setLayoutData((Object)gd13);
        GridData gd14 = new GridData();
        gd14.horizontalSpan = 2;
        Label lblFill1 = new Label(cmp, 0);
        lblFill1.setText(" ");
        lblFill1.setLayoutData((Object)gd14);
        GridData gd22 = new GridData();
        Label lMaxLobLength = new Label(cmp, 0);
        lMaxLobLength.setText(MAX_LOB_LENGTH);
        lMaxLobLength.setLayoutData((Object)gd22);
        GridData gd23 = new GridData();
        gd23.horizontalAlignment = 4;
        gd23.widthHint = 50;
        gd23.grabExcessHorizontalSpace = true;
        this.tMaxLobLength = new Text(cmp, 2048);
        this.tMaxLobLength.setLayoutData((Object)gd23);
        this.bLimitRows.setSelection(RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED"));
        this.bLimitRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source == OutputPreference.this.bLimitRows) {
                    OutputPreference.this.tMaxRows.setEnabled(OutputPreference.this.bLimitRows.getSelection());
                    OutputPreference.this.lMaxRows.setEnabled(OutputPreference.this.bLimitRows.getSelection());
                    if (!OutputPreference.this.bLimitRows.getSelection()) {
                        OutputPreference.this.setValid(OutputPreference.this.isValueValid(OutputPreference.this.tMaxLobLength.getText()));
                    } else {
                        OutputPreference.this.setValid(OutputPreference.this.isValueValid(OutputPreference.this.tMaxLobLength.getText()) && OutputPreference.this.isValueValid(OutputPreference.this.tMaxRows.getText()));
                    }
                }
            }
        });
        this.tMaxRows.addModifyListener((ModifyListener)this);
        this.tMaxLobLength.addModifyListener((ModifyListener)this);
        this.tMaxRows.setText(Integer.toString(RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED")));
        this.tMaxLobLength.setText(Integer.toString(RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH")));
        this.tMaxRows.setEnabled(this.bLimitRows.getSelection());
        return cmp;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.bLimitRows.setSelection(RDBCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED"));
        this.tMaxRows.setText(Integer.toString(RDBCorePlugin.getDefault().getPluginPreferences().getDefaultInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED")));
        this.tMaxLobLength.setText(Integer.toString(RDBCorePlugin.getDefault().getPluginPreferences().getDefaultInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH")));
        this.tMaxRows.setEnabled(this.bLimitRows.getSelection());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    public void modifyText(ModifyEvent event) {
        Object source = event.getSource();
        if (source == this.tMaxRows) {
            String numberString = this.tMaxRows.getText();
            this.setValid(this.isValueValid(numberString) && this.isValueValid(this.tMaxLobLength.getText()));
        } else if (source == this.tMaxLobLength) {
            String numberString = this.tMaxLobLength.getText();
            if (this.bLimitRows.getSelection()) {
                this.setValid(this.isValueValid(numberString) && this.isValueValid(this.tMaxRows.getText()));
            } else {
                this.setValid(this.isValueValid(numberString));
            }
        }
    }

    private boolean isValueValid(String aNumberString) {
        Object[] obj = new Object[]{new Integer(1), new Integer(Integer.MAX_VALUE)};
        boolean valid = false;
        try {
            int number = Integer.valueOf(aNumberString);
            if (number < 1 || number > Integer.MAX_VALUE) {
                String errorMessage = MessageFormat.format(ERROR_INVALID_INT, obj);
                this.setErrorMessage(errorMessage);
            } else {
                this.setErrorMessage(null);
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            String errorMessage = MessageFormat.format(ERROR_INVALID_INT, obj);
            this.setErrorMessage(errorMessage);
        }
        return valid;
    }

    private void storePreferences() {
        RDBCorePlugin.getDefault().getPluginPreferences().setValue("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED", this.bLimitRows.getSelection());
        int pint = RDBCorePlugin.getDefault().getPluginPreferences().getDefaultInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
        try {
            pint = Integer.parseInt(this.tMaxRows.getText());
        }
        catch (Exception exception) {}
        RDBCorePlugin.getDefault().getPluginPreferences().setValue("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED", pint);
        pint = RDBCorePlugin.getDefault().getPluginPreferences().getDefaultInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
        try {
            pint = Integer.parseInt(this.tMaxLobLength.getText());
        }
        catch (Exception exception) {}
        RDBCorePlugin.getDefault().getPluginPreferences().setValue("OUTPUT_PREFERENCE_MAX_LOB_LENGTH", pint);
    }
}

