/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.wsfinder;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.ws.internal.wsfinder.IWebServiceLocator;
import org.eclipse.wst.ws.internal.wsfinder.WebServiceLocatorRegistry;

public class WebServiceFinder {
    private static WebServiceFinder instance = null;
    private static final String ELEMENT_LOCATOR = "webServiceLocator";
    private static final String ELEMENT_CATEGORY = "webServiceLocatorCategory";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_CATEGORY = "category";

    private WebServiceFinder() {
    }

    public static WebServiceFinder instance() {
        if (instance == null) {
            instance = new WebServiceFinder();
        }
        return instance;
    }

    public Iterator getWebServices() {
        return this.getWebServices(null);
    }

    public Iterator getWebServices(String category) {
        LinkedList webServices = new LinkedList();
        WebServiceLocatorRegistry wslr = WebServiceLocatorRegistry.getInstance();
        IConfigurationElement[] regElements = wslr.getConfigElements();
        int i = 0;
        while (i < regElements.length) {
            if (ELEMENT_LOCATOR.equals(regElements[i].getName())) {
                try {
                    Object obj;
                    if ((category == null || category.equals(regElements[i].getAttributeAsIs(ATTRIBUTE_CATEGORY))) && (obj = regElements[i].createExecutableExtension(ATTRIBUTE_CLASS)) instanceof IWebServiceLocator) {
                        IWebServiceLocator wsl = (IWebServiceLocator)obj;
                        List wsList = wsl.getWebServices();
                        webServices.addAll(wsList);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return webServices.iterator();
    }

    public String[] getCategoryIDs() {
        LinkedList<String> categories = new LinkedList<String>();
        WebServiceLocatorRegistry wslr = WebServiceLocatorRegistry.getInstance();
        IConfigurationElement[] regElements = wslr.getConfigElements();
        int i = 0;
        while (i < regElements.length) {
            String id;
            if (ELEMENT_CATEGORY.equals(regElements[i].getName()) && (id = regElements[i].getAttributeAsIs(ATTRIBUTE_ID)) != null) {
                categories.add(id);
            }
            ++i;
        }
        return categories.toArray(new String[0]);
    }
}

