/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLTraversal;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SSBP2403
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public SSBP2403(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    private boolean isNonConformantBindingExtension(String namespace) {
        boolean result = false;
        if (namespace != null && (namespace.equals("http://schemas.xmlsoap.org/wsdl/mime/") || namespace.equals("http://schemas.xmlsoap.org/wsdl/http/") || namespace.equals("http://schemas.xmlsoap.org/ws/2002/04/dime/wsdl/"))) {
            result = true;
        }
        return result;
    }

    public void visit(ExtensibilityElement exel, Object parent, WSDLTraversalContext ctx) {
        if (this.isNonConformantBindingExtension(exel.getElementType().getNamespaceURI())) {
            this.errors.add(exel.getElementType());
        } else if (exel instanceof UnknownExtensibilityElement) {
            Element el = ((UnknownExtensibilityElement)exel).getElement();
            XMLTraversalCheckingExtensions traversal = new XMLTraversalCheckingExtensions();
            traversal.visit(el);
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitElement(true);
        traversal.visitExtensibilityElement(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private class XMLTraversalCheckingExtensions
    extends XMLTraversal {
        boolean nonConformantExtensionFound = false;

        XMLTraversalCheckingExtensions() {
        }

        public boolean action(Node n) {
            return !this.nonConformantExtensionFound;
        }

        public void visit(Attr node) {
            if (this.action(node) && SSBP2403.this.isNonConformantBindingExtension(node.getNamespaceURI())) {
                SSBP2403.this.errors.add(node.getName());
                this.nonConformantExtensionFound = true;
            }
        }

        public void visit(Element node) {
            if (this.action(node)) {
                if (SSBP2403.this.isNonConformantBindingExtension(node.getNamespaceURI())) {
                    SSBP2403.this.errors.add(node.getNodeName());
                    this.nonConformantExtensionFound = true;
                } else {
                    this.visit(node.getAttributes());
                    Node n = node.getFirstChild();
                    while (n != null) {
                        this.doVisit(n);
                        n = n.getNextSibling();
                    }
                }
            }
        }
    }
}

