/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.xml;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.util.NullUtil;
import org.eclipse.wst.wsi.internal.core.xml.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class XMLUtils {
    public static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_SOAP_12_SCHEMA = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String PROPERTY_EXTERNAL_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String SOAP_ELEM_ENVELOPE = "Envelope";
    public static final String SOAP_ELEM_HEADER = "Header";
    public static final String SOAP_ELEM_BODY = "Body";
    public static final String SOAP_ELEM_FAULT = "Fault";
    public static final String SOAP_ELEM_FAULT_CODE = "faultcode";
    public static final String SOAP_ELEM_FAULT_STRING = "faultstring";
    public static final String SOAP_ELEM_FAULT_DETAIL = "detail";
    public static final String SOAP_ELEM_FAULT_ACTOR = "faultactor";
    public static final String SOAP_ATTR_MUST_UNDERSTAND = "mustUnderstand";
    public static final String SOAP_ATTR_ACTOR = "actor";
    static /* synthetic */ Class class$0;

    public static XMLReader getXMLReader() throws WSIException {
        XMLReader xmlReader = null;
        try {
            xmlReader = new SAXParserFactoryImpl().newSAXParser().getXMLReader();
            xmlReader.setFeature(FEATURE_NAMESPACE_PREFIXES, true);
            xmlReader.setFeature(FEATURE_NAMESPACES, true);
        }
        catch (Exception e) {
            throw new WSIException("Could not get XMLReader implementation.", e);
        }
        return xmlReader;
    }

    public static Document parseXML(String text, boolean validate) throws WSIException {
        return XMLUtils.parseXML((Reader)new StringReader(text), validate);
    }

    public static Document parseXML(String text) throws WSIException {
        return XMLUtils.parseXML(new StringReader(text));
    }

    public static Document parseXMLDocument(String uri) throws WSIException, IOException {
        return XMLUtils.parseXMLDocument(uri, null);
    }

    public static Document parseXMLDocument(String uri, String schema) throws WSIException, IOException {
        URL url = StringUtils.getURL(null, (String)uri);
        InputStream inputStream = (InputStream)url.getContent();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(url.toString());
        if (schema == null) {
            return XMLUtils.parseXML(inputSource, false);
        }
        return XMLUtils.parseXML(inputSource, schema);
    }

    public static Document parseXMLDocumentURL(String url, String schema, String baseURI) throws WSIException {
        try {
            XMLUtils.parseXMLDocumentURL(XMLUtils.createURL(url, baseURI), schema);
        }
        catch (Exception e) {
            throw new WSIException(e.getMessage(), e);
        }
        return XMLUtils.parseXMLDocumentURL(url, schema);
    }

    public static Document parseXMLDocumentURL(URL url, String schema) throws WSIException {
        try {
            InputStream inputStream = (InputStream)url.getContent();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(url.toString());
            Document doc = null;
            doc = schema == null ? XMLUtils.parseXML(inputSource) : XMLUtils.parseXML(inputSource, schema);
            inputStream.close();
            return doc;
        }
        catch (WSIException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new WSIException(t.getMessage());
        }
    }

    public static Document parseXMLDocumentURL(String urlString, String baseURI) throws WSIException {
        Document document = null;
        try {
            URL url = XMLUtils.createURL(urlString, baseURI);
            document = XMLUtils.parseXMLDocumentURL(url);
        }
        catch (WSIException we) {
            throw we;
        }
        catch (Exception e) {
            throw new WSIException(e.getMessage(), e);
        }
        return document;
    }

    public static Document parseXMLDocumentURL(URL url) throws WSIException {
        Document document = null;
        try {
            InputStreamReader reader = new InputStreamReader(url.openStream());
            InputSource source = new InputSource(reader);
            source.setSystemId(url.toString());
            document = XMLUtils.parseXML(source);
            ((Reader)reader).close();
        }
        catch (Exception e) {
            throw new WSIException(e.getMessage(), e);
        }
        return document;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseXML(InputSource source, boolean validate) throws WSIException {
        Document doc = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsi.internal.core.xml.XMLUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                factory.setValidating(false);
                DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                doc = builder.parse(source);
                if (doc instanceof DocumentImpl && ((DocumentImpl)doc).getXmlVersion().equals("1.1")) {
                    throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
                }
            }
            catch (Exception e) {
                throw new WSIException("Could not parse XML document.", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        {
            Object var6_9 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return doc;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseXML(Reader reader, boolean validate) throws WSIException {
        Document doc = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsi.internal.core.xml.XMLUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                InputSource inputSource = new InputSource(reader);
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                factory.setValidating(false);
                DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                doc = builder.parse(inputSource);
                if (doc instanceof DocumentImpl && ((DocumentImpl)doc).getXmlVersion().equals("1.1")) {
                    throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
                }
            }
            catch (Exception e) {
                throw new WSIException("Could not parse XML document.", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        {
            Object var7_10 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return doc;
        }
    }

    public static Document parseXML(Reader reader) throws WSIException {
        return XMLUtils.parseXML(reader, false);
    }

    public static Document parseXML(InputSource source) throws WSIException {
        return XMLUtils.parseXML(source, false);
    }

    public static Document parseXML(String text, String schema) throws WSIException {
        return XMLUtils.parseXML((Reader)new StringReader(text), schema);
    }

    public static Document parseXML(String text, Collection schemas) throws WSIException {
        return XMLUtils.parseXML((Reader)new StringReader(text), schemas);
    }

    public static Document parseXML(String text, StringReader schemaString) throws WSIException, IOException {
        return XMLUtils.parseXML((Reader)new StringReader(text), schemaString);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseXML(Reader reader, String schema) throws WSIException {
        Document doc = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsi.internal.core.xml.XMLUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                InputSource inputSource = new InputSource(reader);
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                try {
                    factory.setValidating(false);
                    ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                catch (IllegalArgumentException e) {
                    String errMessage = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
                    throw new WSIException(errMessage, e);
                }
                ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_SOURCE, new InputSource(schema));
                DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                builder.setErrorHandler(new ErrHandler());
                doc = builder.parse(inputSource);
                if (doc instanceof DocumentImpl && ((DocumentImpl)doc).getXmlVersion().equals("1.1")) {
                    throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
                }
            }
            catch (Exception e) {
                throw new WSIException("Could not parse XML document.", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        {
            Object var8_12 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return doc;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseXML(InputSource source, String schema) throws WSIException {
        Document doc = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsi.internal.core.xml.XMLUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                factory.setValidating(false);
                try {
                    ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                catch (IllegalArgumentException e) {
                    String errMessage = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
                    throw new WSIException(errMessage, e);
                }
                ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_SOURCE, new InputSource(schema));
                DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                builder.setErrorHandler(new ErrHandler());
                doc = builder.parse(source);
                if (doc instanceof DocumentImpl && ((DocumentImpl)doc).getXmlVersion().equals("1.1")) {
                    throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
                }
            }
            catch (Exception e) {
                throw new WSIException("Could not parse XML document.", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        {
            Object var7_11 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return doc;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseXML(Reader filename, StringReader schemaString) throws WSIException {
        Document doc = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsi.internal.core.xml.XMLUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                InputSource inputSource = new InputSource(filename);
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                factory.setValidating(false);
                try {
                    ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                catch (IllegalArgumentException e) {
                    String errMessage = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
                    throw new WSIException(errMessage, e);
                }
                ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_SOURCE, new InputSource(schemaString));
                DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                builder.setErrorHandler(new ErrHandler());
                doc = builder.parse(inputSource);
            }
            catch (Exception e) {
                throw new WSIException("Could not parse XML document.", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        {
            Object var8_12 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return doc;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseXML(Reader filename, Collection schemaStrings) throws WSIException {
        Document doc = null;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsi.internal.core.xml.XMLUtils");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                InputSource inputSource = new InputSource(filename);
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                factory.setValidating(false);
                try {
                    ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                catch (IllegalArgumentException e) {
                    String errMessage = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
                    throw new WSIException(errMessage, e);
                }
                Iterator i = schemaStrings.iterator();
                Vector<InputSource> readers = new Vector<InputSource>();
                while (true) {
                    block11: {
                        if (i.hasNext()) break block11;
                        InputSource[] inputSources = readers.toArray(new InputSource[0]);
                        ((DocumentBuilderFactory)factory).setAttribute(JAXP_SCHEMA_SOURCE, inputSources);
                        DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                        builder.setErrorHandler(new ErrHandler());
                        doc = builder.parse(inputSource);
                        break;
                    }
                    String nextSchema = (String)i.next();
                    readers.add(new InputSource(new StringReader(nextSchema)));
                }
            }
            catch (Exception e) {
                throw new WSIException("Could not parse XML document.", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            throw throwable;
        }
        {
            Object var10_15 = null;
            Thread.currentThread().setContextClassLoader(currentLoader);
            return doc;
        }
    }

    public static String getAttributeValue(Element element, String attrName) {
        String attrValue = null;
        Attr attr = null;
        attr = element.getAttributeNode(attrName);
        if (attr != null) {
            attrValue = attr.getValue().trim();
        }
        return attrValue;
    }

    public static String getAttributeValue(Element element, String attrName, String defaultValue) {
        String returnValue = defaultValue;
        String attrValue = null;
        attrValue = XMLUtils.getAttributeValue(element, attrName);
        if (attrValue != null) {
            returnValue = attrValue;
        }
        return returnValue;
    }

    public static String getAttributeValueNS(Element element, String namespace, String attrName) {
        String attrValue = null;
        Attr attr = null;
        attr = element.getAttributeNodeNS(namespace, attrName);
        if (attr != null) {
            attrValue = attr.getValue().trim();
        }
        return attrValue;
    }

    public static Element getFirstChild(Element element) {
        return XMLUtils.findNextSibling(element.getFirstChild());
    }

    public static Element getNextSibling(Element element) {
        return XMLUtils.findNextSibling(element.getNextSibling());
    }

    protected static Element findNextSibling(Node startNode) {
        Node node = null;
        Element returnElement = null;
        node = startNode;
        while (node != null && returnElement == null) {
            if (node.getNodeType() == 1) {
                returnElement = (Element)node;
            }
            node = node.getNextSibling();
        }
        return returnElement;
    }

    /*
     * Unable to fully structure code
     */
    public static Element findPreviousSibling(Node startNode) {
        if (startNode != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if ((startNode = startNode.getPreviousSibling()) == null) {
                return null;
            }
            if (startNode.getNodeType() != 1) continue;
            return (Element)startNode;
lbl7:
            // 2 sources

            ** while (startNode != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    public static String getText(Element element) {
        String text = null;
        Node node = element.getFirstChild();
        while (node != null && text == null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                text = ((CharacterData)node).getData();
            }
            node = node.getNextSibling();
        }
        if (text != null) {
            text = text.trim();
        }
        return text;
    }

    public static boolean equals(QName qname, Element element) {
        boolean equals = false;
        if (qname.getNamespaceURI().equals(element.getNamespaceURI()) && qname.getLocalPart().equals(element.getLocalName())) {
            equals = true;
        }
        return equals;
    }

    public static String xmlEscapedString(String text) {
        if (text == null) {
            return text;
        }
        StringBuffer sb = new StringBuffer(text.length() * 2);
        int size = text.length();
        int i = 0;
        while (i < size) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\r': {
                    sb.append("&#xd;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String xmlRemoveEscapedString(String text) {
        if (text == null) {
            return text;
        }
        StringBuffer sb = new StringBuffer(text);
        int i = sb.indexOf("&#xd;");
        while (i != -1) {
            sb.replace(i, i + 5, "\r");
            i = sb.indexOf("&#xd;");
        }
        i = sb.indexOf("&lt;");
        while (i != -1) {
            sb.replace(i, i + 4, "<");
            i = sb.indexOf("&lt;");
        }
        i = sb.indexOf("&gt;");
        while (i != -1) {
            sb.replace(i, i + 4, ">");
            i = sb.indexOf("&gt;");
        }
        i = sb.indexOf("&quot;");
        while (i != -1) {
            sb.replace(i, i + 6, "\"");
            i = sb.indexOf("&quot;");
        }
        i = sb.indexOf("&apos;");
        while (i != -1) {
            sb.replace(i, i + 6, "'");
            i = sb.indexOf("&apos;");
        }
        i = sb.indexOf("&amp;");
        while (i != -1) {
            sb.replace(i, i + 5, "&");
            i = sb.indexOf("&amp;");
        }
        return sb.toString();
    }

    public static Element getElement(String elementName, Element parentElement) {
        Element returnElement = null;
        NodeList nl = parentElement.getElementsByTagName(elementName);
        if (nl != null) {
            returnElement = (Element)nl.item(0);
        }
        return returnElement;
    }

    public static boolean isElement(Element element, String namespaceURI, String localName) {
        boolean isElement = false;
        if (element != null && element.getNamespaceURI().equals(namespaceURI) && element.getLocalName().equals(localName)) {
            isElement = true;
        }
        return isElement;
    }

    public static boolean isElement(Element element, List namespaceURIs, String localName) {
        boolean isElement = false;
        if (element != null && namespaceURIs.contains(element.getNamespaceURI()) && element.getLocalName().equals(localName)) {
            isElement = true;
        }
        return isElement;
    }

    public static boolean getBooleanValue(Element element, boolean defaultValue) {
        boolean returnValue = defaultValue;
        String booleanValue = null;
        booleanValue = XMLUtils.getText(element);
        if (booleanValue != null) {
            returnValue = Boolean.valueOf(booleanValue);
        }
        return returnValue;
    }

    public static boolean getBooleanValue(Element element, String attrName, boolean defaultValue) {
        boolean returnValue = defaultValue;
        String booleanValue = null;
        booleanValue = XMLUtils.getAttributeValue(element, attrName);
        if (booleanValue != null) {
            returnValue = Boolean.valueOf(booleanValue);
        }
        return returnValue;
    }

    public static QName createQName(String qnameString) {
        QName qname = null;
        int index = qnameString.lastIndexOf(":");
        qname = index != -1 ? new QName(qnameString.substring(0, index), qnameString.substring(index + 1)) : new QName(qnameString);
        return qname;
    }

    public static boolean isNmtoken(String text) {
        boolean nmtoken = true;
        return nmtoken;
    }

    public static Element findChildElement(Element parent, QName elementName) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent element can not be NULL");
        }
        if (elementName == null) {
            throw new IllegalArgumentException("Element name can not be NULL");
        }
        if (elementName.getLocalPart() == null) {
            throw new IllegalArgumentException("Local part of the element name can not be NULL");
        }
        Node n = parent.getFirstChild();
        String local = elementName.getLocalPart();
        String ns = elementName.getNamespaceURI();
        while (n != null) {
            if (1 == n.getNodeType() && local.equals(n.getLocalName()) && NullUtil.equals(ns, n.getNamespaceURI())) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public static Element findElement(Element active, QName elementName) {
        if (active == null) {
            throw new IllegalArgumentException("Active element can not be NULL");
        }
        if (elementName == null) {
            throw new IllegalArgumentException("Element name can not be NULL");
        }
        if (elementName.getLocalPart() == null) {
            throw new IllegalArgumentException("Local part of the element name can not be NULL");
        }
        Node n = active.getNextSibling();
        String local = elementName.getLocalPart();
        String ns = elementName.getNamespaceURI();
        while (n != null) {
            if (1 == n.getNodeType() && local.equals(n.getLocalName()) && NullUtil.equals(ns, n.getNamespaceURI())) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public static Attr getAttribute(Element el, QName attributeName) {
        if (el == null) {
            throw new IllegalArgumentException("Element can not be NULL");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name can not be NULL");
        }
        if (attributeName.getLocalPart() == null) {
            throw new IllegalArgumentException("Local part of the attribute name can not be NULL");
        }
        attributeName.getNamespaceURI();
        attributeName.getLocalPart();
        Attr a = el.getAttributeNodeNS(attributeName.getNamespaceURI(), attributeName.getLocalPart());
        if (a == null) {
            a = el.getAttributeNodeNS(null, attributeName.getLocalPart());
        }
        return a;
    }

    public static boolean equals(Node n, QName name) {
        if (n == null || name == null) {
            return false;
        }
        return NullUtil.equals(name.getLocalPart(), n.getLocalName()) && NullUtil.equals(name.getNamespaceURI(), n.getNamespaceURI());
    }

    /*
     * Unable to fully structure code
     */
    public static String findNamespaceURI(Node n, String prefix) {
        if (prefix != null) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            if (prefix.equals(n.getPrefix())) {
                return n.getNamespaceURI();
            }
            if (1 == n.getNodeType() && (m = n.getAttributes()) != null) {
                i = 0;
                while (i < m.getLength()) {
                    a = m.item(i);
                    if ("http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) && prefix.equals(a.getLocalName())) {
                        return a.getNodeValue();
                    }
                    ++i;
                }
            }
            n = n.getParentNode();
lbl14:
            // 2 sources

            ** while (n != null)
        }
lbl15:
        // 1 sources

        return null;
    }

    public static String serialize(Element n) {
        String value = null;
        try {
            StringWriter writer = new StringWriter();
            XMLSerializer s = new XMLSerializer((Writer)writer, new OutputFormat("xml", "UTF-8", true));
            s.serialize(n);
            value = writer.toString();
            writer.close();
        }
        catch (Throwable t) {
            value = "EXCEPTION : " + t.getMessage();
        }
        return value;
    }

    public static Vector getChildElements(Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Element can not be NULL");
        }
        Vector<Element> vect = new Vector<Element>();
        Element elem = XMLUtils.getFirstChild(parent);
        while (elem != null) {
            vect.add(elem);
            elem = XMLUtils.getNextSibling(elem);
        }
        return vect;
    }

    public static void serializeDoc(Document doc, Writer writer) throws Exception {
        XMLSerializer s = new XMLSerializer(writer, new OutputFormat("xml", "UTF-8", true));
        s.serialize(doc);
    }

    public static void serializeElement(Element elem, Writer writer) throws Exception {
        XMLSerializer s = new XMLSerializer(writer, new OutputFormat("xml", "UTF-8", true));
        s.serialize(elem);
    }

    public static void removeAllElementsWithoutNS(Vector vect) {
        int i = 0;
        while (i < vect.size()) {
            if (((Element)vect.get(i)).getNamespaceURI() == null || ((Element)vect.get(i)).getNamespaceURI().equals("")) {
                vect.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static URL createURL(String url, String baseURI) throws MalformedURLException {
        URL returnURL = null;
        URI uri = null;
        try {
            returnURL = new URL(url);
            uri = new URI(url);
            uri = uri.normalize();
            returnURL = new URL(uri.toString());
        }
        catch (Exception exception) {
            int i = baseURI.lastIndexOf(47);
            int j = baseURI.lastIndexOf(92);
            if (j > i) {
                i = j;
            }
            try {
                uri = new URI(String.valueOf(baseURI.substring(0, i + 1)) + url);
                uri = uri.normalize();
                returnURL = uri.toURL();
            }
            catch (Exception exception2) {
                return new URL(String.valueOf(baseURI.substring(0, i + 1)) + url);
            }
        }
        return returnURL;
    }

    public static String createURLString(String url, String baseURI) throws MalformedURLException {
        return XMLUtils.createURL(url, baseURI).toExternalForm();
    }

    public static void main(String[] args) {
        try {
            System.out.println("Filename: " + args[0] + ", schema: " + args[1]);
            XMLUtils.parseXMLDocument(args[0], args[1]);
            System.out.println("Done.");
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        System.exit(0);
    }

    private static class ErrHandler
    implements ErrorHandler {
        ErrHandler() {
        }

        public void warning(SAXParseException spe) throws SAXException {
            String message = "Warning: " + spe.getMessage();
            throw new SAXException(message);
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + spe.getMessage();
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + spe.getMessage();
            throw new SAXException(message);
        }
    }
}

