/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.preferences.SyncViewerPreferencePage;
import org.eclipse.team.internal.ui.registry.SynchronizeParticipantDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public abstract class AbstractSynchronizeParticipant
implements ISynchronizeParticipant {
    public static final String P_PINNED = "org.eclipse.team.pinned";
    private static final String CTX_PINNED = "root";
    private ListenerList fListeners;
    private String fName;
    private String fId;
    private String fSecondaryId;
    private boolean pinned;
    private ImageDescriptor fImageDescriptor;
    protected IConfigurationElement configElement;
    static /* synthetic */ Class class$0;

    public String getName() {
        return this.fName;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fImageDescriptor;
    }

    public String getId() {
        return this.fId;
    }

    public String getSecondaryId() {
        return this.fSecondaryId;
    }

    public final void setPinned(boolean pinned) {
        this.pinned = pinned;
        this.pinned(pinned);
        this.firePropertyChange(this, P_PINNED, !pinned, pinned);
    }

    public final boolean isPinned() {
        return this.pinned;
    }

    protected void pinned(boolean pinned) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ISynchronizeParticipant)) {
            return false;
        }
        ISynchronizeParticipant other = (ISynchronizeParticipant)obj;
        return this.getId().equals(other.getId()) && Utils.equalObject(this.getSecondaryId(), other.getSecondaryId());
    }

    public int hashCode() {
        return Utils.getKey(this.getId(), this.getSecondaryId()).hashCode();
    }

    public boolean doesSupportSynchronize() {
        return true;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
        if (this.fListeners == null) {
            return;
        }
        PropertyNotifier notifier = new PropertyNotifier();
        notifier.notify(new PropertyChangeEvent(source, property, oldValue, newValue));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String strIcon;
        this.configElement = config;
        this.fId = config.getAttribute("id");
        this.fName = config.getAttribute("name");
        if (config == null) {
            this.fName = "Unknown";
        }
        if ((strIcon = config.getAttribute("icon")) != null) {
            this.fImageDescriptor = TeamImages.getImageDescriptorFromExtension(this.configElement.getDeclaringExtension(), strIcon);
        }
    }

    protected void setInitializationData(ISynchronizeParticipantDescriptor descriptor) throws CoreException {
        if (!(descriptor instanceof SynchronizeParticipantDescriptor)) {
            throw new TeamException(TeamUIMessages.AbstractSynchronizeParticipant_4);
        }
        this.setInitializationData(((SynchronizeParticipantDescriptor)descriptor).getConfigurationElement(), null, null);
    }

    protected void setName(String name) {
        String old = this.fName;
        this.fName = name;
        this.firePropertyChange(this, "org.eclipse.jface.text", old, name);
    }

    protected void setImageDescriptor(ImageDescriptor imageDescriptor) {
        ImageDescriptor old = this.fImageDescriptor;
        this.fImageDescriptor = imageDescriptor;
        this.firePropertyChange(this, "org.eclipse.jface.image", old, imageDescriptor);
    }

    protected void setSecondaryId(String secondaryId) {
        this.fSecondaryId = secondaryId;
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        this.setSecondaryId(secondaryId);
        this.pinned = Boolean.valueOf(memento.getString(CTX_PINNED));
    }

    public void saveState(IMemento memento) {
        memento.putString(CTX_PINNED, Boolean.toString(this.pinned));
    }

    public final ISynchronizePageConfiguration createPageConfiguration() {
        SynchronizePageConfiguration configuration = new SynchronizePageConfiguration(this);
        if (this.isViewerContributionsSupported()) {
            configuration.setProperty("org.eclipse.team.ui.P_OBJECT_CONTRIBUTION_ID", this.getId());
        }
        this.initializeConfiguration(configuration);
        return configuration;
    }

    protected abstract void initializeConfiguration(ISynchronizePageConfiguration var1);

    public void prepareCompareInput(ISynchronizeModelElement element, CompareConfiguration config, IProgressMonitor monitor) throws TeamException {
        SyncInfo sync = this.getSyncInfo(element);
        if (sync != null) {
            Utils.updateLabels(sync, config);
        }
        if (element instanceof SyncInfoModelElement) {
            SyncInfoModelElement node = (SyncInfoModelElement)element;
            node.cacheContents(monitor);
        }
    }

    private SyncInfo getSyncInfo(ISynchronizeModelElement element) {
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.core.synchronize.SyncInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (SyncInfo)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public PreferencePage[] getPreferencePages() {
        return new PreferencePage[]{new SyncViewerPreferencePage()};
    }

    protected boolean isViewerContributionsSupported() {
        return false;
    }

    class PropertyNotifier
    implements ISafeRunnable {
        private IPropertyChangeListener fListener;
        private PropertyChangeEvent fEvent;

        PropertyNotifier() {
        }

        public void handleException(Throwable exception) {
            TeamUIPlugin.log(4, TeamUIMessages.AbstractSynchronizeParticipant_5, exception);
        }

        public void run() throws Exception {
            this.fListener.propertyChange(this.fEvent);
        }

        public void notify(PropertyChangeEvent event) {
            if (AbstractSynchronizeParticipant.this.fListeners == null) {
                return;
            }
            this.fEvent = event;
            Object[] copiedListeners = AbstractSynchronizeParticipant.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IPropertyChangeListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fListener = null;
        }
    }
}

