/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.reconcile.AbstractStructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.DirtyRegionProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorBuilder;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorStrategy;

public class DocumentRegionProcessor
extends DirtyRegionProcessor
implements IDocumentListener {
    private SourceTextInputListener fTextInputListener = null;
    private ValidatorStrategy fValidatorStrategy;
    private final String SSE_EDITOR_ID = "org.eclipse.wst.sse.ui";
    private String[] fLastPartitions;

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fTextInputListener = new SourceTextInputListener();
        textViewer.addTextInputListener((ITextInputListener)this.fTextInputListener);
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.cancel();
            this.reconcilerDocumentChanged(null);
            this.getTextViewer().removeTextInputListener((ITextInputListener)this.fTextInputListener);
            ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
            if (validatorStrategy != null && validatorStrategy instanceof IReleasable) {
                ((IReleasable)validatorStrategy).release();
            }
        }
        super.uninstall();
    }

    public void handleInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.isInstalled()) {
            this.reconcilerDocumentChanged(newInput);
            this.setDocument(newInput);
            this.setEntireDocumentDirty(newInput);
        }
    }

    public void setDocument(IDocument doc) {
        super.setDocument(doc);
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (validatorStrategy != null) {
            validatorStrategy.setDocument(doc);
        }
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
        IDocument currentDoc = this.getDocument();
        if (currentDoc != null) {
            currentDoc.removeDocumentListener((IDocumentListener)this);
        }
        if (newDocument != null) {
            newDocument.addDocumentListener((IDocumentListener)this);
        }
        super.reconcilerDocumentChanged(newDocument);
    }

    protected void process(DirtyRegion dirtyRegion) {
        if (!this.isInstalled()) {
            return;
        }
        ITypedRegion[] unfiltered = this.computePartitioning(dirtyRegion);
        ITypedRegion[] filtered = this.filterTotalScopeRegions(unfiltered);
        DirtyRegion dirty = null;
        int i = 0;
        while (i < filtered.length) {
            dirty = this.createDirtyRegion(filtered[i], "__insert");
            if (this.getValidatorStrategy() != null) {
                this.getValidatorStrategy().reconcile(filtered[i], dirty);
            }
            ++i;
        }
    }

    protected ITypedRegion[] filterTotalScopeRegions(ITypedRegion[] unfiltered) {
        IReconcilingStrategy s = null;
        HashMap<String, ITypedRegion> totalScopeRegions = new HashMap<String, ITypedRegion>();
        HashMap<String, ITypedRegion> partialScopeRegions = new HashMap<String, ITypedRegion>();
        ArrayList allRegions = new ArrayList();
        int i = 0;
        while (i < unfiltered.length) {
            String partitionType = unfiltered[i].getType();
            if (!totalScopeRegions.containsKey(partitionType) && !partialScopeRegions.containsKey(partitionType)) {
                ValidatorStrategy validatorStrategy;
                s = this.getReconcilingStrategy(partitionType);
                if (s == null && (validatorStrategy = this.getValidatorStrategy()) != null && validatorStrategy.canValidatePartition(partitionType)) {
                    s = validatorStrategy;
                }
                if (s instanceof AbstractStructuredTextReconcilingStrategy) {
                    if (((AbstractStructuredTextReconcilingStrategy)s).isTotalScope()) {
                        totalScopeRegions.put(partitionType, unfiltered[i]);
                    } else {
                        partialScopeRegions.put(partitionType, unfiltered[i]);
                    }
                } else {
                    partialScopeRegions.put(partitionType, unfiltered[i]);
                }
            }
            ++i;
        }
        allRegions.addAll(totalScopeRegions.values());
        allRegions.addAll(partialScopeRegions.values());
        ITypedRegion[] filtered = allRegions.toArray(new ITypedRegion[allRegions.size()]);
        if (DEBUG) {
            System.out.println("filtered out this many 'total-scope' regions: " + (unfiltered.length - filtered.length));
        }
        return filtered;
    }

    public ValidatorStrategy getValidatorStrategy() {
        if (this.fValidatorStrategy == null) {
            ValidatorStrategy validatorStrategy = null;
            if (this.getTextViewer() instanceof ISourceViewer) {
                ISourceViewer viewer = (ISourceViewer)this.getTextViewer();
                String contentTypeId = null;
                IDocument doc = viewer.getDocument();
                contentTypeId = this.getContentType(doc);
                if (contentTypeId != null) {
                    validatorStrategy = new ValidatorStrategy(viewer, contentTypeId);
                    ValidatorBuilder vBuilder = new ValidatorBuilder();
                    ValidatorMetaData[] vmds = vBuilder.getValidatorMetaData("org.eclipse.wst.sse.ui");
                    int i = 0;
                    while (i < vmds.length) {
                        if (vmds[i].canHandleContentType(contentTypeId)) {
                            validatorStrategy.addValidatorMetaData(vmds[i]);
                        }
                        ++i;
                    }
                }
            }
            this.fValidatorStrategy = validatorStrategy;
        }
        return this.fValidatorStrategy;
    }

    protected String getContentType(IDocument doc) {
        if (doc == null) {
            return null;
        }
        String contentTypeId = null;
        IContentType ct = null;
        try {
            IContentDescription desc = Platform.getContentTypeManager().getDescriptionFor((InputStream)new ByteArrayInputStream(doc.get().getBytes()), null, IContentDescription.ALL);
            if (desc != null && (ct = desc.getContentType()) != null) {
                contentTypeId = ct.getId();
            }
        }
        catch (IOException iOException) {}
        return contentTypeId;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.fLastPartitions = this.getPartitions(event.getOffset(), event.getLength());
    }

    public void documentChanged(DocumentEvent event) {
        if (this.partitionsChanged(event)) {
            this.setEntireDocumentDirty(this.getDocument());
        } else {
            DirtyRegion dr = null;
            dr = event.getLength() == 0 ? this.createDirtyRegion(event.getOffset(), 0, "__insert") : ("".equals(event.getText()) ? this.createDirtyRegion(event.getOffset(), event.getLength(), "__remove") : this.createDirtyRegion(event.getOffset(), event.getLength(), "__insert"));
            this.processDirtyRegion(dr);
        }
    }

    private boolean partitionsChanged(DocumentEvent event) {
        boolean changed = false;
        String[] newPartitions = this.getPartitions(event.getOffset(), event.getLength());
        if (this.fLastPartitions != null) {
            if (this.fLastPartitions.length != newPartitions.length) {
                changed = true;
            } else {
                int i = 0;
                while (i < this.fLastPartitions.length) {
                    if (!this.fLastPartitions[i].equals(newPartitions[i])) {
                        changed = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return changed;
    }

    protected void setEntireDocumentDirty(IDocument document) {
        if (document != null && this.isInstalled()) {
            this.getDirtyRegionQueue().clear();
            DirtyRegion entireDocument = this.createDirtyRegion(0, document.getLength(), "__insert");
            this.processDirtyRegion(entireDocument);
        }
    }

    private class SourceTextInputListener
    implements ITextInputListener {
        SourceTextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            DocumentRegionProcessor.this.handleInputDocumentChanged(oldInput, newInput);
        }
    }
}

