/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ReconcileStepForValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorStrategy
extends StructuredTextReconcilingStrategy {
    private String[] fContentTypeIds = null;
    private HashMap fVidToVStepMap = null;
    private List fMetaData = new ArrayList();

    public ValidatorStrategy(ISourceViewer sourceViewer, String contentType) {
        super(sourceViewer);
        this.fContentTypeIds = this.calculateParentContentTypeIds(contentType);
        this.fVidToVStepMap = new HashMap();
    }

    private String[] calculateParentContentTypeIds(String contentTypeId) {
        HashSet<String> parentTypes = new HashSet<String>();
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType ct = ctManager.getContentType(contentTypeId);
        String id = contentTypeId;
        while (ct != null && id != null) {
            parentTypes.add(id);
            ct = ctManager.getContentType(id);
            if (ct == null) continue;
            IContentType baseType = ct.getBaseType();
            String string = id = baseType != null ? baseType.getId() : null;
        }
        return parentTypes.toArray(new String[parentTypes.size()]);
    }

    public void addValidatorMetaData(ValidatorMetaData vmd) {
        this.fMetaData.add(vmd);
    }

    public boolean canValidatePartition(String partitionType) {
        ValidatorMetaData vmd = null;
        int i = 0;
        while (i < this.fMetaData.size()) {
            vmd = (ValidatorMetaData)this.fMetaData.get(i);
            if (vmd.canHandleParitionType(this.getContentTypeIds(), partitionType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean canHandlePartition(String partition) {
        return this.canValidatePartition(partition);
    }

    protected boolean containsStep(IReconcileStep step) {
        return step != null ? this.fVidToVStepMap.values().contains(step) : false;
    }

    public void createReconcileSteps() {
    }

    public String[] getContentTypeIds() {
        return this.fContentTypeIds;
    }

    public String[] getPartitionTypes() {
        ArrayList<String> partitionTypes = new ArrayList<String>();
        Iterator keys = this.fVidToVStepMap.keySet().iterator();
        String key = null;
        while (keys.hasNext()) {
            key = (String)keys.next();
            StructuredReconcileStep step = (StructuredReconcileStep)this.fVidToVStepMap.get(key);
            partitionTypes.addAll(Arrays.asList(step.getPartitionTypes()));
        }
        return partitionTypes.toArray(new String[partitionTypes.size()]);
    }

    public void reconcile(ITypedRegion tr, DirtyRegion dr) {
        if (this.isCanceled()) {
            return;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        String partitionType = tr.getType();
        if (this.canValidatePartition(partitionType)) {
            ValidatorMetaData vmd = null;
            ArrayList<IReconcileResult> annotationsToAdd = new ArrayList<IReconcileResult>();
            int i = 0;
            while (i < this.fMetaData.size() && !this.isCanceled()) {
                vmd = (ValidatorMetaData)this.fMetaData.get(i);
                if (vmd.canHandleParitionType(this.getContentTypeIds(), partitionType)) {
                    Object o = this.fVidToVStepMap.get(vmd.getValidatorId());
                    ReconcileStepForValidator validatorStep = null;
                    if (o != null) {
                        validatorStep = (ReconcileStepForValidator)o;
                    } else {
                        IValidator validator = vmd.createValidator();
                        validatorStep = new ReconcileStepForValidator(validator, vmd.getValidatorScope());
                        validatorStep.setInputModel(new DocumentAdapter(doc));
                        this.fVidToVStepMap.put(vmd.getValidatorId(), validatorStep);
                    }
                    annotationsToAdd.addAll(Arrays.asList(validatorStep.reconcile(dr, (IRegion)dr)));
                }
                ++i;
            }
            TemporaryAnnotation[] annotationsToRemove = this.getAnnotationsToRemove(dr);
            if (annotationsToRemove.length + annotationsToAdd.size() > 0) {
                this.smartProcess(annotationsToRemove, annotationsToAdd.toArray(new IReconcileResult[annotationsToAdd.size()]));
            }
        }
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            step.setInputModel((IReconcilableModel)new DocumentAdapter(document));
        }
    }

    public void release() {
        super.release();
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            if (!(step instanceof IReleasable)) continue;
            ((IReleasable)step).release();
        }
    }

    public boolean isTotalScope() {
        return true;
    }
}

