/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class WSTWebPreferences {
    private Plugin owner = null;
    private Preferences preferences = null;
    private boolean persistOnChange = false;

    public WSTWebPreferences(Plugin owner) {
        this.owner = owner;
    }

    protected void initializeDefaultPreferences() {
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preference.staticWebContentName", "WebContent");
    }

    public String getStaticWebContentFolderName() {
        return this.getPreferences().getString("org.eclipse.jst.j2ee.preference.staticWebContentName");
    }

    public void setStaticWebContentFolderName(String value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preference.staticWebContentName", value);
        this.firePreferenceChanged();
    }

    public void firePreferenceChanged() {
        if (this.isPersistOnChange()) {
            this.persist();
        }
    }

    public void persist() {
        this.getOwner().savePluginPreferences();
    }

    public boolean isPersistOnChange() {
        return this.persistOnChange;
    }

    public void setPersistOnChange(boolean persistOnChange) {
        this.persistOnChange = persistOnChange;
    }

    private Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.getOwner().getPluginPreferences();
        }
        return this.preferences;
    }

    private Plugin getOwner() {
        return this.owner;
    }

    public static interface Keys {
        public static final String STATIC_WEB_CONTENT = "org.eclipse.jst.j2ee.preference.staticWebContentName";
    }

    public static interface Values {
        public static final String STATIC_WEB_CONTENT = "WebContent";
    }

    public static interface Defaults {
        public static final String STATIC_WEB_CONTENT = "WebContent";
    }
}

