/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WSTWebUIPlugin
extends AbstractUIPlugin {
    private static WSTWebUIPlugin plugin;
    public static final String[] ICON_DIRS;

    static {
        ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/ctool16", "icons/full/wizban", "icons", ""};
    }

    public WSTWebUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = WSTWebUIPlugin.getImageURL(key, this.getBundle());
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }

    public static URL getImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (bundle.getEntry(path.toString()) != null) {
                try {
                    return new URL(bundle.getEntry("/"), path.toString());
                }
                catch (MalformedURLException exception) {
                    Logger.getLogger().logWarning("Load_Image_Error_");
                    exception.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public static WSTWebUIPlugin getDefault() {
        return plugin;
    }
}

