/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

class TaskWizardPage
extends WizardPage
implements IWizardHandle {
    protected WizardFragment fragment;
    protected boolean isEmptyError = false;

    public TaskWizardPage(WizardFragment fragment) {
        super(fragment.toString());
        this.fragment = fragment;
    }

    public void createControl(Composite parentComp) {
        Composite comp = null;
        try {
            comp = this.fragment.createComposite(parentComp, this);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not create wizard page composite", e);
        }
        if (comp == null) {
            comp = new Composite(parentComp, 0);
            comp.setLayout((Layout)new FillLayout(512));
            Label label = new Label(comp, 0);
            label.setText("Internal error");
        }
        GridData data = new GridData(256);
        data.widthHint = this.convertHorizontalDLUsToPixels(150);
        comp.setLayoutData((Object)data);
        this.setControl((Control)comp);
    }

    public boolean isPageComplete() {
        try {
            if (!this.fragment.isComplete()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        if (this.getNextPage() == null) {
            return false;
        }
        try {
            if (!this.fragment.isComplete()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            TaskWizard wizard = (TaskWizard)this.getWizard();
            wizard.switchWizardFragment(this.fragment);
            if (this.getContainer().getCurrentPage() != null) {
                this.getContainer().updateButtons();
            }
        }
    }

    public void setMessage(String message, int type) {
        if (type == 3 && "".equals(message)) {
            this.isEmptyError = true;
            message = null;
        } else {
            this.isEmptyError = false;
        }
        super.setMessage(message, type);
        WizardFragment frag = ((TaskWizard)this.getWizard()).getCurrentWizardFragment();
        if (!this.fragment.equals(frag)) {
            return;
        }
        this.getContainer().updateButtons();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InterruptedException, InvocationTargetException {
        this.getWizard().getContainer().run(fork, cancelable, runnable);
    }

    public void update() {
        this.fragment.updateChildFragments();
        ((TaskWizard)this.getWizard()).updatePages();
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }
}

