/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.project.facet.J2EEModuleFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WebFacetInstallDataModelProvider
extends J2EEModuleFacetInstallDataModelProvider
implements IWebFacetInstallDataModelProperties {
    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
        names.add("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            return "WebContent";
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
            return "src";
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.getProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME");
        }
        if (propertyName.equals("IFacetDataModelPropeties.FACET_ID")) {
            return "jst.web";
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 3);
        } else if ("IFacetDataModelPropeties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 4);
        } else {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map;
            IDataModel javaModel;
            IDataModel masterModel;
            if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
                return true;
            }
            if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER") && (masterModel = (IDataModel)this.model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM")) != null && (javaModel = (map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)masterModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel("jst.java")) != null) {
                javaModel.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", propertyValue);
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public boolean isPropertyEnabled(String propertyName) {
        return super.isPropertyEnabled(propertyName);
    }

    protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
        return J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)version.getVersionString());
    }

    public IStatus validate(String name) {
        if (name.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT") && this.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            return this.validateContextRoot(this.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT"));
        }
        return super.validate(name);
    }

    protected IStatus validateContextRoot(String contextRoot) {
        if (contextRoot.equals("") || contextRoot == null) {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Context_Root_cannot_be_empty_2, (Object[])new Object[]{contextRoot}), null);
        }
        if (contextRoot.trim().equals(contextRoot)) {
            StringTokenizer stok = new StringTokenizer(contextRoot, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i))) {
                        Object[] invalidChar = new Object[]{new Character(token.charAt(i)).toString()};
                        String errorStatus = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.The_character_is_invalid_in_a_context_root, (Object[])invalidChar);
                        return J2EEPlugin.newErrorStatus((String)errorStatus, null);
                    }
                    ++i;
                }
            }
        } else {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Names_cannot_begin_or_end_with_whitespace_5, (Object[])new Object[]{contextRoot}), null);
        }
        return OK_STATUS;
    }
}

