/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointFieldLocator;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifierJob;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointMethodLocator;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    protected void report(final String message, final IWorkbenchPart part) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((statusLine = (IEditorStatusLine)part.getAdapter((Class)clazz)) != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return type;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, false);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, final boolean bestMatch) {
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor textEditor = ToggleBreakpointAdapter.this.getTextEditor(part);
                if (textEditor != null && selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ToggleBreakpointAdapter.this.report(null, part);
                    ITextSelection textSelection = (ITextSelection)selection;
                    IType type = ToggleBreakpointAdapter.this.getType(textSelection);
                    IEditorInput editorInput = textEditor.getEditorInput();
                    IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                    if (documentProvider == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IDocument document = documentProvider.getDocument((Object)editorInput);
                    int lineNumber = textSelection.getStartLine() + 1;
                    int offset = textSelection.getOffset();
                    try {
                        if (type == null) {
                            IClassFile classFile;
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.IClassFile");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((classFile = (IClassFile)editorInput.getAdapter((Class)clazz)) != null && (type = classFile.getType()).getDeclaringType() != null) {
                                ISourceRange sourceRange = type.getSourceRange();
                                int start = sourceRange.getOffset();
                                int end = start + sourceRange.getLength();
                                if (offset < start || offset > end) {
                                    IStatusLineManager statusLine = textEditor.getEditorSite().getActionBars().getStatusLineManager();
                                    statusLine.setErrorMessage(MessageFormat.format(ActionMessages.ManageBreakpointRulerAction_Breakpoints_can_only_be_created_within_the_type_associated_with_the_editor___0___1, type.getTypeQualifiedName()));
                                    Display.getCurrent().beep();
                                    return Status.OK_STATUS;
                                }
                            }
                        }
                        String typeName = null;
                        IResource resource = null;
                        HashMap attributes = new HashMap(10);
                        if (type == null) {
                            resource = ToggleBreakpointAdapter.getResource((IEditorPart)textEditor);
                            CompilationUnit unit = ToggleBreakpointAdapter.this.parseCompilationUnit(textEditor);
                            Iterator types = unit.types().iterator();
                            while (types.hasNext()) {
                                TypeDeclaration declaration = (TypeDeclaration)types.next();
                                int begin = declaration.getStartPosition();
                                int end = begin + declaration.getLength();
                                if (offset < begin || offset > end || declaration.isInterface()) continue;
                                typeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)declaration);
                                break;
                            }
                        } else {
                            typeName = type.getFullyQualifiedName();
                            int index = typeName.indexOf(36);
                            if (index >= 0) {
                                typeName = typeName.substring(0, index);
                            }
                            resource = BreakpointUtils.getBreakpointResource((IMember)type);
                            try {
                                IRegion line = document.getLineInformation(lineNumber - 1);
                                int start = line.getOffset();
                                int end = start + line.getLength() - 1;
                                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, start, end);
                            }
                            catch (BadLocationException ble) {
                                JDIDebugUIPlugin.log(ble);
                            }
                        }
                        if (typeName != null && resource != null) {
                            IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)typeName, (int)lineNumber);
                            if (existingBreakpoint != null) {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                                return Status.OK_STATUS;
                            }
                            ToggleBreakpointAdapter.this.createLineBreakpoint(resource, typeName, lineNumber, -1, -1, 0, true, attributes, document, bestMatch, type, (IEditorPart)textEditor);
                        }
                    }
                    catch (CoreException ce) {
                        return ce.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void createLineBreakpoint(IResource resource, String typeName, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes, IDocument document, boolean bestMatch, IType type, IEditorPart editorPart) throws CoreException {
        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)typeName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
        new BreakpointLocationVerifierJob(document, breakpoint, lineNumber, bestMatch, typeName, type, resource, editorPart).schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Method Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    ToggleBreakpointAdapter.this.report(null, part);
                    ISelection selection = finalSelection;
                    selection = ToggleBreakpointAdapter.this.translateToMembers(part, selection);
                    ITextEditor textEditor = ToggleBreakpointAdapter.this.getTextEditor(part);
                    if (textEditor != null && selection instanceof ITextSelection) {
                        CompilationUnit compilationUnit;
                        ITextSelection textSelection = (ITextSelection)selection;
                        if (selection != null && (compilationUnit = ToggleBreakpointAdapter.this.parseCompilationUnit(textEditor)) != null) {
                            BreakpointMethodLocator locator = new BreakpointMethodLocator(textSelection.getOffset());
                            compilationUnit.accept((ASTVisitor)locator);
                            String methodName = locator.getMethodName();
                            if (methodName == null) {
                                ToggleBreakpointAdapter.this.report(ActionMessages.ManageMethodBreakpointActionDelegate_CantAdd, part);
                                return Status.OK_STATUS;
                            }
                            String typeName = locator.getTypeName();
                            String methodSignature = locator.getMethodSignature();
                            if (methodSignature == null) {
                                ToggleBreakpointAdapter.this.report(ActionMessages.ManageMethodBreakpointActionDelegate_methodNonAvailable, part);
                                return Status.OK_STATUS;
                            }
                            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
                            int i = 0;
                            while (i < breakpoints.length) {
                                IJavaMethodBreakpoint methodBreakpoint;
                                IBreakpoint breakpoint = breakpoints[i];
                                if (breakpoint instanceof IJavaMethodBreakpoint && typeName.equals((methodBreakpoint = (IJavaMethodBreakpoint)breakpoint).getTypeName()) && methodName.equals(methodBreakpoint.getMethodName()) && methodSignature.equals(methodBreakpoint.getMethodSignature())) {
                                    ToggleBreakpointAdapter.this.removeBreakpoint(breakpoint, true);
                                    return Status.OK_STATUS;
                                }
                                ++i;
                            }
                            ToggleBreakpointAdapter.this.createMethodBreakpoint(ToggleBreakpointAdapter.getResource((IEditorPart)part), typeName, methodName, methodSignature, true, false, false, -1, -1, -1, 0, true, new HashMap(10));
                        }
                    } else if (selection instanceof IStructuredSelection) {
                        IMethod[] members = ToggleBreakpointAdapter.this.getMethods((IStructuredSelection)selection);
                        if (members.length == 0) {
                            ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_9, part);
                            return Status.OK_STATUS;
                        }
                        int i = 0;
                        int length = members.length;
                        while (i < length) {
                            IMethod method = members[i];
                            IJavaBreakpoint breakpoint = ToggleBreakpointAdapter.this.getBreakpoint((IMember)method);
                            if (breakpoint == null) {
                                int start = -1;
                                int end = -1;
                                ISourceRange range = method.getNameRange();
                                if (range != null) {
                                    start = range.getOffset();
                                    end = start + range.getLength();
                                }
                                HashMap attributes = new HashMap(10);
                                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)method);
                                IType type = method.getDeclaringType();
                                String methodSignature = method.getSignature();
                                String methodName = method.getElementName();
                                if (method.isConstructor()) {
                                    methodName = "<init>";
                                    if (type.isEnum()) {
                                        methodSignature = "(Ljava.lang.String;I" + methodSignature.substring(1);
                                    }
                                }
                                if (!type.isBinary() && (methodSignature = ToggleBreakpointAdapter.resolveMethodSignature(type, methodSignature)) == null) {
                                    return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, "Source method signature could not be resolved", null);
                                }
                                ToggleBreakpointAdapter.this.createMethodBreakpoint(BreakpointUtils.getBreakpointResource((IMember)method), type.getFullyQualifiedName(), methodName, methodSignature, true, false, false, -1, start, end, 0, true, attributes);
                            } else {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)breakpoint, true);
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, delete);
    }

    private void createMethodBreakpoint(IResource resource, String typeName, String methodName, String methodSignature, boolean entry, boolean exit, boolean nativeOnly, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)typeName, (String)methodName, (String)methodSignature, (boolean)entry, (boolean)exit, (boolean)nativeOnly, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.getMethods(ss).length > 0;
        }
        return selection instanceof ITextSelection;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextEditor)part.getAdapter((Class)clazz);
    }

    protected IMethod[] getMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList methods = new ArrayList(selection.size());
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object thing = iterator.next();
            try {
                if (!(thing instanceof IMethod) || Flags.isAbstract((int)((IMethod)thing).getFlags())) continue;
                methods.add(thing);
            }
            catch (JavaModelException javaModelException) {}
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected IField[] getFields(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IField[0];
        }
        ArrayList fields = new ArrayList(selection.size());
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            IField field;
            Object thing = iterator.next();
            if (thing instanceof IField) {
                fields.add(thing);
                continue;
            }
            if (!(thing instanceof IJavaFieldVariable) || (field = this.getField((IJavaFieldVariable)thing)) == null) continue;
            fields.add(field);
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private boolean isFields(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object thing = iterator.next();
                if (thing instanceof IField || thing instanceof IJavaFieldVariable) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void toggleWatchpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Watchpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    ToggleBreakpointAdapter.this.report(null, part);
                    ISelection selection = finalSelection;
                    selection = ToggleBreakpointAdapter.this.translateToMembers(part, selection);
                    ITextEditor textEditor = ToggleBreakpointAdapter.this.getTextEditor(part);
                    if (textEditor != null && selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        CompilationUnit compilationUnit = ToggleBreakpointAdapter.this.parseCompilationUnit(textEditor);
                        if (compilationUnit != null) {
                            BreakpointFieldLocator locator = new BreakpointFieldLocator(textSelection.getOffset());
                            compilationUnit.accept((ASTVisitor)locator);
                            String fieldName = locator.getFieldName();
                            if (fieldName == null) {
                                ToggleBreakpointAdapter.this.report(ActionMessages.ManageWatchpointActionDelegate_CantAdd, part);
                                return Status.OK_STATUS;
                            }
                            String typeName = locator.getTypeName();
                            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
                            int i = 0;
                            while (i < breakpoints.length) {
                                IJavaWatchpoint watchpoint;
                                IBreakpoint breakpoint = breakpoints[i];
                                if (breakpoint instanceof IJavaWatchpoint && typeName.equals((watchpoint = (IJavaWatchpoint)breakpoint).getTypeName()) && fieldName.equals(watchpoint.getFieldName())) {
                                    ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)watchpoint, true);
                                    return Status.OK_STATUS;
                                }
                                ++i;
                            }
                            ToggleBreakpointAdapter.this.createWatchpoint(ToggleBreakpointAdapter.getResource((IEditorPart)part), typeName, fieldName, -1, -1, -1, 0, true, new HashMap(10));
                        }
                    } else if (selection instanceof IStructuredSelection) {
                        IField[] members = ToggleBreakpointAdapter.this.getFields((IStructuredSelection)selection);
                        if (members.length == 0) {
                            ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_10, part);
                            return Status.OK_STATUS;
                        }
                        int i = 0;
                        int length = members.length;
                        while (i < length) {
                            IField element = members[i];
                            IJavaBreakpoint breakpoint = ToggleBreakpointAdapter.this.getBreakpoint((IMember)element);
                            if (breakpoint == null) {
                                IType type = element.getDeclaringType();
                                int start = -1;
                                int end = -1;
                                ISourceRange range = element.getNameRange();
                                if (range != null) {
                                    start = range.getOffset();
                                    end = start + range.getLength();
                                }
                                HashMap attributes = new HashMap(10);
                                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)element);
                                ToggleBreakpointAdapter.this.createWatchpoint(BreakpointUtils.getBreakpointResource((IMember)type), type.getFullyQualifiedName(), element.getElementName(), -1, start, end, 0, true, attributes);
                            } else {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)breakpoint, true);
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void createWatchpoint(IResource resource, String typeName, String fieldName, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        JDIDebugModel.createWatchpoint((IResource)resource, (String)typeName, (String)fieldName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
    }

    public static String resolveMethodSignature(IType type, String methodSignature) throws JavaModelException {
        String[] parameterTypes = Signature.getParameterTypes((String)methodSignature);
        int length = parameterTypes.length;
        String[] resolvedParameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            resolvedParameterTypes[i] = ToggleBreakpointAdapter.resolveType(type, parameterTypes[i]);
            if (resolvedParameterTypes[i] == null) {
                return null;
            }
            ++i;
        }
        String resolvedReturnType = ToggleBreakpointAdapter.resolveType(type, Signature.getReturnType((String)methodSignature));
        if (resolvedReturnType == null) {
            return null;
        }
        return Signature.createMethodSignature((String[])resolvedParameterTypes, (String)resolvedReturnType);
    }

    private static String resolveType(IType type, String typeSignature) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeSignature);
        String elementTypeSignature = Signature.getElementType((String)typeSignature);
        if (elementTypeSignature.length() == 1) {
            return typeSignature;
        }
        String elementTypeName = Signature.toString((String)elementTypeSignature);
        String[][] resolvedElementTypeNames = type.resolveType(elementTypeName);
        if (resolvedElementTypeNames == null || resolvedElementTypeNames.length != 1) {
            return null;
        }
        String resolvedElementTypeName = Signature.toQualifiedName((String[])resolvedElementTypeNames[0]);
        String resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true).replace('.', '/');
        return Signature.createArraySignature((String)resolvedElementTypeSignature, (int)count);
    }

    protected static IResource getResource(IEditorPart editor) {
        IResource resource;
        IEditorInput editorInput = editor.getEditorInput();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)editorInput.getAdapter((Class)clazz)) == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    protected IMethod getMethodHandle(IEditorPart editorPart, String typeName, String methodName, String signature) throws CoreException {
        IEditorInput iEditorInput = editorPart.getEditorInput();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJavaElement element = (IJavaElement)iEditorInput.getAdapter((Class)clazz);
        IType type = null;
        if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i].getFullyQualifiedName().equals(typeName)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        }
        if (type != null) {
            String[] sigs = Signature.getParameterTypes((String)signature);
            return type.getMethod(methodName, sigs);
        }
        return null;
    }

    protected IJavaBreakpoint getBreakpoint(IMember element) {
        block17: {
            IBreakpoint[] breakpoints;
            block16: {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
                if (!(element instanceof IMethod)) break block16;
                IMethod method = (IMethod)element;
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (breakpoint instanceof IJavaMethodBreakpoint) {
                        IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                        IMember container = null;
                        try {
                            container = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
                        }
                        catch (CoreException e) {
                            JDIDebugUIPlugin.log(e);
                            return null;
                        }
                        if (container == null) {
                            try {
                                if (method.getDeclaringType().getFullyQualifiedName().equals(methodBreakpoint.getTypeName()) && method.getElementName().equals(methodBreakpoint.getMethodName()) && method.getSignature().equals(methodBreakpoint.getMethodSignature())) {
                                    return methodBreakpoint;
                                }
                            }
                            catch (CoreException e) {
                                JDIDebugUIPlugin.log(e);
                            }
                        } else if (container instanceof IMethod && method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) && method.isSimilar((IMethod)container)) {
                            return methodBreakpoint;
                        }
                    }
                    ++i;
                }
                break block17;
            }
            if (!(element instanceof IField)) break block17;
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaWatchpoint) {
                    try {
                        if (this.equalFields(element, (IJavaWatchpoint)breakpoint)) {
                            return (IJavaBreakpoint)breakpoint;
                        }
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private boolean equalFields(IMember breakpointField, IJavaWatchpoint watchpoint) throws CoreException {
        return breakpointField.getElementName().equals(watchpoint.getFieldName()) && breakpointField.getDeclaringType().getFullyQualifiedName().equals(watchpoint.getTypeName());
    }

    protected CompilationUnit parseCompilationUnit(ITextEditor editor) throws CoreException {
        IEditorInput editorInput = editor.getEditorInput();
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(document.get().toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.isFields(ss);
        }
        return selection instanceof ITextSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (selection instanceof ITextSelection && textEditor != null) {
            IClassFile classFile;
            ITextSelection textSelection = (ITextSelection)selection;
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            int offset = textSelection.getOffset();
            if (document != null) {
                try {
                    IRegion region = document.getLineInformationOfOffset(offset);
                    int end = region.getOffset() + region.getLength();
                    while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                        ++offset;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            IMember m = null;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.IClassFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((classFile = (IClassFile)editorInput.getAdapter((Class)clazz)) != null) {
                IJavaElement e = classFile.getElementAt(offset);
                if (e instanceof IMember) {
                    m = (IMember)e;
                }
            } else {
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit unit = manager.getWorkingCopy(editorInput);
                if (unit != null) {
                    ICompilationUnit iCompilationUnit = unit;
                    synchronized (iCompilationUnit) {
                        unit.reconcile(0, false, null, null);
                    }
                    IJavaElement e = unit.getElementAt(offset);
                    if (e instanceof IMember) {
                        m = (IMember)e;
                    }
                }
            }
            if (m != null) {
                return new StructuredSelection((Object)m);
            }
        }
        return selection;
    }

    protected static List searchForTypes(String typeName, ILaunch launch) {
        ArrayList<IType> types = new ArrayList<IType>();
        if (launch == null) {
            return types;
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        IJavaProject[] javaProjects = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (configuration != null) {
            try {
                String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                if (projectName.length() != 0) {
                    javaProjects = new IJavaProject[]{JavaCore.create((IProject)workspace.getRoot().getProject(projectName))};
                } else {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    ArrayList<IJavaProject> projectList = new ArrayList<IJavaProject>();
                    int i = 0;
                    int numProjects = projects.length;
                    while (i < numProjects) {
                        IProject project = projects[i];
                        if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                            projectList.add(JavaCore.create((IProject)project));
                        }
                        ++i;
                    }
                    javaProjects = new IJavaProject[projectList.size()];
                    projectList.toArray(javaProjects);
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        if (javaProjects == null) {
            return types;
        }
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProjects, (boolean)true);
        ArrayList typeRefsFound = new ArrayList(3);
        TypeInfoRequestor requestor = new TypeInfoRequestor(typeRefsFound);
        try {
            engine.searchAllTypeNames(ToggleBreakpointAdapter.getPackage(typeName), ToggleBreakpointAdapter.getTypeName(typeName), 8, 0, scope, (TypeNameRequestor)requestor, 3, null);
        }
        catch (JavaModelException x) {
            JDIDebugUIPlugin.log(x);
            return types;
        }
        Iterator iter = typeRefsFound.iterator();
        TypeInfo typeInfo = null;
        while (iter.hasNext()) {
            typeInfo = (TypeInfo)iter.next();
            try {
                types.add(typeInfo.resolveType(scope));
            }
            catch (JavaModelException jme) {
                JDIDebugUIPlugin.log(jme);
            }
        }
        return types;
    }

    private static char[] getPackage(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index == -1) {
            return new char[0];
        }
        return fullyQualifiedName.substring(0, index).toCharArray();
    }

    private static char[] getTypeName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        String typeName = fullyQualifiedName;
        if (index >= 0) {
            typeName = fullyQualifiedName.substring(index + 1);
        }
        if ((index = typeName.lastIndexOf(36)) >= 0) {
            typeName = typeName.substring(index + 1);
        }
        return typeName.toCharArray();
    }

    private IField getField(IJavaFieldVariable variable) {
        String varName = null;
        try {
            varName = variable.getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        String declaringType = null;
        try {
            declaringType = variable.getDeclaringType().getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        List types = ToggleBreakpointAdapter.searchForTypes(declaringType, variable.getLaunch());
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            IField field = type.getField(varName);
            if (!field.exists()) continue;
            return field;
        }
        return null;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, true);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }
}

