/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.viewers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemImportWizard;
import org.eclipse.wst.common.ui.internal.UIPlugin;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;

public class SelectSingleFileView {
    protected Composite composite;
    protected IStructuredSelection selection;
    protected boolean isFileMandatory;
    protected TreeViewer sourceFileViewer;
    protected Button importButton;
    protected Vector fFilters;
    protected IFile selectedFile;
    protected ISelection defaultSelection;
    protected Listener listener;

    public SelectSingleFileView(IStructuredSelection selection, boolean isFileMandatory) {
        this.selection = selection;
        this.isFileMandatory = isFileMandatory;
        this.selectedFile = null;
        this.defaultSelection = null;
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(UIPlugin.getResourceString("_UI_LABEL_SOURCE_FILES"));
        this.createSourceViewer(composite);
        this.createFilterControl(composite);
        this.createImportButton(composite);
        return composite;
    }

    protected void createFilterControl(Composite composite) {
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected void createSourceViewer(Composite parent) {
        this.sourceFileViewer = new TreeViewer(new Tree(parent, 2052));
        this.sourceFileViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.sourceFileViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.sourceFileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isComplete = true;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    List list = ((IStructuredSelection)selection).toList();
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        IResource resource = (IResource)i.next();
                        if (resource instanceof IFile) {
                            SelectSingleFileView.this.selectedFile = (IFile)resource;
                            if (!SelectSingleFileView.this.isFileMandatory) continue;
                            isComplete = true;
                            break;
                        }
                        SelectSingleFileView.this.selectedFile = null;
                        if (!SelectSingleFileView.this.isFileMandatory) continue;
                        isComplete = false;
                    }
                    if (SelectSingleFileView.this.listener != null) {
                        SelectSingleFileView.this.listener.setControlComplete(isComplete);
                    }
                }
            }
        });
        Tree treeWidget = this.sourceFileViewer.getTree();
        GridData gd = new GridData(1808);
        treeWidget.setLayoutData((Object)gd);
    }

    protected void createImportButton(Composite parent) {
        this.importButton = new Button(parent, 0);
        this.importButton.setText(UIPlugin.getResourceString("_UI_IMPORT_BUTTON"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        this.importButton.setLayoutData((Object)gridData);
        this.importButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportAddResourceListener importAddResourceListener = new ImportAddResourceListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)importAddResourceListener);
                FileSystemImportWizard importWizard = new FileSystemImportWizard();
                IWorkbench workbench = UIPlugin.getDefault().getWorkbench();
                SelectSingleFileView.this.selection = (IStructuredSelection)SelectSingleFileView.this.sourceFileViewer.getSelection();
                importWizard.init(workbench, (IStructuredSelection)(SelectSingleFileView.this.selection != null ? SelectSingleFileView.this.selection : new StructuredSelection()));
                Shell shell = Display.getCurrent().getActiveShell();
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)importWizard);
                wizardDialog.create();
                wizardDialog.open();
                SelectSingleFileView.this.sourceFileViewer.refresh();
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)importAddResourceListener);
                IFile importedFile = importAddResourceListener.getImportedFile();
                if (importedFile != null) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)importedFile);
                    SelectSingleFileView.this.sourceFileViewer.setSelection((ISelection)structuredSelection);
                }
            }
        });
        this.importButton.setToolTipText(UIPlugin.getResourceString("_UI_IMPORT_BUTTON_TOOL_TIP"));
    }

    public IFile getFile() {
        return this.selectedFile;
    }

    public void setDefaultSelection(ISelection selection) {
        this.defaultSelection = selection;
    }

    public void resetFilters() {
        this.fFilters = null;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new Vector();
        }
        this.fFilters.add(filter);
    }

    public void addFilterExtensions(String[] filterExtensions) {
        String[] correctedFilterExtensions = new String[filterExtensions.length];
        int i = 0;
        while (i < filterExtensions.length) {
            correctedFilterExtensions[i] = filterExtensions[i].startsWith(".") ? filterExtensions[i] : "." + filterExtensions[i];
            ++i;
        }
        ResourceFilter filter = new ResourceFilter(correctedFilterExtensions, null);
        this.addFilter(filter);
    }

    public void addFilterExtensions(String[] filterExtensions, IFile[] excludedFiles) {
        String[] correctedFilterExtensions = new String[filterExtensions.length];
        int i = 0;
        while (i < filterExtensions.length) {
            correctedFilterExtensions[i] = filterExtensions[i].startsWith(".") ? filterExtensions[i] : "." + filterExtensions[i];
            ++i;
        }
        ResourceFilter filter = excludedFiles != null ? new ResourceFilter(correctedFilterExtensions, excludedFiles, null) : new ResourceFilter(correctedFilterExtensions, null);
        this.addFilter(filter);
    }

    public void setFilterExtensions(String[] filterExtensions) {
        String[] correctedFilterExtensions = new String[filterExtensions.length];
        int i = 0;
        while (i < filterExtensions.length) {
            correctedFilterExtensions[i] = filterExtensions[i].startsWith(".") ? filterExtensions[i] : "." + filterExtensions[i];
            ++i;
        }
        ResourceFilter filter = new ResourceFilter(correctedFilterExtensions, null);
        this.fFilters = new Vector();
        this.fFilters.add(filter);
        if (this.sourceFileViewer != null) {
            this.sourceFileViewer.getTree().setRedraw(false);
            this.sourceFileViewer.resetFilters();
            Iterator i2 = this.fFilters.iterator();
            while (i2.hasNext()) {
                this.sourceFileViewer.addFilter((ViewerFilter)i2.next());
            }
            this.sourceFileViewer.getTree().setRedraw(true);
            this.sourceFileViewer.getTree().redraw();
        }
    }

    public void setVisibleHelper(boolean visible) {
        if (visible) {
            if (this.fFilters != null) {
                this.sourceFileViewer.resetFilters();
                Iterator i = this.fFilters.iterator();
                while (i.hasNext()) {
                    this.sourceFileViewer.addFilter((ViewerFilter)i.next());
                }
            }
            this.sourceFileViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            this.sourceFileViewer.expandToLevel(2);
            if (this.defaultSelection != null) {
                this.sourceFileViewer.setSelection(this.defaultSelection, true);
            } else if (!this.sourceFileViewer.getSelection().isEmpty()) {
                this.sourceFileViewer.setSelection(this.sourceFileViewer.getSelection());
            } else if (this.isFileMandatory && this.listener != null) {
                this.listener.setControlComplete(false);
            }
        }
    }

    public void addSelectionChangedTreeListener(ISelectionChangedListener treeListener) {
        this.sourceFileViewer.addSelectionChangedListener(treeListener);
    }

    public static interface Listener {
        public void setControlComplete(boolean var1);
    }

    class ImportAddResourceListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        Vector importedFiles = new Vector();

        ImportAddResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta resourceDelta = event.getDelta();
            try {
                if (resourceDelta != null) {
                    resourceDelta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (Exception exception) {}
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getKind() == 1 && delta.getResource() instanceof IFile) {
                this.importedFiles.add(delta.getResource());
            }
            return true;
        }

        public Collection getImportedFiles() {
            return this.importedFiles;
        }

        public IFile getImportedFile() {
            if (!this.importedFiles.isEmpty()) {
                return (IFile)this.importedFiles.firstElement();
            }
            return null;
        }
    }
}

