/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.integration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class JavaInsertionHelper {
    protected DOMFactory domFactory = new DOMFactory();
    protected List fields;
    protected List methods;
    protected List imports;
    protected String insertionString;
    protected List extendedOperations;

    public List getFields() {
        return this.fields;
    }

    public String getInsertionString() {
        return this.insertionString;
    }

    public List getMethods() {
        return this.methods;
    }

    public void setInsertionString(String string) {
        this.insertionString = string;
    }

    public void addMethodFromSourceString(String methodString) {
        if (methodString != null && methodString.length() > 0) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(this.domFactory.createMethod(methodString));
        }
    }

    public void addFieldFromSourceString(String fieldString) {
        if (fieldString != null && fieldString.length() > 0) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(this.domFactory.createField(fieldString));
        }
    }

    public void addImport(String importString) {
        if (importString != null && importString.length() > 0) {
            if (this.imports == null) {
                this.imports = new ArrayList();
            }
            this.imports.add(importString);
        }
    }

    public boolean canInsertText() {
        return this.insertionString != null && this.insertionString.length() > 0;
    }

    public boolean hasFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public boolean hasImports() {
        return this.imports != null && !this.imports.isEmpty();
    }

    public List getImportStatements() {
        return this.imports;
    }

    public List getExtendedOperations() {
        return this.extendedOperations;
    }

    public void addExtendedOperation(IHeadlessRunnableWithProgress operation) {
        if (operation != null) {
            if (this.extendedOperations == null) {
                this.extendedOperations = new ArrayList();
            }
            this.extendedOperations.add(operation);
        }
    }
}

