/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.common;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class UIUtils {
    String infoPopid_;

    public UIUtils(String infoPopid) {
        this.infoPopid_ = infoPopid;
    }

    public Button createRadioButton(Composite parent, String labelName, String tooltip, String infopop) {
        return this.createButton(16, parent, labelName, tooltip, infopop);
    }

    public Button createCheckbox(Composite parent, String labelName, String tooltip, String infopop) {
        return this.createButton(32, parent, labelName, tooltip, infopop);
    }

    public Button createPushButton(Composite parent, String labelName, String tooltip, String infopop) {
        return this.createButton(0, parent, labelName, tooltip, infopop);
    }

    public Button createButton(int kind, Composite parent, String labelName, String tooltip, String infopop) {
        Button button = new Button(parent, kind);
        tooltip = tooltip == null ? labelName : tooltip;
        button.setText(labelName);
        button.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return button;
    }

    public Combo createCombo(Composite parent, String labelName, String tooltip, String infopop, int style) {
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
        }
        Combo combo = new Combo(parent, style);
        GridData griddata = new GridData(768);
        combo.setLayoutData((Object)griddata);
        combo.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return combo;
    }

    public Text createText(Composite parent, String labelName, String tooltip, String infopop, int style) {
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
        }
        Text text = new Text(parent, style);
        GridData griddata = new GridData(768);
        text.setLayoutData((Object)griddata);
        text.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return text;
    }

    public Composite createComposite(Composite parent, int columns) {
        return this.createComposite(parent, columns, -1, -1);
    }

    public Composite createComposite(Composite parent, int columns, int marginHeight, int marginWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = columns;
        if (marginHeight >= 0) {
            gridlayout.marginHeight = marginHeight;
        }
        if (marginWidth >= 0) {
            gridlayout.marginWidth = marginWidth;
        }
        composite.setLayout((Layout)gridlayout);
        GridData griddata = new GridData(768);
        composite.setLayoutData((Object)griddata);
        return composite;
    }

    public Group createGroup(Composite parent, String groupName, String tooltip, String infopop) {
        return this.createGroup(parent, groupName, tooltip, infopop, 1, -1, -1);
    }

    public Group createGroup(Composite parent, String groupName, String tooltip, String infopop, int columns, int marginHeight, int marginWidth) {
        Group newGroup = new Group(parent, 0);
        GridData griddata = new GridData(768);
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = columns;
        if (marginHeight >= 0) {
            gridlayout.marginHeight = marginHeight;
        }
        if (marginWidth >= 0) {
            gridlayout.marginWidth = marginWidth;
        }
        tooltip = tooltip == null ? groupName : tooltip;
        newGroup.setLayout((Layout)gridlayout);
        newGroup.setText(groupName);
        newGroup.setLayoutData((Object)griddata);
        newGroup.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newGroup, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return newGroup;
    }

    public Tree createTree(Composite parent, String tooltip, String infopop, int style) {
        tooltip = tooltip == null ? "" : tooltip;
        Tree tree = new Tree(parent, style);
        tree.setLayoutData((Object)this.createFillAll());
        tree.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tree, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return tree;
    }

    public Table createTable(Composite parent, String tooltip, String infopop, int style) {
        tooltip = tooltip == null ? "" : tooltip;
        Table table = new Table(parent, style);
        table.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)table, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return table;
    }

    public Label createHorizontalSeparator(Composite parent, int spacing) {
        Composite composite = this.createComposite(parent, 1, spacing, -1);
        Label separator = new Label(composite, 258);
        GridData griddata = new GridData(768);
        separator.setLayoutData((Object)griddata);
        return separator;
    }

    public GridData createFillAll() {
        GridData data = new GridData(1808);
        return data;
    }
}

