/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class SourceAnalyzer {
    private ICompilationUnit fCUnit;
    private MethodDeclaration fDeclaration;
    private Map fParameters;
    private Map fNames;
    private List fImplicitReceivers;
    private boolean fArrayAccess;
    private List fTypesToImport;
    private List fStaticsToImport;
    private List fTypeParameterReferences;
    private Map fTypeParameterMapping;
    private List fMethodTypeParameterReferences;
    private Map fMethodTypeParameterMapping;
    private boolean fInterruptedExecutionFlow;

    public SourceAnalyzer(ICompilationUnit unit, MethodDeclaration declaration) {
        this.fCUnit = unit;
        this.fDeclaration = declaration;
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fInterruptedExecutionFlow;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        List parameters;
        RefactoringStatus result = new RefactoringStatus();
        if (!this.fCUnit.isStructureKnown()) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_syntax_errors, JavaStatusContext.create(this.fCUnit));
            return result;
        }
        IProblem[] problems = ASTNodes.getProblems((ASTNode)this.fDeclaration, 0, 2);
        if (problems.length > 0) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fCUnit, (ASTNode)this.fDeclaration));
            return result;
        }
        if (this.fDeclaration.getBody() == null) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_abstract_methods, JavaStatusContext.create(this.fCUnit, (ASTNode)this.fDeclaration));
            return result;
        }
        ActivationAnalyzer analyzer = new ActivationAnalyzer();
        this.fDeclaration.accept((ASTVisitor)analyzer);
        result.merge(analyzer.status);
        if (!result.hasFatalError()) {
            parameters = this.fDeclaration.parameters();
            this.fParameters = new HashMap(parameters.size() * 2);
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration element = (SingleVariableDeclaration)iter.next();
                IVariableBinding binding = element.resolveBinding();
                if (binding == null) {
                    result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fCUnit, (ASTNode)this.fDeclaration));
                    return result;
                }
                this.fParameters.put(binding, element.getProperty(ParameterData.PROPERTY));
            }
            this.fNames = new HashMap();
            this.fImplicitReceivers = new ArrayList(2);
            this.fTypeParameterReferences = new ArrayList(0);
            this.fTypeParameterMapping = new HashMap();
            ITypeBinding declaringType = this.fDeclaration.resolveBinding().getDeclaringClass();
            if (declaringType == null) {
                result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_typedeclaration_has_errors, JavaStatusContext.create(this.fCUnit));
                return result;
            }
            ITypeBinding[] typeParameters = declaringType.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                NameData data = new NameData(typeParameters[i].getName());
                this.fTypeParameterReferences.add(data);
                this.fTypeParameterMapping.put(typeParameters[i], data);
                ++i;
            }
            this.fMethodTypeParameterReferences = new ArrayList(0);
            this.fMethodTypeParameterMapping = new HashMap();
            IMethodBinding method = this.fDeclaration.resolveBinding();
            typeParameters = method.getTypeParameters();
            int i2 = 0;
            while (i2 < typeParameters.length) {
                NameData data = new NameData(typeParameters[i2].getName());
                this.fMethodTypeParameterReferences.add(data);
                this.fMethodTypeParameterMapping.put(typeParameters[i2], data);
                ++i2;
            }
        }
        if (this.fDeclaration.isVarargs()) {
            parameters = this.fDeclaration.parameters();
            VarargAnalyzer vAnalyzer = new VarargAnalyzer(((SingleVariableDeclaration)parameters.get(parameters.size() - 1)).getName().resolveBinding());
            this.fDeclaration.getBody().accept((ASTVisitor)vAnalyzer);
        }
        return result;
    }

    public void initialize() {
        Block body = this.fDeclaration.getBody();
        this.fTypesToImport = new ArrayList();
        this.fStaticsToImport = new ArrayList();
        ImportReferencesCollector collector = new ImportReferencesCollector(this.fCUnit.getJavaProject(), null, this.fTypesToImport, this.fStaticsToImport);
        body.accept((ASTVisitor)collector);
        body.accept((ASTVisitor)new UpdateCollector());
        int numberOfLocals = LocalVariableIndex.perform((BodyDeclaration)this.fDeclaration);
        FlowContext context = new FlowContext(0, numberOfLocals + 1);
        context.setConsiderAccessMode(true);
        context.setComputeMode(FlowContext.MERGE);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(context);
        FlowInfo info = flowAnalyzer.perform(this.getStatements());
        Iterator iter = this.fDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration element = (SingleVariableDeclaration)iter.next();
            IVariableBinding binding = element.resolveBinding();
            ParameterData data = (ParameterData)element.getProperty(ParameterData.PROPERTY);
            data.setAccessMode(info.getAccessMode(context, binding));
        }
    }

    public Collection getUsedNames() {
        return this.fNames.values();
    }

    public List getImplicitReceivers() {
        return this.fImplicitReceivers;
    }

    public List getTypesToImport() {
        return this.fTypesToImport;
    }

    public List getStaticsToImport() {
        return this.fStaticsToImport;
    }

    public List getTypeParameterReferences() {
        return this.fTypeParameterReferences;
    }

    public List getMethodTypeParameterReferences() {
        return this.fMethodTypeParameterReferences;
    }

    public boolean hasArrayAccess() {
        return this.fArrayAccess;
    }

    private ASTNode[] getStatements() {
        List statements = this.fDeclaration.getBody().statements();
        return statements.toArray(new ASTNode[statements.size()]);
    }

    public static class NameData {
        private String fName;
        private List fReferences;

        public NameData(String n) {
            this.fName = n;
            this.fReferences = new ArrayList(2);
        }

        public String getName() {
            return this.fName;
        }

        public void addReference(SimpleName ref) {
            this.fReferences.add(ref);
        }

        public List references() {
            return this.fReferences;
        }
    }

    private class ActivationAnalyzer
    extends ASTVisitor {
        public RefactoringStatus status = new RefactoringStatus();
        private ASTNode fLastNode = this.getLastNode();
        private IMethodBinding fBinding = this.getBinding();

        ActivationAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            if (node != this.fLastNode) {
                SourceAnalyzer.this.fInterruptedExecutionFlow = true;
            }
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            return false;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(MethodInvocation node) {
            if (this.fBinding != null && this.fBinding == node.getName().resolveBinding() && !this.status.hasFatalError()) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_recursive_call);
                return false;
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding == null && !this.status.hasFatalError() && !ASTNodes.isLabel(node)) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(SourceAnalyzer.this.fCUnit, (ASTNode)SourceAnalyzer.this.fDeclaration));
                return false;
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            if (node.getQualifier() != null) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_qualified_this_expressions, JavaStatusContext.create(SourceAnalyzer.this.fCUnit, (ASTNode)node));
                return false;
            }
            return true;
        }

        private ASTNode getLastNode() {
            List statements = SourceAnalyzer.this.fDeclaration.getBody().statements();
            if (statements.size() == 0) {
                return null;
            }
            return (ASTNode)statements.get(statements.size() - 1);
        }

        private IMethodBinding getBinding() {
            return SourceAnalyzer.this.fDeclaration.resolveBinding();
        }
    }

    private class UpdateCollector
    extends ASTVisitor {
        private int fTypeCounter;
        static /* synthetic */ Class class$0;

        UpdateCollector() {
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public void endVisit(TypeDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public void endVisit(EnumDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public void endVisit(AnnotationTypeDeclaration node) {
            --this.fTypeCounter;
        }

        private boolean visitType(AbstractTypeDeclaration node) {
            if (this.fTypeCounter++ == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            ++this.fTypeCounter;
            return true;
        }

        public void endVisit(AnonymousClassDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(FieldAccess node) {
            Expression expression = node.getExpression();
            if (node.getExpression() == null && !this.isStaticallyImported((Name)node.getName())) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
                return true;
            }
            if (expression instanceof ThisExpression) {
                expression.accept((ASTVisitor)this);
                this.addReferencesToName(node.getName());
                return false;
            }
            return true;
        }

        public boolean visit(MethodDeclaration node) {
            if (node.isConstructor()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                AbstractTypeDeclaration decl = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)node, clazz);
                NameData name = (NameData)SourceAnalyzer.this.fNames.get(decl.getName().resolveBinding());
                if (name != null) {
                    name.addReference(node.getName());
                }
            }
            return true;
        }

        public boolean visit(MethodInvocation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null && !this.isStaticallyImported((Name)node.getName())) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null && node.resolveTypeBinding().isLocal()) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration node) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(VariableDeclarationFragment node) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            StructuralPropertyDescriptor location;
            ASTNode parent;
            IVariableBinding vb;
            this.addReferencesToName(node);
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding) {
                ITypeBinding type = (ITypeBinding)binding;
                if (type.isTypeVariable()) {
                    this.addTypeVariableReference(type, node);
                }
            } else if (binding instanceof IVariableBinding && (vb = (IVariableBinding)binding).isField() && !this.isStaticallyImported((Name)node) && !((parent = node.getParent()) instanceof QualifiedName) && (location = node.getLocationInParent()) != SingleVariableDeclaration.NAME_PROPERTY && location != VariableDeclarationFragment.NAME_PROPERTY) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        private void addReferencesToName(SimpleName node) {
            NameData name;
            IBinding binding = node.resolveBinding();
            ParameterData data = (ParameterData)SourceAnalyzer.this.fParameters.get(binding);
            if (data != null) {
                data.addReference((ASTNode)node);
            }
            if ((name = (NameData)SourceAnalyzer.this.fNames.get(binding)) != null) {
                name.addReference(node);
            }
        }

        private void addNameReference(SimpleName name) {
            SourceAnalyzer.this.fNames.put(name.resolveBinding(), new NameData(name.getIdentifier()));
        }

        private void addTypeVariableReference(ITypeBinding variable, SimpleName name) {
            NameData data = (NameData)SourceAnalyzer.this.fTypeParameterMapping.get(variable);
            if (data == null) {
                data = (NameData)SourceAnalyzer.this.fMethodTypeParameterMapping.get(variable);
            }
            data.addReference(name);
        }

        private boolean isStaticallyImported(Name name) {
            return SourceAnalyzer.this.fStaticsToImport.contains(name);
        }
    }

    private class VarargAnalyzer
    extends ASTVisitor {
        private IBinding fParameter;

        public VarargAnalyzer(IBinding parameter) {
            this.fParameter = parameter;
        }

        public boolean visit(ArrayAccess node) {
            Expression array = node.getArray();
            if (array instanceof SimpleName && this.fParameter.isEqualTo(((SimpleName)array).resolveBinding())) {
                SourceAnalyzer.this.fArrayAccess = true;
            }
            return true;
        }
    }
}

