/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.PatternStrings;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class NLSSearchPage
extends DialogPage
implements ISearchPage,
IJavaSearchConstants {
    public static final String EXTENSION_POINT_ID = "org.eclipse.jdt.ui.nls.NLSSearchPage";
    private static final String RESOURCE_BUNDLE_FIELD = "RESOURCE_BUNDLE";
    private static final String BUNDLE_NAME_FIELD = "BUNDLE_NAME";
    private static List fgPreviousSearchPatterns = new ArrayList(20);
    private Combo fWrapperClassCombo;
    private Text fPropertyFileText;
    private boolean fFirstTime = true;
    private ISearchPageContainer fContainer;
    private IJavaElement fWrapperClass;
    static /* synthetic */ Class class$0;

    public boolean performAction() {
        return this.performNewSearch();
    }

    private boolean performNewSearch() {
        SearchPatternData data = this.getPatternData();
        if (data.wrapperClass == null || data.propertyFile == null) {
            return false;
        }
        IJavaSearchScope scope = null;
        String scopeDescription = "";
        boolean includeJRE = true;
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scopeDescription = NLSSearchMessages.WorkspaceScope;
                scope = SearchEngine.createWorkspaceScope();
                break;
            }
            case 1: {
                scopeDescription = NLSSearchMessages.SelectionScope;
                scope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(this.getSelection(), includeJRE);
                break;
            }
            case 3: {
                scope = JavaSearchScopeFactory.getInstance().createJavaProjectSearchScope(this.getSelection(), includeJRE);
                IProject[] projects = JavaSearchScopeFactory.getInstance().getProjects(scope);
                if (projects.length > 1) {
                    scopeDescription = Messages.format(NLSSearchMessages.EnclosingProjectsScope, projects[0].getName());
                    break;
                }
                if (projects.length == 1) {
                    scopeDescription = Messages.format(NLSSearchMessages.EnclosingProjectScope, projects[0].getName());
                    break;
                }
                scopeDescription = Messages.format(NLSSearchMessages.EnclosingProjectScope, "");
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = Messages.format(NLSSearchMessages.WorkingSetScope, new String[]{SearchUtil.toString(workingSets)});
                scope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(this.getContainer().getSelectedWorkingSets(), includeJRE);
                SearchUtil.updateLRUWorkingSets(this.getContainer().getSelectedWorkingSets());
            }
        }
        NLSSearchQuery query = new NLSSearchQuery(data.wrapperClass, data.propertyFile, scope, scopeDescription);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = fgPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = ((SearchPatternData)NLSSearchPage.fgPreviousSearchPatterns.get((int)(patternCount - 1 - i))).wrapperClassName;
            ++i;
        }
        return patterns;
    }

    private String getWrapperClassName() {
        return this.fWrapperClassCombo.getText();
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getWrapperClassName();
        SearchPatternData match = null;
        int i = 0;
        int size = fgPreviousSearchPatterns.size();
        if (this.fWrapperClass == null) {
            Object[] types;
            SelectionDialog dialog = this.createWrapperClassSelectionDialog();
            if (dialog == null) {
                this.fWrapperClass = null;
            } else if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                this.fWrapperClass = (IType)types[0];
                this.fWrapperClassCombo.setText(PatternStrings.getSignature(this.fWrapperClass));
                pattern = this.getWrapperClassName();
            }
        }
        while (match == null && i < size) {
            match = (SearchPatternData)fgPreviousSearchPatterns.get(i);
            ++i;
            if (pattern.equals(match.wrapperClassName)) continue;
            match = null;
        }
        if (match == null) {
            match = new SearchPatternData(pattern, this.fWrapperClass, this.fPropertyFileText.getText());
            fgPreviousSearchPatterns.add(match);
        } else {
            Path path;
            match.wrapperClass = this.fWrapperClass;
            match.propertyFileName = this.fPropertyFileText.getText();
            match.scope = this.getContainer().getSelectedScope();
            match.workingSets = this.getContainer().getSelectedWorkingSets();
            match.propertyFile = null;
            if (match.propertyFileName != null && (path = new Path(match.propertyFileName)).segmentCount() >= 2) {
                match.propertyFile = JavaPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fWrapperClassCombo != null) {
            if (this.fFirstTime) {
                JavaPlugin.getDefault().getImageRegistry();
                this.fFirstTime = false;
                this.fWrapperClassCombo.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fWrapperClassCombo.setFocus();
            this.getContainer().setPerformActionEnabled(this.getWrapperClassName().length() > 0 && this.fPropertyFileText.getText().length() > 0);
        }
        super.setVisible(visible);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        RowLayouter layouter = new RowLayouter(layout.numColumns);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        layouter.setDefaultGridData(gd, 0);
        layouter.setDefaultGridData(gd, 1);
        layouter.setDefaultSpan();
        layouter.perform(this.createWrapperClassControl(result));
        layouter.perform(this.createPropertyFileControl(result));
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.jdt.ui.nls_search_page_context");
    }

    private Control createWrapperClassControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText(NLSSearchMessages.NLSSearchPage_wrapperClassGroup_text);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fWrapperClassCombo = new Combo(result, 2052);
        this.fWrapperClassCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NLSSearchPage.this.fWrapperClassCombo.getSelectionIndex() < 0) {
                    return;
                }
                int index = fgPreviousSearchPatterns.size() - 1 - NLSSearchPage.this.fWrapperClassCombo.getSelectionIndex();
                SearchPatternData values = (SearchPatternData)fgPreviousSearchPatterns.get(index);
                NLSSearchPage.this.fWrapperClass = values.wrapperClass;
                NLSSearchPage.this.fWrapperClassCombo.setText(values.wrapperClassName);
                NLSSearchPage.this.fPropertyFileText.setText(values.propertyFileName);
                if (values.workingSets != null) {
                    NLSSearchPage.this.getContainer().setSelectedWorkingSets(values.workingSets);
                } else {
                    NLSSearchPage.this.getContainer().setSelectedScope(values.scope);
                }
            }
        });
        this.fWrapperClassCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NLSSearchPage.this.fWrapperClass != null && !PatternStrings.getSignature(NLSSearchPage.this.fWrapperClass).equals(NLSSearchPage.this.fWrapperClassCombo.getText())) {
                    NLSSearchPage.this.fWrapperClass = null;
                }
                NLSSearchPage.this.getContainer().setPerformActionEnabled(NLSSearchPage.this.fWrapperClassCombo.getText().length() > 0 && NLSSearchPage.this.fPropertyFileText.getText().length() > 0);
            }
        });
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        this.fWrapperClassCombo.setLayoutData((Object)gd);
        Button browseButton = new Button(result, 8);
        browseButton.setText(NLSSearchMessages.NLSSearchPage_wrapperClassBrowseButton_text);
        browseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NLSSearchPage.this.handleBrowseWrapperClassButtonPressed();
            }
        });
        return result;
    }

    private Control createPropertyFileControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText(NLSSearchMessages.NLSSearchPage_propertyFileGroup_text);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fPropertyFileText = new Text(result, 2052);
        this.fPropertyFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NLSSearchPage.this.getContainer().setPerformActionEnabled(NLSSearchPage.this.fWrapperClassCombo.getText().length() > 0 && NLSSearchPage.this.fPropertyFileText.getText().length() > 0);
            }
        });
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        this.fPropertyFileText.setLayoutData((Object)gd);
        Button browseButton = new Button(result, 8);
        browseButton.setText(NLSSearchMessages.NLSSearchPage_propertyFileBrowseButton_text);
        browseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NLSSearchPage.this.handleBrowsePropertiesButtonPressed();
            }
        });
        return result;
    }

    private void initSelections() {
        this.fWrapperClass = null;
        ISelection selection = this.getSelection();
        SearchPatternData values = null;
        values = this.tryIfPropertyFileSelected(selection);
        if (values == null) {
            values = this.tryTypedTextSelection(selection);
        }
        if (values == null) {
            values = this.trySelection(selection);
        }
        if (values == null) {
            values = this.trySimpleTextSelection(selection);
        }
        if (values == null) {
            values = this.getDefaultInitValues();
        }
        this.fPropertyFileText.setText(values.propertyFileName);
        this.fWrapperClass = values.wrapperClass;
        if (this.fWrapperClass != null) {
            this.fWrapperClassCombo.setText(PatternStrings.getSignature(this.fWrapperClass));
        } else {
            this.fWrapperClassCombo.setText(values.wrapperClassName);
        }
    }

    private SearchPatternData tryTypedTextSelection(ISelection selection) {
        IEditorPart e;
        if (selection instanceof ITextSelection && (e = this.getEditorPart()) != null) {
            ITextSelection ts = (ITextSelection)selection;
            ICodeAssist assist = this.getCodeAssist(e);
            if (assist != null) {
                IJavaElement[] elements = null;
                try {
                    elements = assist.codeSelect(ts.getOffset(), ts.getLength());
                }
                catch (JavaModelException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), NLSSearchMessages.Search_Error_createJavaElement_title, NLSSearchMessages.Search_Error_createJavaElement_message);
                }
                if (elements != null && elements.length > 0) {
                    this.fWrapperClass = elements.length == 1 ? elements[0] : this.chooseFromList(elements);
                    if (this.fWrapperClass != null) {
                        return this.determineInitValuesFrom(this.fWrapperClass);
                    }
                }
            }
        }
        return null;
    }

    private ICodeAssist getCodeAssist(IEditorPart editorPart) {
        IEditorInput input = editorPart.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    private SearchPatternData trySelection(ISelection selection) {
        SearchPatternData result = null;
        if (selection == null) {
            return result;
        }
        Object o = null;
        if (selection instanceof IStructuredSelection) {
            o = ((IStructuredSelection)selection).getFirstElement();
        }
        if (o instanceof IJavaElement) {
            this.fWrapperClass = (IJavaElement)o;
            result = this.determineInitValuesFrom(this.fWrapperClass);
        }
        if (o instanceof IAdaptable) {
            IWorkbenchAdapter element;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                result = new SearchPatternData(element.getLabel(o), null, "");
            }
        }
        return result;
    }

    private SearchPatternData determineInitValuesFrom(IJavaElement element) {
        if (element == null) {
            return null;
        }
        int searchFor = -1;
        String pattern = null;
        IType mainType = null;
        switch (element.getElementType()) {
            case 4: {
                searchFor = 2;
                pattern = element.getElementName();
                break;
            }
            case 3: {
                searchFor = 2;
                pattern = element.getElementName();
                break;
            }
            case 11: {
                searchFor = 2;
                pattern = element.getElementName();
                break;
            }
            case 13: {
                pattern = element.getElementName();
                IImportDeclaration declaration = (IImportDeclaration)element;
                if (declaration.isOnDemand()) {
                    searchFor = 2;
                    int index = pattern.lastIndexOf(46);
                    pattern = pattern.substring(0, index);
                    break;
                }
                searchFor = 0;
                break;
            }
            case 7: {
                searchFor = 0;
                mainType = (IType)element;
                pattern = JavaModelUtil.getFullyQualifiedName(mainType);
                break;
            }
            case 5: {
                ICompilationUnit cu = (ICompilationUnit)element;
                String mainTypeName = element.getElementName().substring(0, element.getElementName().indexOf("."));
                mainType = cu.getType(mainTypeName);
                mainTypeName = JavaModelUtil.getTypeQualifiedName(mainType);
                try {
                    mainType = JavaModelUtil.findTypeInCompilationUnit(cu, mainTypeName);
                    if (mainType == null) {
                        IType[] types = cu.getTypes();
                        if (types.length <= 0) break;
                        mainType = types[0];
                    }
                }
                catch (JavaModelException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), NLSSearchMessages.Search_Error_javaElementAccess_title, NLSSearchMessages.Search_Error_javaElementAccess_message);
                    break;
                }
                searchFor = 0;
                element = mainType;
                pattern = JavaModelUtil.getFullyQualifiedName(mainType);
                break;
            }
            case 6: {
                IClassFile cf = (IClassFile)element;
                try {
                    mainType = cf.getType();
                }
                catch (JavaModelException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), NLSSearchMessages.Search_Error_javaElementAccess_title, NLSSearchMessages.Search_Error_javaElementAccess_message);
                    break;
                }
                if (mainType == null) break;
                searchFor = 0;
                pattern = JavaModelUtil.getFullyQualifiedName(mainType);
                break;
            }
            case 8: {
                searchFor = 4;
                IType type = ((IField)element).getDeclaringType();
                StringBuffer buffer = new StringBuffer();
                buffer.append(JavaModelUtil.getFullyQualifiedName(type));
                buffer.append('.');
                buffer.append(element.getElementName());
                pattern = buffer.toString();
                break;
            }
            case 9: {
                searchFor = 1;
                try {
                    IMethod method = (IMethod)element;
                    if (method.isConstructor()) {
                        searchFor = 3;
                    }
                }
                catch (JavaModelException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), NLSSearchMessages.Search_Error_javaElementAccess_title, NLSSearchMessages.Search_Error_javaElementAccess_message);
                    break;
                }
                pattern = PatternStrings.getMethodSignature((IMethod)element);
            }
        }
        if (searchFor == 0 && pattern != null) {
            String propertyFilePathStr = null;
            if (mainType != null && (propertyFilePathStr = this.getPropertyFilePathStr(mainType, RESOURCE_BUNDLE_FIELD)) == null) {
                propertyFilePathStr = this.getPropertyFilePathStr(mainType, BUNDLE_NAME_FIELD);
            }
            if (propertyFilePathStr == null) {
                IPath path = element.getPath().removeFileExtension().addFileExtension("properties");
                propertyFilePathStr = path.toString();
            }
            return new SearchPatternData(pattern, element, propertyFilePathStr);
        }
        return null;
    }

    private String getPropertyFilePathStr(IType mainType, String fieldName) {
        IField bundle = mainType.getField(fieldName);
        if (bundle.exists()) {
            try {
                Object constant = bundle.getConstant();
                if (constant instanceof String) {
                    String string = (String)constant;
                    return String.valueOf(mainType.getAncestor(3).getPath().toString()) + '/' + string.substring(1, string.length() - 1).replace('.', '/') + ".properties";
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ISelection selection) {
        SearchPatternData result = null;
        if (selection instanceof ITextSelection) {
            String text;
            BufferedReader reader = new BufferedReader(new StringReader(((ITextSelection)selection).getText()));
            try {
                text = reader.readLine();
                if (text == null) {
                    text = "";
                }
            }
            catch (IOException iOException) {
                text = "";
            }
            result = new SearchPatternData(text, null, "");
        }
        return result;
    }

    private SearchPatternData tryIfPropertyFileSelected(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile && ((IFile)o).getFileExtension().equalsIgnoreCase("properties")) {
            String filename;
            IPath propertyFullPath = ((IFile)o).getFullPath();
            String typePathStr = null;
            IPath cuPath = propertyFullPath.removeFileExtension().addFileExtension("java");
            IFile cuFile = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(cuPath);
            if (cuFile == null && (filename = cuPath.removeFileExtension().lastSegment()) != null && filename.length() > 0) {
                filename = String.valueOf(Character.toUpperCase(filename.charAt(0))) + filename.substring(1);
                IPath dirPath = propertyFullPath.removeLastSegments(1).addTrailingSeparator();
                cuPath = dirPath.append(filename).addFileExtension("java");
                cuFile = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(cuPath);
            }
            IType type = null;
            if (cuFile != null && cuFile.exists()) {
                IJavaElement cu = JavaCore.create((IFile)cuFile);
                if (cu != null && cu.exists() && cu.getElementType() == 5) {
                    type = ((ICompilationUnit)cu).findPrimaryType();
                }
                if (type != null) {
                    typePathStr = JavaModelUtil.getFullyQualifiedName(type);
                } else {
                    IPath propertyFile = propertyFullPath.removeFirstSegments(propertyFullPath.segmentCount() - 1);
                    typePathStr = propertyFile.removeFileExtension().toString();
                }
            }
            return new SearchPatternData(typePathStr, (IJavaElement)type, propertyFullPath.toString());
        }
        return null;
    }

    private SearchPatternData getDefaultInitValues() {
        return new SearchPatternData("", null, "");
    }

    private IJavaElement chooseFromList(IJavaElement[] openChoices) {
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x400;
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(flags);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setIgnoreCase(true);
        dialog.setMultipleSelection(false);
        dialog.setTitle(NLSSearchMessages.SearchElementSelectionDialog_title);
        dialog.setMessage(NLSSearchMessages.SearchElementSelectionDialog_message);
        dialog.setElements((Object[])openChoices);
        if (dialog.open() == 0) {
            return (IJavaElement)dialog.getFirstResult();
        }
        return null;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    private IEditorPart getEditorPart() {
        IWorkbenchPage page;
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected void handleBrowseWrapperClassButtonPressed() {
        SelectionDialog dialog = this.createWrapperClassSelectionDialog();
        if (dialog == null || dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.fWrapperClass = (IType)types[0];
            this.fWrapperClassCombo.setText(PatternStrings.getSignature(this.fWrapperClass));
        }
    }

    protected void handleBrowsePropertiesButtonPressed() {
        Object[] resources;
        ElementTreeSelectionDialog dialog = this.createWorkspaceFileSelectionDialog(NLSSearchMessages.NLSSearchPage_propertiesFileSelectionDialog_title, NLSSearchMessages.NLSSearchPage_propertiesFileSelectionDialog_message);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setInitialSelections((Object[])new String[]{this.fPropertyFileText.getText()});
        if (dialog.open() == 0 && (resources = dialog.getResult()).length == 1) {
            this.fPropertyFileText.setText(((IResource)resources[0]).getFullPath().toString());
        }
    }

    protected ElementTreeSelectionDialog createWorkspaceFileSelectionDialog(String title, String message) {
        int labelFlags = 272;
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(labelFlags);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof IFile && ((IFile)selection[0]).getFileExtension().equalsIgnoreCase("properties")) {
                    return new StatusInfo();
                }
                return new StatusInfo(4, "");
            }
        });
        dialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        dialog.addFilter((ViewerFilter)new LibraryFilter());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setStatusLineAboveButtons(true);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot()));
        return dialog;
    }

    protected SelectionDialog createWrapperClassSelectionDialog() {
        Shell shell = this.getControl().getShell();
        SelectionDialog dialog = null;
        try {
            String filter = this.getWrapperClassName();
            int lastDot = filter.lastIndexOf(46);
            if (lastDot > -1 && lastDot != filter.length() - 1) {
                filter = filter.substring(lastDot + 1);
            }
            dialog = JavaUI.createTypeDialog(shell, (IRunnableContext)new ProgressMonitorDialog(shell), SearchEngine.createWorkspaceScope(), 6, false, filter);
            if (this.fWrapperClass != null) {
                dialog.setInitialSelections(new Object[]{this.fWrapperClass});
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), NLSSearchMessages.NLSSearchPage_Error_createTypeDialog_title, NLSSearchMessages.NLSSearchPage_Error_createTypeDialog_message);
            return null;
        }
        dialog.setTitle(NLSSearchMessages.NLSSearchPage_wrapperClassDialog_title);
        dialog.setInitialSelections(new Object[]{NLSSearchPage.getUnqualifiedType(this.getWrapperClassName())});
        dialog.setMessage(NLSSearchMessages.NLSSearchPage_wrapperClassDialog_message);
        return dialog;
    }

    public static String getUnqualifiedType(String typeName) {
        if (typeName == null) {
            return null;
        }
        int lastDotIndex = typeName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return typeName;
        }
        if (lastDotIndex > typeName.length() - 1) {
            return "";
        }
        return typeName.substring(lastDotIndex + 1);
    }

    private static class SearchPatternData {
        String propertyFileName;
        IFile propertyFile;
        String wrapperClassName;
        IJavaElement wrapperClass;
        int scope;
        IWorkingSet[] workingSets;

        public SearchPatternData(String wrapperClassName, IJavaElement wrapperClass, String p) {
            this(wrapperClassName, wrapperClass, p, 0, null);
        }

        public SearchPatternData(String wrapperClassName, IJavaElement wrapperClass, String p, int scope, IWorkingSet[] workingSets) {
            Path path;
            this.wrapperClassName = wrapperClassName == null ? "" : wrapperClassName;
            this.wrapperClass = wrapperClass;
            this.scope = scope;
            this.workingSets = workingSets;
            this.propertyFileName = p;
            if (p != null && p.length() > 0 && (path = new Path(this.propertyFileName)).segmentCount() >= 2) {
                this.propertyFile = JavaPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
    }
}

