/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.text.Assert;

public abstract class MemberProposalInfo
extends ProposalInfo {
    protected final IJavaProject fJavaProject;
    protected final CompletionProposal fProposal;
    private boolean fJavadocResolved = false;
    private String fJavadoc = null;

    public MemberProposalInfo(IJavaProject project, CompletionProposal proposal) {
        super(null);
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)proposal);
        this.fJavaProject = project;
        this.fProposal = proposal;
    }

    public final String getInfo() {
        if (!this.fJavadocResolved) {
            this.fJavadocResolved = true;
            this.fJavadoc = this.computeInfo();
        }
        return this.fJavadoc;
    }

    private String computeInfo() {
        try {
            return this.extractJavadoc(this.resolveMember());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private String extractJavadoc(IMember member) throws JavaModelException, IOException {
        Reader reader;
        if (member != null && (reader = JavadocContentAccess.getContentReader(member, true)) != null) {
            return new JavaDoc2HTMLTextReader(reader).getString();
        }
        return null;
    }

    protected abstract IMember resolveMember() throws JavaModelException;
}

