/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class BrowserInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
DisposeListener {
    private static final int RIGHT_MARGIN = 3;
    private static final int BORDER = 1;
    private static boolean fgIsAvailable = false;
    private static boolean fgAvailabilityChecked = false;
    private Shell fShell;
    private Browser fBrowser;
    private boolean fBrowserHasContent;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Font fStatusTextFont;
    private boolean fHideScrollBars;
    private Listener fDeactivateListener;
    private ListenerList fFocusListeners = new ListenerList();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailable(Composite parent) {
        if (fgAvailabilityChecked) return fgIsAvailable;
        try {
            try {
                Browser browser = new Browser(parent, 0);
                browser.dispose();
                fgIsAvailable = true;
            }
            catch (SWTError sWTError) {
                fgIsAvailable = false;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            fgAvailabilityChecked = true;
            throw throwable;
        }
        {
            Object var2_4 = null;
            fgAvailabilityChecked = true;
            return fgIsAvailable;
        }
    }

    public BrowserInformationControl(Shell parent, int shellStyle, int style) {
        this(parent, shellStyle, style, null);
    }

    public BrowserInformationControl(Shell parent, int shellStyle, int style, String statusFieldText) {
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        int border = (shellStyle & 8) == 0 ? 0 : 1;
        this.fShell.setLayout((Layout)new BorderFillLayout(border));
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border;
        layout.marginWidth = border;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(display.getSystemColor(29));
        }
        this.fBrowser = new Browser((Composite)this.fShell, 0);
        this.fHideScrollBars = (style & 0x200) == 0 && (style & 0x100) == 0;
        gd = new GridData(1809);
        this.fBrowser.setLayoutData((Object)gd);
        this.fBrowser.setForeground(display.getSystemColor(28));
        this.fBrowser.setBackground(display.getSystemColor(29));
        this.fBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    BrowserInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fBrowser.setMenu(new Menu((Decorations)this.fShell, 0));
        if (statusFieldText != null) {
            Label separator = new Label((Composite)composite, 259);
            separator.setLayoutData((Object)new GridData(768));
            Label statusField = new Label((Composite)composite, 131072);
            statusField.setText(statusFieldText);
            Font font = statusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)statusField.getDisplay(), fontDatas);
            statusField.setFont(this.fStatusTextFont);
            gd = new GridData(802);
            statusField.setLayoutData((Object)gd);
            statusField.setForeground(display.getSystemColor(17));
            statusField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
    }

    public BrowserInformationControl(Shell parent, int style) {
        this(parent, 8, style);
    }

    public BrowserInformationControl(Shell parent) {
        this(parent, 0);
    }

    public void setInformation(String content) {
        boolean bl = this.fBrowserHasContent = content != null && content.length() > 0;
        if (this.fBrowserHasContent) {
            int shellStyle = this.fShell.getStyle();
            boolean RTL = (shellStyle & 0x4000000) != 0;
            String[] styles = null;
            if (RTL && !this.fHideScrollBars) {
                styles = new String[]{"direction:rtl"};
            } else if (RTL && this.fHideScrollBars) {
                styles = new String[]{"direction:rtl", "overflow:hidden"};
            } else if (this.fHideScrollBars) {
                styles = new String[]{"overflow:hidden"};
            }
            if (styles != null) {
                StringBuffer buffer = new StringBuffer(content);
                this.insertStyles(buffer, styles);
                content = buffer.toString();
            }
        }
        this.fBrowser.setText(content);
        this.fBrowser.setSize(Math.min(200, this.fMaxWidth), Math.min(this.fMaxHeight, 50));
    }

    private void insertStyles(StringBuffer buffer, String[] styles) {
        if (styles == null || styles.length == 0) {
            return;
        }
        StringBuffer styleBuf = new StringBuffer(10 * styles.length);
        int i = 0;
        while (styles != null && i < styles.length) {
            styleBuf.append(" style=\"");
            styleBuf.append(styles[i]);
            styleBuf.append('\"');
            ++i;
        }
        int index = buffer.indexOf("<body ");
        if (index == -1) {
            return;
        }
        buffer.insert(index + 5, (Object)styleBuf);
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fShell = null;
        this.fBrowser = null;
        this.fStatusTextFont = null;
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(Math.min(width, this.fMaxWidth), Math.min(height, this.fMaxHeight));
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fBrowser.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public Rectangle computeTrim() {
        return this.fShell.computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fBrowser.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fBrowser.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fBrowser.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fBrowser.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fBrowser.addFocusListener(listener);
        if (this.fFocusListeners.isEmpty()) {
            this.fDeactivateListener = new Listener(){

                public void handleEvent(Event event) {
                    Object[] listeners = BrowserInformationControl.this.fFocusListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((FocusListener)listeners[i]).focusLost(new FocusEvent(event));
                        ++i;
                    }
                }
            };
            this.fBrowser.getShell().addListener(27, this.fDeactivateListener);
        }
        this.fFocusListeners.add((Object)listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fBrowser.removeFocusListener(listener);
        this.fFocusListeners.remove((Object)listener);
        if (this.fFocusListeners.isEmpty()) {
            this.fBrowser.getShell().removeListener(27, this.fDeactivateListener);
            this.fDeactivateListener = null;
        }
    }

    public boolean hasContents() {
        return this.fBrowserHasContent;
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Point size = children[i].computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++i;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++i;
                }
            }
        }
    }
}

