/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BuildActionSelectionContext {
    private IStructuredSelection fSelection = null;
    private IJavaProject fJavaProject;
    private List fElements = null;
    private int[] fTypes = null;
    static /* synthetic */ Class class$0;

    public void init(IStructuredSelection selection) {
        if (selection == null || !selection.equals(this.fSelection)) {
            this.initContextValues(selection);
        }
    }

    private void initContextValues(IStructuredSelection selection) {
        this.fSelection = selection;
        this.fJavaProject = null;
        this.fElements = Collections.EMPTY_LIST;
        this.fTypes = new int[0];
        IJavaProject project = this.getJavaProjectFromSelection(selection);
        if (project != null && project.exists()) {
            List elements = selection.toList();
            try {
                int[] types = new int[elements.size()];
                int i = 0;
                while (i < elements.size()) {
                    Object curr = elements.get(i);
                    if (i > 0 && !project.equals(this.getJavaProjectFromSelectedElement(curr))) {
                        return;
                    }
                    types[i] = DialogPackageExplorerActionGroup.getType(elements.get(i), project);
                    ++i;
                }
                this.fJavaProject = project;
                this.fElements = elements;
                this.fTypes = types;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private IJavaProject getJavaProjectFromSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Object element = selection.getFirstElement();
        return this.getJavaProjectFromSelectedElement(element);
    }

    private IJavaProject getJavaProjectFromSelectedElement(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getJavaProject();
        }
        if (element instanceof ClassPathContainer) {
            return ((ClassPathContainer)element).getJavaProject();
        }
        if (element instanceof IResource) {
            return JavaCore.create((IProject)((IResource)element).getProject());
        }
        if (element instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                return JavaCore.create((IProject)resource.getProject());
            }
        }
        return null;
    }

    public List getElements() {
        return this.fElements;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public int[] getTypes() {
        return this.fTypes;
    }
}

