/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class UpdateWEBXMLCommand
extends AbstractDataModelOperation {
    private IProject serverProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.serverProject != null) {
            IStatus status = null;
            status = this.addServlet(this.serverProject, this.getAxisServletDescriptor());
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            this.addServlet(this.serverProject, this.getAdmintServletDescriptor());
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    private ServletDescriptor getAxisServletDescriptor() {
        ServletDescriptor sd = new ServletDescriptor();
        sd._name = "AxisServlet";
        sd._displayName = "Apache-Axis Servlet";
        sd._className = "org.apache.axis.transport.http.AxisServlet";
        sd._mappings = new String[]{"/servlet/AxisServlet", "*.jws", "/services/*"};
        return sd;
    }

    private ServletDescriptor getAdmintServletDescriptor() {
        ServletDescriptor sd = new ServletDescriptor();
        sd._name = "AdminServlet";
        sd._displayName = "Axis Admin Servlet";
        sd._className = "org.apache.axis.transport.http.AdminServlet";
        sd._mappings = new String[]{"/servlet/AdminServlet"};
        sd._loadOnStartup = new Integer(100);
        return sd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus addServlet(IProject webProject, ServletDescriptor servletDescriptor) {
        IStatus iStatus;
        WebArtifactEdit webEdit;
        block14: {
            IStatus iStatus2;
            block13: {
                webEdit = null;
                try {
                    try {
                        WebApp webapp = null;
                        IVirtualComponent vc = ComponentCore.createComponent((IProject)webProject);
                        webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)vc);
                        if (webEdit != null) {
                            webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
                            boolean foundServlet = false;
                            EList theServlets = webapp.getServlets();
                            int i = 0;
                            while (true) {
                                if (i >= theServlets.size()) {
                                    if (!foundServlet) break;
                                    iStatus2 = Status.OK_STATUS;
                                    Object var13_15 = null;
                                    if (webEdit == null) return iStatus2;
                                    break block13;
                                }
                                Servlet aServlet = (Servlet)theServlets.get(i);
                                if (aServlet.getServletName().equals(servletDescriptor._name)) {
                                    foundServlet = true;
                                }
                                ++i;
                            }
                            WebapplicationFactory factory = WebapplicationFactory.eINSTANCE;
                            Servlet servlet = factory.createServlet();
                            ServletType servletType = factory.createServletType();
                            servlet.setWebType((WebType)servletType);
                            servlet.setServletName(servletDescriptor._name);
                            servletType.setClassName(servletDescriptor._className);
                            if (servletDescriptor._displayName != null) {
                                servlet.setDisplayName(servletDescriptor._displayName);
                            }
                            if (servletDescriptor._loadOnStartup != null) {
                                servlet.setLoadOnStartup(servletDescriptor._loadOnStartup);
                            }
                            if (servletDescriptor._params != null) {
                                Properties properties = servlet.getParamsAsProperties();
                                properties.putAll((Map<?, ?>)servletDescriptor._params);
                            }
                            webapp.getServlets().add((Object)servlet);
                            if (servletDescriptor._mappings != null) {
                                int i2 = 0;
                                while (i2 < servletDescriptor._mappings.length) {
                                    ServletMapping servletMapping = factory.createServletMapping();
                                    servletMapping.setServlet(servlet);
                                    servletMapping.setUrlPattern(servletDescriptor._mappings[i2]);
                                    webapp.getServletMappings().add((Object)servletMapping);
                                    ++i2;
                                }
                            }
                            webEdit.save((IProgressMonitor)new NullProgressMonitor());
                        }
                        iStatus = Status.OK_STATUS;
                        break block14;
                    }
                    catch (Exception e) {
                        IStatus iStatus3 = StatusUtils.errorStatus((String)AxisCreationUIMessages.MSG_ERROR_UPDATE_WEB_XML, (Throwable)e);
                        Object var13_17 = null;
                        if (webEdit == null) return iStatus3;
                        webEdit.dispose();
                        return iStatus3;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    if (webEdit == null) throw throwable;
                    webEdit.dispose();
                    throw throwable;
                }
            }
            webEdit.dispose();
            return iStatus2;
        }
        Object var13_16 = null;
        if (webEdit == null) return iStatus;
        webEdit.dispose();
        return iStatus;
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }

    public class ServletDescriptor {
        String _name;
        String _className;
        String _displayName;
        Map _params;
        String[] _mappings;
        Integer _loadOnStartup;
    }
}

