/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class BackupSkelImplCommand
extends AbstractDataModelOperation {
    private final String IMPL = "Impl";
    private final String DOT = ".";
    private final String BAK_EXT = "bak";
    private final String JAVA = "java";
    private WebServicesParser webServicesParser;
    private JavaWSDLParameter javaWSDLParam;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam == null) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        IStatus status = Status.OK_STATUS;
        Definition definition = null;
        String wsdlURL = this.javaWSDLParam.getInputWsdlLocation();
        try {
            URL url = new URL(wsdlURL);
            definition = this.webServicesParser.getWSDLDefinition(url.toString());
        }
        catch (MalformedURLException malformedURLException) {
            wsdlURL = PlatformUtils.getFileURLFromPath((IPath)new Path(wsdlURL));
            definition = this.webServicesParser.getWSDLDefinition(wsdlURL);
        }
        Service service = null;
        Port port = null;
        if (definition == null) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionUIMessages.MSG_ERROR_WSDL_NO_DEFINITION, (Object[])new String[]{wsdlURL}));
            environment.getStatusHandler().reportError(status);
            return status;
        }
        StringBuffer beanName = new StringBuffer();
        String beanPackageName = WSDLUtils.getPackageName((Definition)definition);
        this.javaWSDLParam.setBeanPackage(beanPackageName);
        beanName.append(beanPackageName);
        beanName.append(".");
        service = (Service)definition.getServices().values().iterator().next();
        port = (Port)service.getPorts().values().iterator().next();
        Binding binding = port.getBinding();
        beanName.append(binding.getQName().getLocalPart());
        beanName.append("Impl");
        String beanNameString = beanName.toString();
        this.javaWSDLParam.setBeanName(beanNameString);
        FileInputStream finStream = null;
        ResourceContext context = WebServicePlugin.getInstance().getResourceContext();
        IStatusHandler statusHandler = environment.getStatusHandler();
        String beanNamePathString = beanNameString.replace('.', '/');
        IPath skelImplPath = new Path(this.javaWSDLParam.getJavaOutput()).append((IPath)new Path(beanNamePathString)).addFileExtension("java");
        if (!skelImplPath.toFile().exists()) return status;
        IPath targetPath = skelImplPath.addFileExtension("bak");
        try {
            try {
                finStream = new FileInputStream(skelImplPath.toString());
                if (finStream != null) {
                    FileResourceUtils.createFileAtLocation((ResourceContext)context, (IPath)targetPath.makeAbsolute(), (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                    finStream.close();
                }
            }
            catch (Exception e) {
                status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionCoreMessages.MSG_ERROR_MOVE_RESOURCE, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                environment.getStatusHandler().reportError(status);
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            try {
                if (finStream == null) throw throwable;
                finStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var20_23 = null;
            try {}
            catch (IOException iOException) {
                return status;
            }
            if (finStream == null) return status;
            finStream.close();
            return status;
        }
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }
}

