/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.dtd.core.internal.validation.DTDValidationMessages;
import org.eclipse.wst.dtd.core.internal.validation.Validator;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction;

public class ValidateDTDAction
extends ValidateAction {
    public ValidateDTDAction(IFile file, boolean showDialog) {
        super(file, showDialog);
    }

    protected void validate(IFile fileToValidate) {
        ValidateAction.ValidationOutcome validationOutcome = new ValidateAction.ValidationOutcome((ValidateAction)this);
        IPath path = fileToValidate.getLocation();
        String uri = this.createURIForFilePath(path.toString());
        Validator dtdValidator = Validator.getInstance();
        this.clearMarkers(fileToValidate);
        ValidationReport valreport = dtdValidator.validate(uri);
        validationOutcome.isValid = valreport.isValid();
        validationOutcome.hasMessages = valreport.getValidationMessages().length != 0;
        this.createMarkers(fileToValidate, valreport.getValidationMessages());
        try {
            fileToValidate.setSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME, (Object)valreport.getNestedMessages());
        }
        catch (CoreException coreException) {}
        if (this.showDialog) {
            if (!validationOutcome.isValid) {
                String title = DTDValidationMessages._UI_DIALOG_DTD_INVALID_TITLE;
                String message = DTDValidationMessages._UI_DIALOG_DTD_INVALID_TEXT;
                this.openErrorDialog(title, message);
            } else {
                String title = DTDValidationMessages._UI_DIALOG_DTD_VALID_TITLE;
                String message = DTDValidationMessages._UI_DIALOG_DTD_VALID_TEXT;
                this.openValidDialog(title, message);
            }
        }
    }
}

