/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.jca.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.ConnectorComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactImportOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ConnectorComponentImportOperation
extends J2EEArtifactImportOperation {
    private static final String JAR_EXTENSION = ".jar";

    public ConnectorComponentImportOperation(IDataModel model) {
        super(model);
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        super.doExecute(monitor);
        this.addAssociateArchivesToClassPath();
    }

    protected void addAssociateArchivesToClassPath() {
        ArrayList<IClasspathEntry> extraEntries = new ArrayList<IClasspathEntry>();
        List archiveList = this.moduleFile.getArchiveFiles();
        Iterator iterator = archiveList.iterator();
        IVirtualFile vFile = null;
        IFile file = null;
        while (iterator.hasNext()) {
            Archive anArchive = (Archive)iterator.next();
            if (!anArchive.getName().endsWith(JAR_EXTENSION) || !(vFile = this.virtualComponent.getRootFolder().getFile(anArchive.getURI())).exists()) continue;
            file = vFile.getUnderlyingFile();
            extraEntries.add(JavaCore.newLibraryEntry((IPath)file.getFullPath(), (IPath)file.getFullPath(), null, (boolean)true));
        }
        try {
            ConnectorComponentImportOperation.addToClasspath((IDataModel)this.getDataModel(), extraEntries);
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    protected SaveStrategy createSaveStrategy(IVirtualComponent component) {
        ConnectorComponentSaveStrategyImpl saveStrat = new ConnectorComponentSaveStrategyImpl(component);
        return saveStrat;
    }
}

