/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.IDescriptionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorInstance;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;

public class NavigatorContentServiceDescriptionProvider
implements IDescriptionProvider {
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private final NavigatorContentService contentService;

    public NavigatorContentServiceDescriptionProvider(NavigatorContentService aContentService) {
        Assert.isNotNull((Object)aContentService);
        this.contentService = aContentService;
    }

    public String getDescription(Object anElement) {
        Object target;
        if (anElement instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)anElement;
            if (structuredSelection.size() > 1) {
                return this.getDefaultStatusBarMessage(structuredSelection.size());
            }
            target = structuredSelection.getFirstElement();
        } else {
            target = anElement;
        }
        List contentDescriptors = CONTENT_DESCRIPTOR_REGISTRY.getEnabledContentDescriptors(target);
        if (contentDescriptors.size() == 0) {
            return this.getDefaultStatusBarMessage(0);
        }
        NavigatorContentDescriptor contentDescriptor = (NavigatorContentDescriptor)contentDescriptors.get(0);
        NavigatorContentDescriptorInstance contentDescriptorInstance = this.contentService.getDescriptorInstance(contentDescriptor);
        ICommonLabelProvider labelProvider = contentDescriptorInstance.getLabelProvider();
        String message = labelProvider.getDescription(target);
        message = message != null ? message : this.getDefaultStatusBarMessage(1);
        return message;
    }

    protected final String getDefaultStatusBarMessage(int aSize) {
        return NavigatorMessages.getString(NavigatorMessages.Navigator_statusLineMultiSelect, new Object[]{new Integer(aSize)});
    }
}

