/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;

public class NavigatorViewerDescriptor {
    public static final String DEFAULT_POPUP_MENU_ID = "#CommonNavigatorPopupMenu";
    protected static final String ROOT_CONTENT_EXTENSION = "rootContentExtension";
    protected static final String ATT_VIEWER_ID = "viewerId";
    protected static final String ATT_CONTENT_EXTENSION_ID = "rootContentExtensionId";
    protected static final String ATT_ROOTID = "rootContentExtensionId";
    private static final String ATT_POPUP_MENU_ID = "popupMenuId";
    public static final String[] DEFAULT_VIEWER_ID = new String[]{String.valueOf(NavigatorPlugin.PLUGIN_ID) + ".viewer"};
    private final String viewerId;
    private final Set rootExtensionIds = new HashSet();
    private String popupMenuId = null;

    public NavigatorViewerDescriptor(String aViewerId) {
        this.viewerId = aViewerId;
    }

    public NavigatorViewerDescriptor(IConfigurationElement configElement) throws WorkbenchException {
        this.viewerId = configElement.getAttribute(ATT_VIEWER_ID);
        if (this.viewerId == null) {
            throw new WorkbenchException("Missing attribute: viewerId in navigator view extension: " + configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        this.consume(configElement);
    }

    public void consume(IConfigurationElement element) throws WorkbenchException {
        String rootExtensionId = element.getAttribute("rootContentExtensionId");
        String thePopupMenuId = element.getAttribute(ATT_POPUP_MENU_ID);
        if (thePopupMenuId != null) {
            if (this.popupMenuId != null) {
                NavigatorPlugin.log("Warning: popupMenuId of \"" + this.getViewerId() + "\" was overridden: old value = \"" + this.popupMenuId + "\", new value = \"" + thePopupMenuId + "\".");
            }
            this.popupMenuId = thePopupMenuId;
        }
        if (rootExtensionId != null) {
            this.addRootContentExtensionId(rootExtensionId);
        } else {
            IConfigurationElement[] rootContentExtensions = element.getChildren(ROOT_CONTENT_EXTENSION);
            int i = 0;
            while (i < rootContentExtensions.length) {
                this.addRootContentExtensionId(rootContentExtensions[i]);
                ++i;
            }
        }
        if (rootExtensionId == null) {
            throw new WorkbenchException("Missing attribute: rootContentExtensionId in navigator view extension: " + element.getDeclaringExtension().getUniqueIdentifier());
        }
    }

    public String getViewerId() {
        return this.viewerId;
    }

    public String getRootExtensionId() {
        if (this.rootExtensionIds.size() == 0) {
            return DEFAULT_VIEWER_ID[0];
        }
        return this.rootExtensionIds.toArray(new String[this.rootExtensionIds.size()])[0];
    }

    public String[] getRootContentExtensionIds() {
        if (this.rootExtensionIds.size() == 0) {
            return DEFAULT_VIEWER_ID;
        }
        return this.rootExtensionIds.toArray(new String[this.rootExtensionIds.size()]);
    }

    public String getPopupMenuId() {
        return this.popupMenuId != null ? this.popupMenuId : DEFAULT_POPUP_MENU_ID;
    }

    public boolean filtersContentDescriptor(NavigatorContentDescriptor descriptor) {
        return false;
    }

    protected boolean addRootContentExtensionId(String rootContentExtensionId) {
        if (rootContentExtensionId != null) {
            this.rootExtensionIds.add(rootContentExtensionId);
            return true;
        }
        return false;
    }

    protected void addRootContentExtensionId(IConfigurationElement rootContentExtension) {
        String rootContentExtensionId = rootContentExtension.getAttribute("rootContentExtensionId");
        this.addRootContentExtensionId(rootContentExtensionId);
    }
}

