/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.deployables;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public abstract class ComponentDeployable
extends ProjectModule {
    protected IVirtualComponent component = null;
    protected List members = new ArrayList();

    public ComponentDeployable(IProject project) {
        super(project);
        this.component = ComponentCore.createComponent((IProject)project);
    }

    public boolean isBinary() {
        return false;
    }

    private void addMembersToModuleFolder(ModuleFolder mf, IModuleResource[] mr) {
        if (mf == null) {
            return;
        }
        HashSet<IModuleResource> membersJoin = new HashSet<IModuleResource>();
        if (mf.members() != null) {
            membersJoin.addAll(Arrays.asList(mf.members()));
        }
        if (mr != null && mr.length > 0) {
            membersJoin.addAll(Arrays.asList(mr));
        }
        mf.setMembers(membersJoin.toArray(new IModuleResource[membersJoin.size()]));
    }

    public IModule[] getChildModules() {
        return this.getModules();
    }

    public IModule[] getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (this.component != null) {
            IVirtualReference[] components = this.component.getReferences();
            int i = 0;
            while (i < components.length) {
                IModule module;
                IVirtualReference reference = components[i];
                IVirtualComponent virtualComp = reference.getReferencedComponent();
                if (virtualComp != null && virtualComp.getProject() != this.component.getProject() && (module = ServerUtil.getModule((IProject)virtualComp.getProject())) != null && !modules.contains(module)) {
                    modules.add(module);
                }
                ++i;
            }
        }
        return modules.toArray(new IModule[modules.size()]);
    }

    protected IModuleResource[] getMembers(IContainer cont, IPath path, IPath javaPath, IContainer[] javaCont) throws CoreException {
        IResource[] res = cont.members();
        int size2 = res.length;
        ArrayList<Object> list = new ArrayList<Object>(size2);
        int j = 0;
        while (j < size2) {
            if (res[j] instanceof IContainer) {
                IContainer cc = (IContainer)res[j];
                IPath newPath = path.append(cc.getName());
                ModuleFolder mf = (ModuleFolder)this.getExistingModuleResource(this.members, newPath);
                if (mf == null) {
                    mf = new ModuleFolder(cc, cc.getName(), path);
                    list.add(mf);
                }
                IModuleResource[] mr = this.getMembers(cc, newPath, javaPath, javaCont);
                if (javaPath != null && newPath.isPrefixOf(javaPath)) {
                    mr = this.handleJavaPath(path, javaPath, newPath, javaCont, mr, cc);
                }
                this.addMembersToModuleFolder(mf, mr);
            } else {
                IFile f = (IFile)res[j];
                if (path.equals((Object)javaPath)) {
                    ModuleFolder mFolder = (ModuleFolder)this.getExistingModuleResource(this.members, javaPath);
                    ModuleFile mFile = new ModuleFile(f, f.getName(), javaPath, f.getModificationStamp() + f.getLocalTimeStamp());
                    if (mFolder != null) {
                        this.addMembersToModuleFolder(mFolder, new IModuleResource[]{mFile});
                    } else {
                        list.add(mFile);
                    }
                } else {
                    ModuleFile mf = new ModuleFile(f, f.getName(), path, f.getModificationStamp() + f.getLocalTimeStamp());
                    list.add(mf);
                }
            }
            ++j;
        }
        IModuleResource[] mr = new IModuleResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    protected IModuleResource[] getMembers(IVirtualContainer cont, IPath path) throws CoreException {
        IVirtualResource[] res = cont.members();
        int size2 = res.length;
        ArrayList<ModuleFolder> list = new ArrayList<ModuleFolder>(size2);
        int j = 0;
        while (j < size2) {
            ModuleFolder mf;
            if (res[j] instanceof IVirtualContainer) {
                IVirtualContainer cc = (IVirtualContainer)res[j];
                mf = (ModuleFolder)this.getExistingModuleResource(this.members, (IPath)new Path(cc.getName()));
                if (mf == null) {
                    mf = new ModuleFolder((IContainer)cc.getUnderlyingResource(), cc.getName(), path);
                    list.add(mf);
                }
                IModuleResource[] mr = this.getMembers(cc, path.append(cc.getName()));
                this.addMembersToModuleFolder(mf, mr);
            } else {
                IFile f = (IFile)res[j].getUnderlyingResource();
                if (!this.isFileInSourceContainer(f)) {
                    mf = new ModuleFile(f, f.getName(), path, f.getModificationStamp() + f.getLocalTimeStamp());
                    list.add(mf);
                }
            }
            ++j;
        }
        IModuleResource[] mr = new IModuleResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    protected boolean isFileInSourceContainer(IFile file) {
        return false;
    }

    private IModuleResource getExistingModuleResource(List aList, IPath path) {
        IModuleResource result = null;
        if (aList == null || aList.isEmpty()) {
            return null;
        }
        int i = 0;
        do {
            IModuleResource moduleResource;
            if ((moduleResource = (IModuleResource)aList.get(i)).getModuleRelativePath().append(moduleResource.getName()).equals((Object)path)) {
                result = moduleResource;
                continue;
            }
            if (!(moduleResource instanceof IModuleFolder)) continue;
            result = this.getExistingModuleResource(Arrays.asList(((IModuleFolder)moduleResource).members()), path);
        } while (result == null && ++i < aList.size());
        return result;
    }

    protected IModuleResource[] handleJavaPath(IPath path, IPath javaPath, IPath curPath, IContainer[] javaCont, IModuleResource[] mr, IContainer cc) throws CoreException {
        return new IModuleResource[0];
    }

    public IModuleResource[] members() throws CoreException {
        this.members.clear();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null) {
            IVirtualFolder vFolder = vc.getRootFolder();
            IModuleResource[] mr = this.getMembers((IVirtualContainer)vFolder, (IPath)Path.EMPTY);
            int size = mr.length;
            int j = 0;
            while (j < size) {
                if (!this.members.contains(mr[j])) {
                    this.members.add(mr[j]);
                }
                ++j;
            }
            List utilMembers = this.getUtilMembers(vc);
            if (!utilMembers.isEmpty()) {
                this.members.addAll(utilMembers);
            }
        }
        IModuleResource[] mr = new IModuleResource[this.members.size()];
        this.members.toArray(mr);
        return mr;
    }

    protected List getUtilMembers(IVirtualComponent vc) {
        ArrayList<ModuleFile> utilMembers = new ArrayList<ModuleFile>();
        IVirtualReference[] components = vc.getReferences();
        int i = 0;
        while (i < components.length) {
            IVirtualReference reference = components[i];
            IVirtualComponent virtualComp = reference.getReferencedComponent();
            if (virtualComp != null && virtualComp.isBinary()) {
                IPath archivePath = ((VirtualArchiveComponent)virtualComp).getWorkspaceRelativePath();
                ModuleFile mf = null;
                if (archivePath != null) {
                    IFile utilFile = ResourcesPlugin.getWorkspace().getRoot().getFile(archivePath);
                    mf = new ModuleFile(utilFile, utilFile.getName(), reference.getRuntimePath().makeRelative());
                } else {
                    File extFile = ((VirtualArchiveComponent)virtualComp).getUnderlyingDiskFile();
                    mf = new ModuleFile(extFile, extFile.getName(), reference.getRuntimePath().makeRelative());
                }
                if (mf != null) {
                    IModuleResource moduleParent = this.getExistingModuleResource(this.members, mf.getModuleRelativePath());
                    if (moduleParent != null && moduleParent instanceof ModuleFolder) {
                        this.addMembersToModuleFolder((ModuleFolder)moduleParent, new IModuleResource[]{mf});
                    } else {
                        utilMembers.add(mf);
                    }
                }
            }
            ++i;
        }
        return utilMembers;
    }

    public IContainer[] getResourceFolders() {
        IVirtualFolder vFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null && (vFolder = vc.getRootFolder()) != null) {
            return vFolder.getUnderlyingFolders();
        }
        return new IContainer[0];
    }
}

