/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.deployables;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.util.IStaticWeb;
import org.eclipse.wst.web.internal.deployables.ComponentDeployable;

public class StaticWebDeployable
extends ComponentDeployable
implements IStaticWeb {
    public StaticWebDeployable(IProject project, IVirtualComponent component) {
        super(project);
    }

    public String getContextRoot() {
        Properties props = this.component.getMetaProperties();
        if (props.containsKey("context-root")) {
            return props.getProperty("context-root");
        }
        return this.component.getName();
    }

    public String getURI(IModule module) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)module.getProject());
        String aURI = null;
        if (comp != null && !comp.isBinary() && this.isProjectOfType(module.getProject(), "wst.web")) {
            IVirtualReference ref = this.component.getReference(comp.getName());
            aURI = ref.getRuntimePath().append(String.valueOf(comp.getName()) + ".war").toString();
        }
        if (aURI != null && aURI.length() > 1 && aURI.startsWith("/")) {
            aURI = aURI.substring(1);
        }
        return aURI;
    }

    private boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    public String getVersion() {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)this.component.getProject());
            if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)"wst.web")) {
                IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)"wst.web");
                return facetedProject.getInstalledVersion(projectFacet).getVersionString();
            }
        }
        catch (Exception exception) {}
        return "1.0";
    }
}

