/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentOperation;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.util.ArtifactEditRegistryReader;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ComponentUtilities {
    static /* synthetic */ Class class$0;

    public static void ensureContainerNotReadOnly(IResource resource) {
        IContainer container;
        if (resource != null && !resource.exists() && (container = resource.getParent()) != null) {
            ResourceAttributes attr = container.getResourceAttributes();
            if (!attr.isReadOnly()) {
                container = container.getParent();
            }
            attr.setReadOnly(false);
        }
    }

    public static IFolder createFolderInComponent(IVirtualComponent component, String folderName) throws CoreException {
        if (folderName != null) {
            IVirtualFolder rootfolder = component.getRootFolder();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(new Path(rootfolder.getProject().getName()).append(folderName));
            if (!folder.exists()) {
                ProjectUtilities.ensureContainerNotReadOnly((IResource)folder);
                folder.create(true, true, null);
            }
            return folder;
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForRead(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader;
        IArtifactEditFactory factory;
        if (comp != null && (factory = (reader = ArtifactEditRegistryReader.instance()).getArtifactEdit(comp.getProject())) != null) {
            return factory.createArtifactEditForRead(comp);
        }
        return null;
    }

    public static IFile findFile(IVirtualComponent comp, IPath aPath) throws CoreException {
        if (comp == null || aPath == null) {
            return null;
        }
        IVirtualFolder root = comp.getRootFolder();
        IVirtualResource file = root.findMember(aPath);
        if (file != null) {
            return (IFile)file.getUnderlyingResource();
        }
        return null;
    }

    public static IVirtualComponent findComponent(IResource res) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.componentcore.resources.IVirtualComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IVirtualComponent)res.getAdapter((Class)clazz);
    }

    public static IVirtualComponent[] getAllWorkbenchComponents() {
        ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        int i = 0;
        while (i < projects.size()) {
            if (ModuleCoreNature.isFlexibleProject(projects.get(i))) {
                IVirtualComponent wbComp = ComponentCore.createComponent(projects.get(i));
                components.add(wbComp);
            }
            ++i;
        }
        IVirtualComponent[] temp = components.toArray(new VirtualComponent[components.size()]);
        return temp;
    }

    public static IVirtualComponent getComponent(String componentName) {
        IVirtualComponent[] allComponents = ComponentUtilities.getAllWorkbenchComponents();
        int i = 0;
        while (i < allComponents.length) {
            if (allComponents[i].getName().equals(componentName)) {
                return allComponents[i];
            }
            ++i;
        }
        return null;
    }

    public static ArtifactEdit getArtifactEditForWrite(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader;
        IArtifactEditFactory factory;
        if (comp != null && (factory = (reader = ArtifactEditRegistryReader.instance()).getArtifactEdit(comp.getProject())) != null) {
            return factory.createArtifactEditForWrite(comp);
        }
        return null;
    }

    public static IVirtualComponent findComponent(EObject anObject) {
        Resource res = anObject.eResource();
        return ComponentUtilities.findComponent(res);
    }

    public static IVirtualComponent findComponent(Resource aResource) {
        IFile iFile = WorkbenchResourceHelper.getFile((Resource)aResource);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.componentcore.resources.IVirtualComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IVirtualComponent)iFile.getAdapter((Class)clazz);
    }

    public static CreateReferenceComponentsOp createReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        return new CreateReferenceComponentsOp(model);
    }

    public static CreateReferenceComponentsOp createWLPReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
        return new CreateReferenceComponentsOp(model);
    }

    public static RemoveReferenceComponentOperation removeWLPReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
        return new RemoveReferenceComponentOperation(model);
    }

    public static RemoveReferenceComponentOperation removeReferenceComponentOperation(IVirtualComponent sourceComponent, List targetComponentProjects) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
        model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComponent);
        List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modHandlesList.addAll(targetComponentProjects);
        model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
        return new RemoveReferenceComponentOperation(model);
    }

    public static IVirtualComponent[] getComponents(IProject[] projects) {
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
        if (projects != null) {
            int i = 0;
            while (i < projects.length) {
                IVirtualComponent comp;
                if (projects[i] != null && (comp = ComponentCore.createComponent(projects[i])) != null && comp.exists()) {
                    result.add(comp);
                }
                ++i;
            }
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }

    /*
     * Exception decompiling
     */
    public static String getServerContextRoot(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 56->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setServerContextRoot(IProject project, String contextRoot) {
        IVirtualComponent comp = ComponentCore.createComponent(project);
        comp.setMetaProperty("context-root", contextRoot);
    }
}

