/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.XMLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.WSDLPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.Endpoint;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.InvokeWSDLOperationTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.SOAPMessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport.HTTPException;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.transport.HTTPTransport;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.util.SoapHelper;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class InvokeWSDLSOAPOperationAction
extends WSDLPropertiesFormAction {
    public InvokeWSDLSOAPOperationAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        super.processParsedResults(parser);
        String endPoint = parser.getParameter("::endPoint");
        InvokeWSDLOperationTool invokeWSDLOperationTool = (InvokeWSDLOperationTool)this.getSelectedNavigatorNode().getCurrentToolManager().getSelectedTool();
        invokeWSDLOperationTool.setEndPoint(endPoint);
        return true;
    }

    protected final void addRPCWrapper(Vector bodyEntries, WSDLElement wsdlElement, WSDLOperationElement operElement, Hashtable soapEnvelopeNamespaceTable) throws ParserConfigurationException {
        BindingInput bindingInput;
        String encodingNamespaceURI = null;
        BindingOperation bindingOperation = operElement.getBindingOperation();
        if (bindingOperation != null && (bindingInput = bindingOperation.getBindingInput()) != null) {
            List extElements = bindingInput.getExtensibilityElements();
            Iterator it = extElements.iterator();
            while (it.hasNext()) {
                ExtensibilityElement extElement = (ExtensibilityElement)it.next();
                if (!(extElement instanceof SOAPBody)) continue;
                encodingNamespaceURI = ((SOAPBody)extElement).getNamespaceURI();
                break;
            }
        }
        if (encodingNamespaceURI == null) {
            encodingNamespaceURI = operElement.getEncodingNamespace();
        }
        if (encodingNamespaceURI == null) {
            Definition definition = wsdlElement.getDefinition();
            encodingNamespaceURI = definition.getTargetNamespace();
        }
        Document doc = XMLUtils.createNewDocument(null);
        String encodingStyle = operElement.isUseLiteral() ? null : operElement.getEncodingStyle();
        Element wrapperElement = SoapHelper.createRPCWrapperElement(doc, soapEnvelopeNamespaceTable, encodingNamespaceURI, operElement.getOperation().getName(), encodingStyle);
        int i = 0;
        while (i < bodyEntries.size()) {
            wrapperElement.appendChild(doc.importNode((Element)bodyEntries.elementAt(i), true));
            ++i;
        }
        bodyEntries.removeAllElements();
        bodyEntries.addElement(wrapperElement);
    }

    protected Vector getBodyEntries(Hashtable soapEnvelopeNamespaceTable, WSDLOperationElement operElement, WSDLBindingElement bindingElement, WSDLServiceElement serviceElement) throws ParserConfigurationException, Exception {
        Vector<Element> bodyEntries = new Vector<Element>();
        boolean isUseLiteral = operElement.isUseLiteral();
        String encodingStyle = operElement.getEncodingStyle();
        boolean addEncodingStyle = !isUseLiteral && !"http://schemas.xmlsoap.org/soap/encoding/".equals(encodingStyle);
        Iterator it = operElement.getOrderedBodyParts().iterator();
        while (it.hasNext()) {
            Part part = (Part)it.next();
            IXSDFragment frag = operElement.getFragment(part);
            Element[] instanceDocuments = frag.genInstanceDocumentsFromParameterValues(!isUseLiteral, soapEnvelopeNamespaceTable, XMLUtils.createNewDocument(null));
            int j = 0;
            while (j < instanceDocuments.length) {
                if (instanceDocuments[j] != null) {
                    if (addEncodingStyle) {
                        instanceDocuments[j].setAttribute("soapenv:encodingStyle", encodingStyle);
                    }
                    bodyEntries.addElement(instanceDocuments[j]);
                }
                ++j;
            }
        }
        if (!operElement.isDocumentStyle()) {
            this.addRPCWrapper(bodyEntries, (WSDLElement)serviceElement.getParentElement(), operElement, soapEnvelopeNamespaceTable);
        }
        return bodyEntries;
    }

    protected Element getSOAPEnvelope(Hashtable soapEnvelopeNamespaceTable, Vector bodyEntries) throws ParserConfigurationException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = XMLUtils.createNewDocument(docBuilder);
        Element soapEnvelopeElement = SoapHelper.createSoapEnvelopeElement(doc, soapEnvelopeNamespaceTable);
        Element soapBodyElement = SoapHelper.createSoapBodyElement(doc);
        int i = 0;
        while (i < bodyEntries.size()) {
            soapBodyElement.appendChild(doc.importNode((Element)bodyEntries.elementAt(i), true));
            ++i;
        }
        soapEnvelopeElement.appendChild(soapBodyElement);
        return soapEnvelopeElement;
    }

    private final void recordSoapRequest(SOAPMessageQueue soapRequestQueue, Hashtable soapEnvelopeNamespaceTable, Element soapEnvelope) throws ParserConfigurationException, IOException {
        soapRequestQueue.clear();
        soapRequestQueue.addMessage(XMLUtils.serialize(soapEnvelope, false));
    }

    private final void recordSOAPResponse(SOAPMessageQueue soapResponseQueue, BufferedReader responseReader) throws IOException {
        soapResponseQueue.clear();
        if (responseReader != null) {
            String line = null;
            while ((line = responseReader.readLine()) != null) {
                soapResponseQueue.addMessage(line);
            }
            responseReader.close();
        }
    }

    public boolean run() {
        String soapAddressLocation = (String)this.propertyTable_.get("::endPoint");
        WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
        MessageQueue messageQueue = wsdlPerspective.getMessageQueue();
        WSDLOperationElement operElement = (WSDLOperationElement)this.getSelectedNavigatorNode().getTreeElement();
        WSDLBindingElement bindingElement = (WSDLBindingElement)operElement.getParentElement();
        WSDLServiceElement serviceElement = (WSDLServiceElement)bindingElement.getParentElement();
        operElement.setPropertyAsObject("soapResponseCached", new Boolean(false));
        try {
            Hashtable soapEnvelopeNamespaceTable = new Hashtable();
            SoapHelper.addDefaultSoapEnvelopeNamespaces(soapEnvelopeNamespaceTable);
            Vector bodyEntries = this.getBodyEntries(soapEnvelopeNamespaceTable, operElement, bindingElement, serviceElement);
            Element soapEnvelope = this.getSOAPEnvelope(soapEnvelopeNamespaceTable, bodyEntries);
            this.recordSoapRequest(wsdlPerspective.getSOAPRequestQueue(), soapEnvelopeNamespaceTable, soapEnvelope);
            if (soapAddressLocation != null) {
                HTTPTransport transport = this.createTransport(bindingElement, soapAddressLocation);
                transport.send(NetUtils.createURL((String)soapAddressLocation), operElement.getSoapAction(), XMLUtils.serialize(soapEnvelope, true));
                this.recordSOAPResponse(wsdlPerspective.getSOAPResponseQueue(), transport.receive());
                wsdlPerspective.setOperationNode(this.getSelectedNavigatorNode());
                return true;
            }
            throw new IOException(wsdlPerspective.getMessage("MSG_ERROR_UNABLE_TO_CONNECT", soapAddressLocation));
        }
        catch (ParserConfigurationException e) {
            this.handleUnexpectedException(wsdlPerspective, messageQueue, "ParserConfigurationException", e);
        }
        catch (IOException e) {
            this.handleUnexpectedException(wsdlPerspective, messageQueue, "IOException", e);
        }
        catch (HTTPException httpe) {
            this.throwHTTPException(bindingElement, soapAddressLocation, httpe);
        }
        catch (Exception e) {
            this.handleUnexpectedException(wsdlPerspective, messageQueue, "Exception", e);
        }
        return false;
    }

    private void throwHTTPException(WSDLBindingElement bindingElement, String endpointString, HTTPException httpException) throws HTTPException {
        Endpoint endpoint;
        if (httpException.getStatusCode() == 401 && (endpoint = bindingElement.getEndpoint(endpointString)) != null) {
            endpoint.setRequireHTTPBasicAuth(true);
            endpoint.setHttpBasicAuthUsername(null);
            endpoint.setHttpBasicAuthPassword(null);
        }
        throw httpException;
    }

    private HTTPTransport createTransport(WSDLBindingElement bindingElement, String endpointString) {
        HTTPTransport transport = new HTTPTransport();
        Endpoint endpoint = bindingElement.getEndpoint(endpointString);
        if (endpoint != null && endpoint.isRequireHTTPBasicAuth()) {
            String httpBasicAuthUsername = endpoint.getHttpBasicAuthUsername();
            String httpBasicAuthPassword = endpoint.getHttpBasicAuthPassword();
            if (httpBasicAuthUsername == null || httpBasicAuthPassword == null) {
                httpBasicAuthUsername = (String)this.propertyTable_.get("httpBasicAuthUsername");
                httpBasicAuthPassword = (String)this.propertyTable_.get("httpBasicAuthPassword");
                endpoint.setHttpBasicAuthUsername(httpBasicAuthUsername);
                endpoint.setHttpBasicAuthPassword(httpBasicAuthPassword);
            }
            if (httpBasicAuthUsername != null && httpBasicAuthPassword != null) {
                transport.setHttpBasicAuthUsername(httpBasicAuthUsername);
                transport.setHttpBasicAuthPassword(httpBasicAuthPassword);
            }
        }
        return transport;
    }
}

