/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDElementFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDDelegationFragment;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDElementFragment
extends XSDDelegationFragment
implements IXSDElementFragment {
    private int minOccurs_;
    private int maxOccurs_;

    public XSDElementFragment(String id, String name, XSDToFragmentConfiguration config) {
        super(id, name, config);
        if (config != null) {
            this.minOccurs_ = config.getMinOccurs();
            this.maxOccurs_ = config.getMaxOccurs();
        } else {
            this.minOccurs_ = 1;
            this.maxOccurs_ = 1;
        }
    }

    public boolean processParameterValues(MultipartFormDataParser parser) throws MultipartFormDataException {
        IXSDFragment elementTypeFragment = this.getXSDDelegationFragment();
        if (!elementTypeFragment.processParameterValues(parser)) {
            return false;
        }
        String[] params = this.getParameterValues(elementTypeFragment.getID());
        return params == null || this.withinRange(params.length);
    }

    public boolean validateAllParameterValues() {
        IXSDFragment elementTypeFragment = this.getXSDDelegationFragment();
        String[] params = this.getParameterValues(elementTypeFragment.getID());
        if (params != null && !this.withinRange(params.length)) {
            return false;
        }
        return elementTypeFragment.validateAllParameterValues();
    }

    public boolean validateParameterValues(String paramKey) {
        String[] params = this.getParameterValues(paramKey);
        if (params != null && !this.withinRange(params.length)) {
            return false;
        }
        return this.getXSDDelegationFragment().validateParameterValues(paramKey);
    }

    public boolean validateParameterValue(String paramKey, int paramIndex) {
        if (!this.withinRange(paramIndex + 1)) {
            return false;
        }
        XSDElementDeclaration xsdElement = (XSDElementDeclaration)this.getXSDToFragmentConfiguration().getXSDComponent();
        String param = this.getParameterValue(paramKey, paramIndex);
        if (param != null && param.length() <= 0 && !xsdElement.isNillable()) {
            return false;
        }
        return this.getXSDDelegationFragment().validateParameterValue(paramKey, paramIndex);
    }

    public void setXSDToFragmentConfiguration(XSDToFragmentConfiguration config) {
        super.setXSDToFragmentConfiguration(config);
        this.minOccurs_ = config.getMinOccurs();
        this.maxOccurs_ = config.getMaxOccurs();
    }

    public boolean setParameterValuesFromInstanceDocuments(Element[] instanceDocuments) {
        Element[] instanceDocumentsCopy = instanceDocuments;
        XSDToFragmentConfiguration config = this.getXSDToFragmentConfiguration();
        String wsdlPartName = config.getWSDLPartName();
        if (config.getIsWSDLPart() && config.getStyle() == 1 && wsdlPartName != null && wsdlPartName.length() > 0 && instanceDocumentsCopy.length == 1 && wsdlPartName.equals(instanceDocumentsCopy[0].getTagName())) {
            NodeList nl = instanceDocumentsCopy[0].getChildNodes();
            Vector<Node> childElements = new Vector<Node>();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getNodeType() == 1) {
                    childElements.add(node);
                }
                ++i;
            }
            instanceDocumentsCopy = childElements.toArray(new Element[0]);
        }
        IXSDFragment elementTypeFragment = this.getXSDDelegationFragment();
        instanceDocumentsCopy = this.getInstanceDocumentsByTagName(instanceDocumentsCopy, this.getName());
        return elementTypeFragment.setParameterValuesFromInstanceDocuments(this.setElementsTagName(instanceDocumentsCopy, elementTypeFragment.getName()));
    }

    public Element[] genInstanceDocumentsFromParameterValues(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        Element[] instanceDocuments = this.getXSDDelegationFragment().genInstanceDocumentsFromParameterValues(genXSIType, namespaceTable, doc);
        instanceDocuments = this.setElementsTagName(instanceDocuments, this.getInstanceDocumentTagName(namespaceTable));
        XSDToFragmentConfiguration config = this.getXSDToFragmentConfiguration();
        String wsdlPartName = config.getWSDLPartName();
        if (config.getIsWSDLPart() && config.getStyle() == 1 && wsdlPartName != null && wsdlPartName.length() > 0) {
            Element[] instanceDocumentsCopy = instanceDocuments;
            instanceDocuments = new Element[]{doc.createElement(wsdlPartName)};
            int i = 0;
            while (i < instanceDocumentsCopy.length) {
                if (instanceDocumentsCopy[i] != null) {
                    instanceDocuments[0].appendChild(instanceDocumentsCopy[i]);
                }
                ++i;
            }
        }
        return instanceDocuments;
    }

    protected boolean isInstanceNamespaceQualified() {
        XSDToFragmentConfiguration config = this.getXSDToFragmentConfiguration();
        if (config.getPartEncoding() == 0) {
            XSDElementDeclaration xsdElement = (XSDElementDeclaration)config.getXSDComponent();
            if (xsdElement.getResolvedElementDeclaration() != null) {
                xsdElement = xsdElement.getResolvedElementDeclaration();
            }
            if (xsdElement.isGlobal()) {
                return true;
            }
            if (xsdElement.isSetForm()) {
                return xsdElement.getForm().getValue() == 0;
            }
            return xsdElement.getSchema().getElementFormDefault().getValue() == 0;
        }
        return false;
    }

    protected String getInstanceDocumentTagName(Hashtable namespaceTable) {
        String xsdElementName;
        XSDToFragmentConfiguration config = this.getXSDToFragmentConfiguration();
        XSDElementDeclaration xsdElement = (XSDElementDeclaration)config.getXSDComponent();
        StringBuffer tagName = new StringBuffer();
        if (this.isInstanceNamespaceQualified()) {
            String nsURI = null;
            nsURI = xsdElement.getResolvedElementDeclaration() != null ? xsdElement.getResolvedElementDeclaration().getTargetNamespace() : xsdElement.getTargetNamespace();
            if (nsURI != null && nsURI.length() > 0) {
                String prefix = this.getPrefixFromNamespaceURI(nsURI, namespaceTable);
                tagName.append(prefix);
                tagName.append(":");
            }
        }
        if ((xsdElementName = xsdElement.getName()) == null || xsdElementName.length() <= 0) {
            xsdElementName = xsdElement.getResolvedElementDeclaration() != null ? xsdElement.getResolvedElementDeclaration().getName() : this.getName();
        }
        tagName.append(xsdElementName);
        return tagName.toString();
    }

    private boolean withinRange(int size) {
        if (size < this.minOccurs_) {
            return false;
        }
        return this.maxOccurs_ == -1 || size <= this.maxOccurs_;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs_ = minOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs_;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs_ = maxOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs_;
    }
}

