/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.ui.internal.cmp.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionDisplayProperty;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.UserIdentification;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.wizards.NewConnectionWizard;

public class ConnectionSelectionPage
extends DataModelWizardPage
implements SelectionListener {
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    protected boolean myFirstTime = true;
    protected Button reconnectButton;
    private Button newConnectionButton;
    private boolean connected;
    private org.eclipse.swt.widgets.List existingConnectionsList;
    private Hashtable existingConnections;
    private Label propertiesLabel;
    private Table connectionPropertiesTable;

    public ConnectionSelectionPage(IDataModel model, String pageName, String title, ImageDescriptor titleImage) {
        super(model, pageName, title, titleImage);
    }

    public ConnectionSelectionPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IEJBAnnotationConstants.CMP_CONNECTION_PAGE_DESC);
        this.setTitle(IEJBAnnotationConstants.CMP_CONNECTION_PAGE_TITLE);
    }

    public Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.newConnectionButton = new Button(composite, 8);
        this.newConnectionButton.setText(IEJBAnnotationConstants.CMP_CONNECTION_NEW_BUTTON);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.newConnectionButton.setLayoutData((Object)gd);
        Composite indentationComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        indentationComposite.setLayout((Layout)layout);
        indentationComposite.setLayoutData((Object)new GridData(1808));
        Group existingConnectionsGroup = new Group(indentationComposite, 0);
        existingConnectionsGroup.setText(IEJBAnnotationConstants.CMP_CONNECTION_AVAILABLE);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        existingConnectionsGroup.setLayout((Layout)layout);
        gd = new GridData(1808);
        existingConnectionsGroup.setLayoutData((Object)gd);
        this.existingConnectionsList = new org.eclipse.swt.widgets.List((Composite)existingConnectionsGroup, 2560);
        gd = new GridData(768);
        gd.heightHint = 100;
        this.existingConnectionsList.setLayoutData((Object)gd);
        this.propertiesLabel = new Label((Composite)existingConnectionsGroup, 0);
        this.propertiesLabel.setText(IEJBAnnotationConstants.CMP_CONNECTION_PROPERTIES);
        gd = new GridData();
        this.propertiesLabel.setLayoutData((Object)gd);
        this.connectionPropertiesTable = new Table((Composite)existingConnectionsGroup, 2048);
        gd = new GridData(1808);
        this.connectionPropertiesTable.setLayoutData((Object)gd);
        this.connectionPropertiesTable.setLinesVisible(true);
        this.connectionPropertiesTable.setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this.connectionPropertiesTable, 0);
        tc1.setText(IEJBAnnotationConstants.CMP_CONNECTION_PROPERTY);
        tc1.setResizable(true);
        tc1.setWidth(140);
        TableColumn tc2 = new TableColumn(this.connectionPropertiesTable, 0);
        tc2.setText(IEJBAnnotationConstants.CMP_CONNECTION_VALUE);
        tc2.setResizable(true);
        tc2.setWidth(250);
        this.initializeDialogUnits((Control)composite);
        this.setControl((Control)composite);
        this.newConnectionButton.addListener(13, (Listener)this);
        this.existingConnectionsList.addListener(13, (Listener)this);
        this.newConnectionButton.setSelection(true);
        this.initializeValues();
        this.setPageComplete(true);
        this.addReconnectButton(composite);
        return composite;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.newConnectionButton) {
            ConnectionInfo[] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
            ArrayList<String> nameList = new ArrayList<String>(infos.length);
            int i = 0;
            int n = infos.length;
            while (i < n) {
                if (!nameList.contains(infos[i].getName())) {
                    nameList.add(infos[i].getName().toLowerCase());
                }
                ++i;
            }
            String[] names = nameList.toArray(new String[nameList.size()]);
            NewConnectionWizard wizard = new NewConnectionWizard(null, true);
            wizard.init(PlatformUI.getWorkbench(), null);
            wizard.setNeedsProgressMonitor(false);
            wizard.setExistingConnectionNames(Arrays.asList(names));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            this.initializeValues();
        } else if (source == this.existingConnectionsList) {
            this.updateConnectionProperties();
            this.setPageComplete(true);
            this.reconnectButton.setEnabled(true);
        }
        this.reconnectButton.setEnabled(true);
        this.isValidConnection();
    }

    private void addReconnectButton(Composite parent) {
        this.reconnectButton = new Button(parent, 8);
        this.reconnectButton.setText(resourceLoader.queryString("CUI_CONN_SELECT_EXT_RECONNECT_BTN_LBL"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 1;
        this.reconnectButton.setLayoutData((Object)data);
        this.reconnectButton.addSelectionListener((SelectionListener)this);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void widgetDefaultSelected(SelectionEvent evt) {
    }

    public void widgetSelected(SelectionEvent evt) {
        ConnectionInfo info;
        UserIdentification userDialog;
        Object source = evt.getSource();
        if (source == this.reconnectButton && (userDialog = new UserIdentification((info = this.getSelectedConnection()).getUserName())).open() == 0) {
            String us = userDialog.getUserNameInformation();
            String pa = userDialog.getPasswordInformation();
            info.setUserName(us);
            info.setPassword(pa);
            try {
                this.getSelectedConnection().setPassword(pa);
                this.getSelectedConnection().setUserName(us);
                this.getSelectedConnection().connect();
                this.reconnectButton.setEnabled(false);
                this.connected = true;
            }
            catch (Exception ex) {
                this.reconnectButton.setEnabled(true);
                this.connected = false;
                MessageDialog.openError((Shell)this.getShell(), (String)resourceLoader.queryString("CUI_CONN_SELECT_EXT_ERROR_DIALOG_TITLE"), (String)ex.getMessage());
            }
            this.isValidConnection();
        }
    }

    private void initializeValues() {
        this.existingConnectionsList.removeAll();
        ConnectionInfo[] connInfos = this.getConnectionsToDisplay();
        if (connInfos != null) {
            this.existingConnections = new Hashtable();
            List<ConnectionInfo> sortedConnections = Arrays.asList(connInfos);
            this.sortConnections(sortedConnections);
            Iterator<ConnectionInfo> connections = sortedConnections.iterator();
            while (connections.hasNext()) {
                ConnectionInfo con = connections.next();
                this.existingConnections.put(con.getName(), con);
                this.existingConnectionsList.add(con.getName());
            }
        }
        if (this.existingConnectionsList.getItemCount() > 0) {
            this.existingConnectionsList.select(0);
            this.updateConnectionProperties();
        }
        this.newConnectionButton.setSelection(true);
    }

    protected void sortConnections(List connections) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((ConnectionInfo)o1).getName();
                String s2 = ((ConnectionInfo)o2).getName();
                return s1.compareToIgnoreCase(s2);
            }
        };
        Collections.sort(connections, c);
    }

    public ConnectionInfo getSelectedConnection() {
        if (this.existingConnections == null || this.existingConnectionsList == null || this.existingConnectionsList.getSelection().length == 0) {
            return null;
        }
        ConnectionInfo connection = (ConnectionInfo)this.existingConnections.get(this.existingConnectionsList.getSelection()[0]);
        return connection;
    }

    protected ConnectionInfo[] getConnectionsToDisplay() {
        return RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
    }

    public void refresh() {
        this.reconnectButton.setEnabled(true);
        this.connected = false;
        this.initializeValues();
        this.isValidConnection();
    }

    private void updateConnectionProperties() {
        ConnectionDisplayProperty[] properties;
        ConnectionInfo selectedConnection;
        this.connectionPropertiesTable.removeAll();
        if (this.existingConnectionsList.getSelectionIndex() > -1 && (selectedConnection = (ConnectionInfo)this.existingConnections.get(this.existingConnectionsList.getSelection()[0])) != null && (properties = this.getConnectionDisplayProperties(selectedConnection)) != null) {
            int propertyCount = properties.length;
            int index = 0;
            while (index < propertyCount) {
                TableItem tableItem = new TableItem(this.connectionPropertiesTable, 0);
                tableItem.setText(new String[]{properties[index].getPropertyName(), properties[index].getValue()});
                ++index;
            }
        }
    }

    private ConnectionDisplayProperty[] getConnectionDisplayProperties(ConnectionInfo connectionInfo) {
        Object[] properties = null;
        Vector<ConnectionDisplayProperty> propertiesCollection = new Vector<ConnectionDisplayProperty>();
        propertiesCollection.add(new ConnectionDisplayProperty(resourceLoader.queryString("_UI_JDBC_DRIVER_CLASS_CONNECTION_PROPERTY_NAME"), connectionInfo.getDriverClassName()));
        propertiesCollection.add(new ConnectionDisplayProperty(resourceLoader.queryString("_UI_CLASS_LOCATION_CONNECTION_PROPERTY_NAME"), connectionInfo.getLoadingPath()));
        propertiesCollection.add(new ConnectionDisplayProperty(resourceLoader.queryString("_UI_URL_CONNECTION_PROPERTY_NAME"), connectionInfo.getURL()));
        propertiesCollection.add(new ConnectionDisplayProperty(resourceLoader.queryString("_UI_USER_ID_CONNECTION_PROPERTY_NAME"), connectionInfo.getUserName()));
        properties = new ConnectionDisplayProperty[propertiesCollection.size()];
        propertiesCollection.copyInto(properties);
        return properties;
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    public boolean isPageComplete() {
        return this.connected;
    }

    /*
     * Exception decompiling
     */
    protected boolean isValidConnection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 75->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

