/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets.runtime;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.ProjectTopologyContext;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ClientRuntimeSelectionWidgetDefaultingCommand;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.FacetMatchCache;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerRuntimeSelectionWidgetDefaultingCommand
extends ClientRuntimeSelectionWidgetDefaultingCommand {
    private String DEFAULT_CLIENT_EAR_PROJECT_EXT = "EAR";
    private boolean generateProxy_;
    private TypeRuntimeServer serviceIds_;
    private boolean serviceIdsFixed_ = false;
    private String serviceRuntimeId_;
    private String serviceProjectName_;
    private String serviceEarProjectName_;
    private String serviceComponentType_;
    private IProject initialProject_;
    private boolean serviceNeedEAR_ = true;
    private FacetMatcher serviceFacetMatcher_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        try {
            IStatus serverStatus;
            IProject serviceProject;
            ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet drt;
            IStatus clientSideStatus = super.execute(monitor, null);
            if (clientSideStatus.getSeverity() == 4) {
                return clientSideStatus;
            }
            if (this.serviceIdsFixed_) {
                drt = this.getDefaultServiceRuntimeForFixedRuntimeAndServer(this.initialProject_);
                this.serviceFacetMatcher_ = drt.getFacetMatcher();
                this.serviceProjectName_ = drt.getProjectName();
                this.serviceRuntimeId_ = drt.getRuntimeId();
            } else {
                drt = this.getDefaultRuntime(this.initialProject_, this.serviceIds_.getTypeId(), false);
                this.serviceFacetMatcher_ = drt.getFacetMatcher();
                this.serviceProjectName_ = drt.getProjectName();
                this.serviceRuntimeId_ = drt.getRuntimeId();
                this.serviceIds_.setRuntimeId(WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_).getRuntime().getId());
            }
            if (this.serviceProjectName_ == null) {
                this.serviceProjectName_ = this.getDefaultServiceProjectName();
            }
            this.serviceComponentType_ = !(serviceProject = ProjectUtilities.getProject((String)this.serviceProjectName_)).exists() ? this.getDefaultServiceProjectTemplate() : "";
            this.updateClientProject(this.serviceProjectName_, this.serviceIds_.getTypeId());
            if (!this.serviceIdsFixed_ && (serverStatus = this.setServiceDefaultServer()).getSeverity() == 4) {
                env.getStatusHandler().reportError(serverStatus);
                return serverStatus;
            }
            this.setDefaultServiceEarProject();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Object[])new String[]{e.getMessage()}), (Throwable)e);
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
    }

    private void setDefaultServiceEarProject() {
        String serverTargetId;
        String serverId;
        IProject serviceProject = ProjectUtilities.getProject((String)this.serviceProjectName_);
        if (serviceProject.exists()) {
            this.serviceNeedEAR_ = !FacetUtils.isJavaProject((IProject)serviceProject);
        } else {
            boolean bl = this.serviceNeedEAR_ = !FacetUtils.isUtilityTemplate((String)this.serviceComponentType_);
        }
        if (this.serviceNeedEAR_ && (serverId = this.serviceIds_.getServerId()) != null && (serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverId)) != null && serverTargetId.length() > 0 && !ServerUtils.isTargetValidForEAR((String)serverTargetId, (String)"13")) {
            this.serviceNeedEAR_ = false;
        }
        if (this.serviceNeedEAR_) {
            this.serviceEarProjectName_ = this.getDefaultServiceEarProjectName();
            if (this.getClientNeedEAR()) {
                String defaultClientEarProjectName = this.getDefaultClientEarProjectName();
                IProject clientProject = ProjectUtilities.getProject((String)this.getClientProjectName());
                if (clientProject != null && clientProject.exists() && defaultClientEarProjectName.equalsIgnoreCase(this.serviceEarProjectName_)) {
                    this.setClientEarProjectName(defaultClientEarProjectName);
                } else {
                    ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
                    if (!ptc.isUseTwoEARs()) {
                        this.setClientEarProjectName(this.serviceEarProjectName_);
                    } else {
                        IProject proxyEARProject = this.getUniqueClientEAR(defaultClientEarProjectName, this.serviceEarProjectName_, this.getClientProjectName());
                        this.setClientEarProjectName(proxyEARProject.getName());
                    }
                }
            }
        } else {
            this.serviceEarProjectName_ = "";
        }
    }

    private String getDefaultServiceEarProjectName() {
        IVirtualComponent[] earComps;
        IProject serviceProject = ProjectUtilities.getProject((String)this.serviceProjectName_);
        if (serviceProject != null && serviceProject.exists() && (earComps = J2EEUtils.getReferencingEARComponents((IProject)serviceProject)).length > 0) {
            return earComps[0].getName();
        }
        IVirtualComponent[] allEarComps = J2EEUtils.getAllEARComponents();
        if (allEarComps.length > 0) {
            return allEarComps[0].getName();
        }
        return ResourceUtils.getDefaultServiceEARProjectName();
    }

    private IStatus setServiceDefaultServer() {
        IServerType serverType;
        IServer server;
        IProject serviceProject = ProjectUtilities.getProject((String)this.serviceProjectName_);
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)ServerUtils.getModule((IProject)serviceProject), null);
        if (configuredServers != null && configuredServers.length > 0) {
            this.serviceIds_.setServerId(configuredServers[0].getServerType().getId());
            this.serviceIds_.setServerInstanceId(configuredServers[0].getId());
            return Status.OK_STATUS;
        }
        if (serviceProject.exists()) {
            server = this.getServerFromProject(this.serviceProjectName_, this.serviceFacetMatcher_);
            if (server != null) {
                this.serviceIds_.setServerId(server.getServerType().getId());
                this.serviceIds_.setServerInstanceId(server.getId());
                return Status.OK_STATUS;
            }
            serverType = this.getServerTypeFromProject(this.serviceProjectName_, this.serviceFacetMatcher_);
            if (serverType != null) {
                this.serviceIds_.setServerId(serverType.getId());
                return Status.OK_STATUS;
            }
        }
        if ((server = this.getServerFromServiceRuntimeId()) != null) {
            this.serviceIds_.setServerId(server.getServerType().getId());
            this.serviceIds_.setServerInstanceId(server.getId());
            return Status.OK_STATUS;
        }
        serverType = this.getServerTypeFromServiceRuntimeId();
        if (serverType != null) {
            this.serviceIds_.setServerId(serverType.getId());
            return Status.OK_STATUS;
        }
        String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById((String)this.serviceIds_.getRuntimeId());
        String serverLabels = this.getServerLabels(this.serviceIds_.getRuntimeId());
        IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_NO_SERVER_RUNTIME, (Object[])new String[]{runtimeLabel, serverLabels}));
        return status;
    }

    private IServer getServerFromServiceRuntimeId() {
        IServer[] servers = ServerCore.getServers();
        if (servers != null && servers.length > 0) {
            int i = 0;
            while (i < servers.length) {
                String serverFactoryId = servers[i].getServerType().getId();
                if (WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer((String)this.serviceRuntimeId_, (String)serverFactoryId)) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    private IServerType getServerTypeFromServiceRuntimeId() {
        String[] serverTypes = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceRuntime((String)this.serviceRuntimeId_);
        if (serverTypes != null && serverTypes.length > 0) {
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String preferredServerFactoryId = context.getServerFactoryId();
            int i = 0;
            while (i < serverTypes.length) {
                if (serverTypes[i].equals(preferredServerFactoryId)) {
                    return ServerCore.findServerType((String)serverTypes[i]);
                }
                ++i;
            }
            return ServerCore.findServerType((String)serverTypes[0]);
        }
        return null;
    }

    private String getServerLabels(String serviceRuntimeId) {
        String[] validServerFactoryIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceRuntime((String)serviceRuntimeId);
        StringBuffer validServerLabels = new StringBuffer();
        int i = 0;
        while (i < validServerFactoryIds.length) {
            if (i > 0) {
                validServerLabels.append(", ");
            }
            validServerLabels.append(WebServiceRuntimeExtensionUtils.getServerLabelById((String)validServerFactoryIds[i]));
            ++i;
        }
        return validServerLabels.toString();
    }

    private String getDefaultServiceProjectTemplate() {
        boolean matches;
        String templateId;
        String[] templates = WebServiceRuntimeExtensionUtils2.getServiceProjectTemplates((String)this.serviceIds_.getTypeId(), (String)this.serviceIds_.getRuntimeId());
        int i = 0;
        while (i < templates.length) {
            templateId = templates[i];
            if (templateId.indexOf("web") != -1 && (matches = WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportTemplate((String)this.serviceRuntimeId_, (String)templateId))) {
                return templates[i];
            }
            ++i;
        }
        int j = 0;
        while (j < templates.length) {
            templateId = templates[j];
            matches = WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportTemplate((String)this.serviceRuntimeId_, (String)templateId);
            if (matches) {
                return templates[j];
            }
            ++j;
        }
        if (templates.length > 0) {
            return templates[0];
        }
        return "";
    }

    private String getDefaultServiceProjectName() {
        IProject[] projects = FacetUtils.getAllProjects();
        ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_);
        RequiredFacetVersion[] rfvs = desc.getRequiredFacetVersions();
        int i = 0;
        while (i < projects.length) {
            Set facetVersions = FacetUtils.getFacetsForProject((String)projects[i].getName());
            IRuntime fRuntime = null;
            String fRuntimeName = null;
            fRuntime = FacetUtils.getFacetRuntimeForProject((String)projects[i].getName());
            if (fRuntime != null) {
                fRuntimeName = fRuntime.getName();
            }
            if (facetVersions != null) {
                FacetMatcher fm = FacetMatchCache.getInstance().getMatchForProject(false, this.serviceRuntimeId_, projects[i].getName());
                boolean facetRuntimeMatches = true;
                if (fRuntimeName != null) {
                    facetRuntimeMatches = FacetUtils.isFacetRuntimeSupported((RequiredFacetVersion[])rfvs, (String)fRuntimeName);
                }
                if (fm.isMatch() && facetRuntimeMatches) {
                    this.serviceFacetMatcher_ = fm;
                    return projects[i].getName();
                }
            }
            ++i;
        }
        return ResourceUtils.getDefaultWebProjectName();
    }

    private ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet getDefaultServiceRuntimeForFixedRuntimeAndServer(IProject project) {
        String[] serviceRuntimes = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType((String)this.serviceIds_.getTypeId());
        ArrayList<String> validServiceRuntimes = new ArrayList<String>();
        int i = 0;
        while (i < serviceRuntimes.length) {
            ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)serviceRuntimes[i]);
            if (desc.getRuntime().getId().equals(this.serviceIds_.getRuntimeId()) && WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer((String)desc.getId(), (String)this.serviceIds_.getServerId())) {
                FacetMatcher fm;
                Set facetVersions;
                validServiceRuntimes.add(desc.getId());
                if (project != null && project.exists() && (facetVersions = FacetUtils.getFacetsForProject((String)project.getName())) != null && (fm = FacetMatchCache.getInstance().getMatchForProject(false, serviceRuntimes[i], project.getName())).isMatch()) {
                    ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet drt = new ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet((ClientRuntimeSelectionWidgetDefaultingCommand)this);
                    drt.setFacetMatcher(fm);
                    drt.setProjectName(project.getName());
                    drt.setRuntimeId(desc.getId());
                    return drt;
                }
            }
            ++i;
        }
        if (validServiceRuntimes.size() > 0) {
            ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet drt = new ClientRuntimeSelectionWidgetDefaultingCommand.DefaultRuntimeTriplet((ClientRuntimeSelectionWidgetDefaultingCommand)this);
            drt.setFacetMatcher(null);
            drt.setProjectName(null);
            drt.setRuntimeId(validServiceRuntimes.toArray(new String[0])[0]);
            return drt;
        }
        this.serviceIdsFixed_ = false;
        return this.getDefaultRuntime(project, this.serviceIds_.getTypeId(), false);
    }

    private IProject getUniqueClientEAR(String earProject, String serviceProject, String clientProjectName) {
        String projectName = new String();
        if (!earProject.equalsIgnoreCase(serviceProject)) {
            projectName = earProject;
        } else {
            projectName = String.valueOf(clientProjectName) + this.DEFAULT_CLIENT_EAR_PROJECT_EXT;
            int i = 1;
            while (projectName.equalsIgnoreCase(serviceProject)) {
                projectName = String.valueOf(projectName) + i;
                ++i;
            }
        }
        return projectName.equals("") ? null : ResourceUtils.getWorkspaceRoot().getProject(projectName);
    }

    public void setInitialSelection(IStructuredSelection selection) {
    }

    public void setInitialProject(IProject initialProject) {
        this.initialProject_ = initialProject;
    }

    public void setInitialComponentName(String name) {
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.serviceIds_ = ids;
    }

    public void setServiceIdsFixed(boolean b) {
        this.serviceIdsFixed_ = b;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        return this.serviceIds_;
    }

    public String getServiceRuntimeId() {
        return this.serviceRuntimeId_;
    }

    public boolean getGenerateProxy() {
        return this.generateProxy_;
    }

    public void setGenerateProxy(boolean generateProxy_) {
        this.generateProxy_ = generateProxy_;
    }

    public String getServiceProjectName() {
        return this.serviceProjectName_;
    }

    public String getServiceEarProjectName() {
        return this.serviceEarProjectName_;
    }

    public String getServiceComponentType() {
        return this.serviceComponentType_;
    }

    public boolean getServiceNeedEAR() {
        return this.serviceNeedEAR_;
    }
}

