/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public class KeyrefPropertySource
extends BasePropertySource
implements IPropertySource {
    private String[] refComboValues = new String[]{""};

    public KeyrefPropertySource() {
    }

    public KeyrefPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public KeyrefPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public void setInput(Element element) {
        this.element = element;
        ArrayList<String> items = new ArrayList<String>();
        if (this.xsdSchema != null) {
            Iterator iter = this.xsdSchema.getIdentityConstraintDefinitions().iterator();
            String name = element.getAttribute("name");
            while (iter.hasNext()) {
                XSDIdentityConstraintDefinition constraint = (XSDIdentityConstraintDefinition)iter.next();
                if (name != null && !name.equals("")) {
                    if (constraint.getName() == null || name.equals(constraint.getQName((XSDConcreteComponent)this.xsdSchema))) continue;
                    items.add(constraint.getQName((XSDConcreteComponent)this.xsdSchema));
                    continue;
                }
                if (constraint.getName() == null) continue;
                items.add(constraint.getQName((XSDConcreteComponent)this.xsdSchema));
            }
        }
        int size = items.size() + 1;
        this.refComboValues = new String[size];
        this.refComboValues[0] = "";
        if (items != null) {
            int i = 0;
            while (i < items.size()) {
                this.refComboValues[i + 1] = (String)items.get(i);
                ++i;
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<XSDComboBoxPropertyDescriptor> list = new ArrayList<XSDComboBoxPropertyDescriptor>();
        XSDComboBoxPropertyDescriptor refDescriptor = new XSDComboBoxPropertyDescriptor("refer", "refer", this.refComboValues);
        list.add(refDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            if (result == null) {
                result = "";
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            if (((String)id).equals("name")) {
                if (this.validateName(newValue)) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_KEYREF_NAME_CHANGE"), this.element);
                    this.element.setAttribute("name", newValue);
                    this.endRecording(this.element);
                }
            } else if (((String)id).equals("refer")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_KEYREF_REFER_CHANGE"), this.element);
                this.element.setAttribute((String)id, newValue);
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (KeyrefPropertySource.this.viewer != null) {
                    KeyrefPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }
}

