/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.TargetNamespaceChangeHandler;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDSchemaHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaPropertySource
extends BasePropertySource
implements IPropertySource {
    private String oldPrefix = "";
    private String oldNamespace = "";
    private String[] attributeFormDefaultComboValues = new String[]{"", XSDEditorPlugin.getXSDString("_UI_COMBO_UNQUALIFIED"), XSDEditorPlugin.getXSDString("_UI_COMBO_QUALIFIED")};
    private String[] elementFormDefaultComboValues = new String[]{"", XSDEditorPlugin.getXSDString("_UI_COMBO_UNQUALIFIED"), XSDEditorPlugin.getXSDString("_UI_COMBO_QUALIFIED")};
    private String[] blockDefaultComboValues = new String[]{"", "#all", "extension", "restriction", "substitution"};
    private String[] finalDefaultComboValues = new String[]{"", "#all", "extension", "restriction"};

    public SchemaPropertySource() {
    }

    public SchemaPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public SchemaPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> list = new ArrayList<Object>();
        TextPropertyDescriptor versionDescriptor = new TextPropertyDescriptor((Object)"version", "version");
        list.add(versionDescriptor);
        TextPropertyDescriptor xmlLangDescriptor = new TextPropertyDescriptor((Object)"xml:lang", "xml:lang");
        list.add(xmlLangDescriptor);
        XSDComboBoxPropertyDescriptor attributeFormDefaultDescriptor = new XSDComboBoxPropertyDescriptor("attributeFormDefault", "attributeFormDefault", this.attributeFormDefaultComboValues);
        list.add((Object)attributeFormDefaultDescriptor);
        XSDComboBoxPropertyDescriptor elementFormDefaultDescriptor = new XSDComboBoxPropertyDescriptor("elementFormDefault", "elementFormDefault", this.elementFormDefaultComboValues);
        list.add((Object)elementFormDefaultDescriptor);
        XSDComboBoxPropertyDescriptor blockDefaultDescriptor = new XSDComboBoxPropertyDescriptor("blockDefault", "blockDefault", this.blockDefaultComboValues);
        list.add((Object)blockDefaultDescriptor);
        XSDComboBoxPropertyDescriptor finalDefaultDescriptor = new XSDComboBoxPropertyDescriptor("finalDefault", "finalDefault", this.finalDefaultComboValues);
        list.add((Object)finalDefaultDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            String attributeName = (String)id;
            if (result == null) {
                result = "";
            }
            if (attributeName.equals("prefix")) {
                TypesHelper helper = new TypesHelper(this.xsdSchema);
                String aPrefix = helper.getPrefix(this.element.getAttribute("targetNamespace"), false);
                if (aPrefix != null && aPrefix.length() > 0) {
                    return aPrefix;
                }
                return "";
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            String attributeName = (String)id;
            if (attributeName.equals("prefix")) {
                this.updatePrefix(newValue);
            } else if (attributeName.equals("targetNamespace")) {
                this.updateTargetNamespace(newValue);
            } else if (attributeName.equals("xml:lang")) {
                this.validateLanguage(newValue);
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SCHEMA_LANG_CHANGE"), this.element);
            } else if (attributeName.equals("version")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SCHEMA_VERSION_CHANGE"), this.element);
            } else if (attributeName.equals("attributeFormDefault")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SCHEMA_ATTRIBUTEFORMDEFAULT_CHANGE"), this.element);
            } else if (attributeName.equals("elementFormDefault")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SCHEMA_ELEMENTFORMDEFAULT_CHANGE"), this.element);
            } else if (attributeName.equals("blockDefault")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SCHEMA_BLOCKDEFAULT_CHANGE"), this.element);
            } else if (attributeName.equals("finalDefault")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SCHEMA_FINALDEFAULT_CHANGE"), this.element);
            }
            if (!attributeName.equals("prefix") && !attributeName.equals("targetNamespace")) {
                if (newValue.equals("")) {
                    this.element.removeAttribute(attributeName);
                } else {
                    this.element.setAttribute(attributeName, newValue);
                }
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (SchemaPropertySource.this.viewer != null) {
                    SchemaPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    public void setInput(Element element) {
        super.setInput(element);
        this.oldNamespace = "";
        this.oldPrefix = "";
        if (element != null) {
            String targetNamespace;
            this.oldNamespace = targetNamespace = element.getAttribute("targetNamespace");
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            String aPrefix = helper.getPrefix(targetNamespace, false);
            if (aPrefix != null && aPrefix.length() > 0) {
                this.oldPrefix = aPrefix;
            }
        }
    }

    private void updatePrefix(String newPrefix) {
        this.updateNamespaceInfo(newPrefix, this.oldNamespace);
    }

    private void updateTargetNamespace(String newTargetNamespace) {
        this.updateNamespaceInfo(this.oldPrefix, newTargetNamespace);
    }

    private void updateNamespaceInfo(String newPrefix, String newTargetNamespace) {
        DocumentImpl doc = (DocumentImpl)this.element.getOwnerDocument();
        String modelTargetNamespace = this.xsdSchema.getTargetNamespace();
        if (modelTargetNamespace == null) {
            modelTargetNamespace = "";
        }
        String targetNamespace = newTargetNamespace.trim();
        String prefix = newPrefix.trim();
        if (!this.validatePrefix(prefix) || !this.validateTargetNamespace(targetNamespace)) {
            return;
        }
        if (prefix.length() > 0 && targetNamespace.length() == 0) {
            return;
        }
        doc.getModel().beginRecording((Object)this, XSDEditorPlugin.getXSDString("_UI_LABEL_TARGETNAMESPACE_CHANGE"));
        String xsdForXSDPrefix = this.xsdSchema.getSchemaForSchemaQNamePrefix();
        Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
        if (prefix.length() == 0 && (xsdForXSDPrefix == null || xsdForXSDPrefix != null && xsdForXSDPrefix.trim().length() == 0)) {
            xsdForXSDPrefix = XSDEditorPlugin.getPlugin().getXMLSchemaPrefix();
            xsdForXSDPrefix = this.getUniqueSchemaForSchemaPrefix(xsdForXSDPrefix, map);
            this.element.setAttribute("xmlns:" + xsdForXSDPrefix, "http://www.w3.org/2001/XMLSchema");
            this.updateAllNodes(this.element, xsdForXSDPrefix);
            if (this.element.getAttribute("xmlns") != null && this.element.getAttribute("xmlns").equals("http://www.w3.org/2001/XMLSchema")) {
                this.element.removeAttribute("xmlns");
            }
        }
        if (targetNamespace.length() > 0 || targetNamespace.length() == 0 && prefix.length() == 0) {
            if (this.oldPrefix != null && this.oldPrefix.length() > 0) {
                this.element.removeAttribute("xmlns:" + this.oldPrefix);
            } else if (this.element.getAttribute("xmlns") != null && !this.element.getAttribute("xmlns").equals("http://www.w3.org/2001/XMLSchema")) {
                this.element.removeAttribute("xmlns");
            }
        }
        if (targetNamespace.length() > 0) {
            if (!modelTargetNamespace.equals(targetNamespace)) {
                this.element.setAttribute("targetNamespace", targetNamespace);
            }
            if (prefix.length() > 0) {
                this.element.setAttribute("xmlns:" + prefix, targetNamespace);
            } else {
                this.element.setAttribute("xmlns", targetNamespace);
            }
        } else if (prefix.length() == 0) {
            this.element.removeAttribute("targetNamespace");
        }
        TargetNamespaceChangeHandler targetNamespaceChangeHandler = new TargetNamespaceChangeHandler(this.xsdSchema, this.oldNamespace, targetNamespace);
        targetNamespaceChangeHandler.resolve();
        this.oldPrefix = prefix;
        this.oldNamespace = targetNamespace;
        XSDSchemaHelper.updateElement((XSDConcreteComponent)this.xsdSchema);
        doc.getModel().endRecording((Object)this);
        map = this.xsdSchema.getQNamePrefixToNamespaceMap();
    }

    private String getUniqueSchemaForSchemaPrefix(String xsdForXSDPrefix, Map map) {
        if (xsdForXSDPrefix == null || xsdForXSDPrefix != null && xsdForXSDPrefix.trim().length() == 0) {
            xsdForXSDPrefix = "xsd";
        }
        int prefixExtension = 1;
        while (map.containsKey(xsdForXSDPrefix) && prefixExtension < 100) {
            xsdForXSDPrefix = String.valueOf(xsdForXSDPrefix) + String.valueOf(prefixExtension);
            ++prefixExtension;
        }
        return xsdForXSDPrefix;
    }

    private void updateAllNodes(Element element, String prefix) {
        element.setPrefix(prefix);
        NodeList list = element.getChildNodes();
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child != null && child instanceof Element) {
                    child.setPrefix(prefix);
                    if (child.hasChildNodes()) {
                        this.updateAllNodes((Element)child, prefix);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean validateTargetNamespace(String ns) {
        if (ns.equals("")) {
            return true;
        }
        String errorMessage = null;
        try {
            URI testURI = new URI(ns);
            testURI.isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            errorMessage = XSDEditorPlugin.getXSDString("_WARN_INVALID_TARGET_NAMESPACE");
        }
        return errorMessage == null || errorMessage.length() == 0;
    }
}

