/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.CommonDirectivesSection;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDSelectIncludeFileWizard;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDIncludeImpl;
import org.eclipse.xsd.impl.XSDRedefineImpl;
import org.w3c.dom.Element;

public class SchemaLocationSection
extends CommonDirectivesSection {
    IWorkbenchPart part;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        int leftCoordinate = this.getStandardLabelWidth(composite, new String[]{XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_LOCATION")});
        CLabel schemaLocationLabel = this.getWidgetFactory().createCLabel(composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_LOCATION"));
        this.schemaLocationText = this.getWidgetFactory().createText(composite, "", 0);
        this.wizardButton = this.getWidgetFactory().createButton(composite, "", 0);
        this.wizardButton.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        FormData buttonFormData = new FormData();
        buttonFormData.left = new FormAttachment(100, -this.rightMarginSpace + 2);
        buttonFormData.right = new FormAttachment(100, 0);
        buttonFormData.top = new FormAttachment((Control)this.schemaLocationText, 0, 0x1000000);
        this.wizardButton.setLayoutData((Object)buttonFormData);
        this.wizardButton.addSelectionListener((SelectionListener)this);
        this.schemaLocationText.setEditable(true);
        FormData schemaLocationData = new FormData();
        schemaLocationData.left = new FormAttachment(0, leftCoordinate);
        schemaLocationData.right = new FormAttachment((Control)this.wizardButton, 0);
        this.schemaLocationText.setLayoutData((Object)schemaLocationData);
        this.schemaLocationText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.schemaLocationText, -5);
        data.top = new FormAttachment((Control)this.schemaLocationText, 0, 0x1000000);
        schemaLocationLabel.setLayoutData((Object)data);
        this.errorText = new StyledText(composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new FormData();
        data.left = new FormAttachment((Control)this.schemaLocationText, 0, 16384);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.schemaLocationText, 0);
        this.errorText.setLayoutData((Object)data);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.wizardButton) {
            Shell shell = Display.getCurrent().getActiveShell();
            IFile currentIFile = ((IFileEditorInput)this.getActiveEditor().getEditorInput()).getFile();
            ResourceFilter filter = new ResourceFilter(new String[]{".xsd"}, new IFile[]{currentIFile}, null);
            XSDSelectIncludeFileWizard fileSelectWizard = new XSDSelectIncludeFileWizard(this.xsdSchema, true, XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_SCHEMA"), XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_DESC"), (ViewerFilter)filter, (IStructuredSelection)this.selection);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fileSelectWizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            int result = wizardDialog.open();
            String value = this.schemaLocationText.getText();
            if (result == 0) {
                this.errorText.setText("");
                IFile selectedIFile = fileSelectWizard.getResultFile();
                String schemaFileString = value;
                schemaFileString = selectedIFile != null ? URIHelper.getRelativeURI((IPath)selectedIFile.getLocation(), (IPath)currentIFile.getLocation()) : fileSelectWizard.getURL();
                this.handleSchemaLocationChange(schemaFileString, fileSelectWizard.getNamespace(), null);
                this.refresh();
            }
        }
    }

    public void refresh() {
        if (this.doRefresh) {
            this.setListenerEnabled(false);
            Element element = null;
            if (this.input instanceof XSDInclude) {
                element = ((XSDIncludeImpl)this.input).getElement();
            } else if (this.input instanceof XSDRedefine) {
                element = ((XSDRedefineImpl)this.input).getElement();
            }
            if (element != null) {
                String location = "";
                location = element.getAttribute("schemaLocation");
                if (location == null) {
                    location = "";
                }
                this.schemaLocationText.setText(location);
            }
            this.setListenerEnabled(true);
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected void handleSchemaLocationChange(String schemaFileString, String namespace, XSDSchema externalSchema) {
        if (this.input instanceof XSDInclude) {
            Element element = ((XSDIncludeImpl)this.input).getElement();
            element.setAttribute("schemaLocation", schemaFileString);
        } else if (this.input instanceof XSDRedefine) {
            Element element = ((XSDRedefineImpl)this.input).getElement();
            element.setAttribute("schemaLocation", schemaFileString);
        }
    }
}

