/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;

public class XSDNewFilePage
extends WizardNewFileCreationPage {
    public String defaultName = "NewXMLSchema";
    public String defaultFileExtension = ".xsd";
    public String[] filterExtensions = new String[]{"*.xsd"};

    public XSDNewFilePage(IStructuredSelection selection) {
        super(XSDEditorPlugin.getXSDString("_UI_CREATEXSD"), selection);
        this.setTitle(XSDEditorPlugin.getXSDString("_UI_NEW_XML_SCHEMA_TITLE"));
        this.setDescription(XSDEditorPlugin.getXSDString("_UI_CREATE_A_NEW_XML_SCHEMA_DESC"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(this.computeDefaultFileName());
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        Path newName = new Path(this.getFileName());
        String fullFileName = this.getFileName();
        String extension = newName.getFileExtension();
        if (extension == null || !extension.equalsIgnoreCase("xsd")) {
            this.setErrorMessage(XSDEditorPlugin.getXSDString("_ERROR_FILENAME_MUST_END_XSD"));
            return false;
        }
        this.setErrorMessage(null);
        String sameName = this.existsFileAnyCase(fullFileName);
        if (sameName != null) {
            this.setErrorMessage(XSDEditorPlugin.getPlugin().getString("_ERROR_FILE_ALREADY_EXISTS", sameName));
            return false;
        }
        return super.validatePage();
    }

    protected String computeDefaultFileName() {
        int count = 0;
        String fileName = String.valueOf(this.defaultName) + this.defaultFileExtension;
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath != null) {
            while (true) {
                IPath path = containerFullPath.append(fileName);
                if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) break;
                fileName = String.valueOf(this.defaultName) + ++count + this.defaultFileExtension;
            }
        }
        return fileName;
    }

    protected String existsFileAnyCase(String fileName) {
        IResource parent;
        if (this.getContainerFullPath() != null && !this.getContainerFullPath().isEmpty() && fileName.compareTo("") != 0 && (parent = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath())) instanceof IContainer) {
            IContainer container = (IContainer)parent;
            try {
                IResource[] members = container.members();
                String enteredFileUpper = fileName.toUpperCase();
                int i = 0;
                while (i < members.length) {
                    String resourceUpperName = members[i].getName().toUpperCase();
                    if (resourceUpperName.equals(enteredFileUpper)) {
                        return members[i].getName();
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }
}

