/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.earcreation.IDefaultJ2EEComponentCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.activities.WTPActivityBridge;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class DefaultJ2EEComponentCreationOperation
extends AbstractDataModelOperation
implements IDefaultJ2EEComponentCreationDataModelProperties {
    public static final String JCA_DEV_ACTIVITY_ID = "com.ibm.wtp.jca.development";
    public static final String WEB_DEV_ACTIVITY_ID = "com.ibm.wtp.web.development";
    public static final String ENTERPRISE_JAVA = "com.ibm.wtp.ejb.development";

    public DefaultJ2EEComponentCreationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            IDataModel projectModel;
            if (this.model.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_EJB")) {
                projectModel = this.model.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_EJB");
                this.createEJBComponent(projectModel, monitor);
            }
            if (this.model.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_WEB")) {
                projectModel = this.model.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_WEB");
                this.createWebJ2EEComponent(projectModel, monitor);
            }
            if (this.model.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CONNECTOR")) {
                projectModel = this.model.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_JCA");
                this.createRarJ2EEComponent(projectModel, monitor);
            }
            if (this.model.getBooleanProperty("DefaultJ2EEComponentCreationDataModel.CREATE_CLIENT")) {
                projectModel = this.model.getNestedModel("DefaultJ2EEComponentCreationDataModel.NESTED_MODEL_CLIENT");
                this.createAppClientComponent(projectModel, monitor);
            }
        }
        catch (Exception e) {
            Logger.getLogger().log((Object)e.getMessage());
        }
        return OK_STATUS;
    }

    private void createEJBComponent(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException, ExecutionException {
        model.getDefaultOperation().execute(monitor, null);
        this.addDefaultFacets(model);
        WTPActivityBridge.getInstance().enableActivity(ENTERPRISE_JAVA, true);
    }

    private void createWebJ2EEComponent(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException, ExecutionException {
        model.getDefaultOperation().execute(monitor, null);
        this.addDefaultFacets(model);
        WTPActivityBridge.getInstance().enableActivity(WEB_DEV_ACTIVITY_ID, true);
    }

    private void addDefaultFacets(IDataModel model) throws CoreException {
        IRuntime runtime = (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        String projectName = model.getStringProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME");
        IProject project = ProjectUtilities.getProject((String)projectName);
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {}
        if (facetedProject != null && runtime != null) {
            try {
                FacetProjectCreationOperation.addDefaultFactets((IFacetedProject)facetedProject, (IRuntime)runtime);
            }
            catch (ExecutionException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    private void createRarJ2EEComponent(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException, ExecutionException {
        model.getDefaultOperation().execute(monitor, null);
        this.addDefaultFacets(model);
        WTPActivityBridge.getInstance().enableActivity(ENTERPRISE_JAVA, true);
    }

    private void createAppClientComponent(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException, ExecutionException {
        model.getDefaultOperation().execute(monitor, null);
        this.addDefaultFacets(model);
        WTPActivityBridge.getInstance().enableActivity(ENTERPRISE_JAVA, true);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

