/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.r21.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolder;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolderEvent;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabItem;
import org.eclipse.ui.internal.presentations.r21.widgets.R21PaneFolderButtonListener;
import org.eclipse.ui.internal.presentations.r21.widgets.ViewForm;
import org.eclipse.ui.internal.presentations.util.ProxyControl;

public final class R21PaneFolder {
    private CTabFolder tabFolder;
    private ViewForm viewForm;
    private ProxyControl contentProxy;
    private ProxyControl viewFormTopLeftProxy;
    private ProxyControl viewFormTopRightProxy;
    private ProxyControl viewFormTopCenterProxy;
    private SizeCache topRightCache = new SizeCache();
    private SizeCache topCenterCache = new SizeCache();
    private SizeCache topLeftCache = new SizeCache();
    private int tabPosition;
    private boolean putTrimOnTop = false;
    private List buttonListeners = new ArrayList(1);
    private int state = 2;
    private int mousedownState = -1;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            R21PaneFolder.this.mousedownState = R21PaneFolder.this.getState();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };

    public R21PaneFolder(Composite parent, int flags) {
        this.tabFolder = new CTabFolder(parent, flags);
        this.tabFolder.addMouseListener(this.mouseListener);
        this.viewForm = new ViewForm(this.tabFolder, 0);
        this.viewFormTopLeftProxy = new ProxyControl((Composite)this.viewForm);
        this.viewFormTopCenterProxy = new ProxyControl((Composite)this.viewForm);
        this.viewFormTopRightProxy = new ProxyControl((Composite)this.viewForm);
        this.contentProxy = new ProxyControl((Composite)this.viewForm);
        this.viewForm.setContent(this.contentProxy.getControl());
    }

    public Composite getControl() {
        return this.tabFolder;
    }

    public void setTopCenter(Control topCenter) {
        this.topCenterCache.setControl(topCenter);
        if (topCenter != null) {
            if (!this.putTrimOnTop) {
                this.viewFormTopCenterProxy.setTarget(this.topCenterCache);
                this.viewForm.setTopCenter(this.viewFormTopCenterProxy.getControl());
            }
        } else if (!this.putTrimOnTop) {
            this.viewForm.setTopCenter(null);
        }
    }

    public void setTopRight(Control topRight) {
        this.topRightCache.setControl(topRight);
        if (topRight != null) {
            if (!this.putTrimOnTop) {
                this.viewFormTopRightProxy.setTarget(this.topRightCache);
                this.viewForm.setTopRight(this.viewFormTopRightProxy.getControl());
            }
        } else if (!this.putTrimOnTop) {
            this.viewForm.setTopRight(null);
        }
    }

    public void setTopLeft(Control topLeft) {
        if (this.topLeftCache.getControl() != topLeft) {
            this.topLeftCache.setControl(topLeft);
            if (topLeft != null) {
                this.viewFormTopLeftProxy.setTarget(this.topLeftCache);
                this.viewForm.setTopLeft(this.viewFormTopLeftProxy.getControl());
            } else {
                this.viewFormTopLeftProxy.setTargetControl(null);
                this.viewForm.setTopLeft(null);
            }
        }
    }

    public void flush() {
        this.topLeftCache.flush();
        this.topRightCache.flush();
        this.topCenterCache.flush();
    }

    public void layout(boolean flushCache) {
        if (flushCache) {
            this.flush();
        }
        Rectangle tabFolderClientArea = this.tabFolder.getClientArea();
        if (this.tabFolder.getItemCount() < 2) {
            int delta = this.getTabHeight() + 1;
            tabFolderClientArea.height += delta;
            if (this.getTabPosition() == 128) {
                tabFolderClientArea.y -= delta;
            }
        }
        this.viewForm.setBounds(tabFolderClientArea);
        this.viewFormTopRightProxy.layout();
        this.viewFormTopLeftProxy.layout();
        this.viewFormTopCenterProxy.layout();
    }

    public Rectangle getClientArea() {
        Rectangle bounds = this.contentProxy.getControl().getBounds();
        Rectangle formArea = this.viewForm.getBounds();
        bounds.x += formArea.x;
        bounds.y += formArea.y;
        return bounds;
    }

    public int getState() {
        return this.state;
    }

    protected void notifyButtonListeners(int buttonId) {
        if (this.mousedownState == this.getState()) {
            Iterator iter = this.buttonListeners.iterator();
            while (iter.hasNext()) {
                R21PaneFolderButtonListener listener = (R21PaneFolderButtonListener)iter.next();
                listener.stateButtonPressed(buttonId);
            }
        }
    }

    protected void notifyShowListeners(CTabFolderEvent event) {
        Iterator iter = this.buttonListeners.iterator();
        while (iter.hasNext()) {
            R21PaneFolderButtonListener listener = (R21PaneFolderButtonListener)iter.next();
            listener.showList(event);
        }
    }

    protected void notifyCloseListeners(CTabItem tabItem) {
        Iterator iter = this.buttonListeners.iterator();
        while (iter.hasNext()) {
            R21PaneFolderButtonListener listener = (R21PaneFolderButtonListener)iter.next();
            listener.closeButtonPressed(tabItem);
        }
    }

    public void addButtonListener(R21PaneFolderButtonListener listener) {
        this.buttonListeners.add(listener);
    }

    public void removeButtonListener(R21PaneFolderButtonListener listener) {
        this.buttonListeners.remove(listener);
    }

    public void setTabPosition(int newTabPosition) {
        this.tabPosition = newTabPosition;
        this.tabFolder.setTabPosition(this.tabPosition);
    }

    public int getTabPosition() {
        return this.tabPosition;
    }

    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed();
    }

    public CTabItem createItem(int style, int index) {
        return new CTabItem(this.tabFolder, style, index);
    }

    public void setSelection(int selection) {
        this.tabFolder.setSelection(selection);
    }

    public Rectangle computeTrim(int i, int j, int k, int l) {
        return this.tabFolder.computeTrim(i, j, k, l);
    }

    public void setSelectionForeground(Color fgColor) {
        this.tabFolder.setSelectionForeground(fgColor);
    }

    public void setSelectionBackground(Color[] bgColors, int[] percentages, boolean vertical) {
        this.tabFolder.setSelectionBackground(bgColors, percentages);
    }

    public CTabItem getItem(int idx) {
        return this.tabFolder.getItem(idx);
    }

    public int getSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    public int getTabHeight() {
        return this.tabFolder.getTabHeight();
    }

    public int indexOf(CTabItem toFind) {
        return this.tabFolder.indexOf(toFind);
    }

    public void setTabHeight(int height) {
        this.tabFolder.setTabHeight(height);
    }

    public int getItemCount() {
        return this.tabFolder.getItemCount();
    }

    public CTabItem[] getItems() {
        return this.tabFolder.getItems();
    }

    public CTabItem getItem(Point toGet) {
        return this.tabFolder.getItem(toGet);
    }

    public CTabItem getSelection() {
        return this.tabFolder.getSelection();
    }
}

