/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.plugin;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorRegistry;

/**
 * Label decorator used to display Navigator debug information. The label will indicate which
 * extension provides content for a particular Navigator element.
 */
public class DebugLabelDecorator implements ILightweightLabelDecorator {
	/**
	 *  
	 */
	public DebugLabelDecorator() {
		//Default constructor
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelDecorator#addListener
	 */
	public void addListener(ILabelProviderListener listener) {
		//do nothing
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelDecorator#dispose
	 */
	public void dispose() {
		//dispose
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelDecorator#isLabelProperty
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelDecorator#removeListener
	 */
	public void removeListener(ILabelProviderListener listener) {
		//do nothing
	}

	/**
	 * Decorate project elements with the name of the navigator extension that provides the project
	 * contents.
	 */
	public void decorate(Object element, IDecoration decoration) {
		NavigatorRegistry registry = NavigatorPlugin.getDefault().getNavigatorRegistry();
		NavigatorContentDescriptor extDescriptor = registry.getBestContentDescriptor(element);
		if (extDescriptor != null) {
			String contentName = extDescriptor.getName();
			decoration.addSuffix(" <" + contentName + ">"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}
}
