/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.ui.workingsets.providers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WorkingSetAwareLabelProvider implements ILabelProvider {

	private Map fImages = new HashMap();
	private ILabelProvider delegateLabelProvider = new WorkbenchLabelProvider();
	
	public WorkingSetAwareLabelProvider() {

	}

	/**
	 * {@inheritDoc}
	 */
	public String getText(Object element) {
		if (element instanceof IWorkingSet) {
			return ((IWorkingSet) element).getName();
		}
		return delegateLabelProvider.getText(element);
	}

	/**
	 * {@inheritDoc}
	 */
	public Image getImage(Object element) {
		if (element instanceof IWorkingSet) {
			ImageDescriptor image = ((IWorkingSet) element).getImage();
			if (image == null) return null;
			Image result = (Image) fImages.get(image);
			if (result == null) {
				result = image.createImage();
				fImages.put(image, result);
			}
			return result;
		}
		return delegateLabelProvider.getImage(element);
	}

	/**
	 * {@inheritDoc}
	 */
	public void dispose() {
		for (Iterator iter = fImages.values().iterator(); iter.hasNext();) {
			((Image) iter.next()).dispose();
		}

	}

	public void addListener(ILabelProviderListener listener) {
	
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {

		
	}
}
