/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/**
 * <p>
 * Provides a compatibility layer between the
 * {@see org.eclipse.jdt.ui.StandardJavaElementContentProvider}and the Common Navigator, which uses
 * only {@see org.eclipse.core.resources.IProject}to render Eclipse projects.
 * </p>
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class JavaExtensionContentProvider extends PackageExplorerContentProvider {

	/**
	 *  
	 */
	public JavaExtensionContentProvider() {
		super();
		setIsFlatLayout(true);
	}

	/**
	 * @param provideMembers
	 */
	public JavaExtensionContentProvider(boolean provideMembers) {
		super(provideMembers);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jdt.ui.StandardJavaElementContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object element) {
		if (element instanceof IProject)
			element = JavaCore.create((IProject) element);
		else if (element instanceof IResource)
			return NO_CHILDREN;
		return super.getChildren(element);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jdt.ui.StandardJavaElementContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		Object parent = super.getParent(element);
		if (parent instanceof IJavaProject)
			return ((IJavaProject) parent).getProject();
		return parent;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jdt.ui.StandardJavaElementContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		if (element instanceof IProject)
			element = JavaCore.create((IProject) element);
		return super.hasChildren(element);
	}

}
