/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Aug 30, 2004
 * 
 * TODO To change the template for this generated file go to Window - Preferences - Java - Code
 * Style - Code Templates
 */
package org.eclipse.jst.common.navigator.internal.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jst.common.navigator.internal.plugin.NavigatorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;


public class JavaResources {
	private static Map projectsMap;
	public final IProject parent;
	private static Image icon = null;

	private JavaResources(IProject parent) {
		this.parent = parent;
	}

	public static JavaResources getJavaResources(IProject project) {
		JavaResources javaResources = (JavaResources) getProjectsMap().get(project);
		if (javaResources == null) {
			getProjectsMap().put(project, (javaResources = new JavaResources(project)));
		}
		return javaResources;
	}

	private static Map getProjectsMap() {
		if (projectsMap == null)
			projectsMap = new HashMap();
		return projectsMap;
	}

	/**
	 * @return
	 */
	public String getText() {
		return "Java Resources"; //$NON-NLS-1$
	}

	/**
	 * @return
	 */
	public Image getImage() {
		if (icon == null)
			icon = JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT.createImage();
		return icon;
	}

	/**
	 * @param project
	 * @return
	 */
	public static boolean isCompressed(IProject project) {
		return CompressedProjectsRegistryReader.getInstance().isCompressed(project);
	}

	private static class CompressedProjectsRegistryReader extends RegistryReader {

		public static final String COMPRESSED_PROJECT = "compressedProject"; //$NON-NLS-1$
		public static final String ATT_NATURE_ID = "natureId"; //$NON-NLS-1$

		private List compressedNatures;
		private static CompressedProjectsRegistryReader INSTANCE = null;

		public CompressedProjectsRegistryReader() {
			super(NavigatorPlugin.PLUGIN_ID, COMPRESSED_PROJECT);
		}

		/**
		 * @return
		 */
		public static CompressedProjectsRegistryReader getInstance() {
			if (INSTANCE == null) {
				INSTANCE = new CompressedProjectsRegistryReader();
				INSTANCE.readRegistry();
			}
			return INSTANCE;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.wst.common.frameworks.internal.RegistryReader#readElement(org.eclipse.core.runtime.IConfigurationElement)
		 */
		public boolean readElement(IConfigurationElement element) {
			if (COMPRESSED_PROJECT.equals(element.getName()))
				getCompressedNatures().add(element.getAttribute(ATT_NATURE_ID));
			return true;
		}

		/**
		 * @return
		 */
		private List getCompressedNatures() {
			if (compressedNatures == null)
				compressedNatures = new ArrayList();
			return compressedNatures;
		}

		public boolean isCompressed(IProject project) {
			if (compressedNatures == null)
				return false;

			try {
				for (int i = 0; i < compressedNatures.size(); i++)
					if (project.hasNature((String) compressedNatures.get(i)))
						return true;
			} catch (CoreException e) {
				//do nothing
			}
			return false;
		}

	}
}
