/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.plugin;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.CommonWorkingSetAdapterFactory;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.CommonWorkingSetManager;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class NavigatorPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static NavigatorPlugin plugin;
	
//	 Manager for working sets (IWorkingSet)
    private CommonWorkingSetManager commonWorkingSetManager;

    
    // The context within which this plugin was started.
    private BundleContext bundleContext;

	public static final String PLUGIN_ID = "org.eclipse.jst.common.navigator.java"; //$NON-NLS-1$

	/**
	 * The constructor.
	 */
	public NavigatorPlugin() {
		super();
		plugin = this;
	}

	/**
	 * Returns the shared instance.
	 */
	public static NavigatorPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}
	
	 /**
     * Returns the working set manager
     * 
     * @return the working set manager
     * @plannedfor 2.0
     */
    public synchronized IWorkingSetManager getWorkingSetManager() {
        if (commonWorkingSetManager == null) {
			commonWorkingSetManager = new CommonWorkingSetManager(bundleContext);
			//commonWorkingSetManager.restoreState();
        }
        return commonWorkingSetManager;
    }
	
	public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
		
		IAdapterManager manager = Platform.getAdapterManager();
		manager.registerAdapters(new CommonWorkingSetAdapterFactory(), IWorkingSet.class);

	}
	
	 public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (commonWorkingSetManager != null) {
			commonWorkingSetManager.dispose();
			commonWorkingSetManager= null;
        }
	 }
       

}
