/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class OthersWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.jst.common.navigator.ui.OthersWorkingSet";
    private IWorkingSet fWorkingSet;
    private WorkingSetModel fWorkingSetModel;
    private boolean disposed = false;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fWorkingSetListener;
    static /* synthetic */ Class class$0;

    public void add(IWorkingSet workingSet) {
        if (this.isDisposed()) {
            return;
        }
        Assert.isTrue((this.fWorkingSet == null ? 1 : 0) != 0);
        this.fWorkingSet = workingSet;
    }

    public boolean remove(IWorkingSet workingSet) {
        if (this.isDisposed()) {
            return false;
        }
        Assert.isTrue((this.fWorkingSet == workingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet workingSet) {
        if (this.isDisposed()) {
            return false;
        }
        return this.fWorkingSet == workingSet;
    }

    public void init(WorkingSetModel model) {
        if (this.isDisposed()) {
            return;
        }
        this.fWorkingSetModel = model;
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fWorkingSetListener = new WorkingSetListener();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetListener);
        this.fWorkingSetModel.addPropertyChangeListener(this.fWorkingSetListener);
        this.updateElements(this.fWorkingSetModel.getActiveWorkingSets());
    }

    public void dispose() {
        this.disposed = true;
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
    }

    public void updateElements() {
        if (this.isDisposed()) {
            return;
        }
        if (this.fWorkingSetModel == null) {
            return;
        }
        this.updateElements(this.fWorkingSetModel.getActiveWorkingSets());
    }

    private List getResultantElements(IWorkingSet[] activeWorkingSets) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        HashSet<IResource> existingProjects = new HashSet<IResource>();
        int i = 0;
        while (i < activeWorkingSets.length) {
            if (activeWorkingSets[i] != this.fWorkingSet) {
                IAdaptable[] elements = activeWorkingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IResource resource;
                    IAdaptable element = elements[j];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)element.getAdapter((Class)clazz)) != null && resource.getType() == 4) {
                        existingProjects.add(resource);
                    }
                    ++j;
                }
            }
            ++i;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            if (!existingProjects.contains(projects[i2])) {
                result.add(projects[i2]);
            }
            ++i2;
        }
        return result;
    }

    private void updateElements(IWorkingSet[] activeWorkingSets) {
        List result = this.getResultantElements(activeWorkingSets);
        this.fWorkingSet.setElements(result.toArray(new IAdaptable[result.size()]));
    }

    private boolean isDisposed() {
        return this.disposed;
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (OthersWorkingSetUpdater.this.isDisposed()) {
                return;
            }
            if (OthersWorkingSetUpdater.this.fWorkingSetModel == null) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(3, 4);
            if (affectedChildren.length > 0) {
                OthersWorkingSetUpdater.this.updateElements(OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets());
            } else {
                affectedChildren = delta.getAffectedChildren(4, 4);
                int i = 0;
                while (i < affectedChildren.length) {
                    IResourceDelta projectDelta = affectedChildren[i];
                    if ((projectDelta.getFlags() & 0x80000) != 0) {
                        OthersWorkingSetUpdater.this.updateElements(OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets());
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private class WorkingSetListener
    implements IPropertyChangeListener {
        private WorkingSetListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet[] activeWorkingSets;
            IWorkingSet changedWorkingSet;
            if (OthersWorkingSetUpdater.this.isDisposed()) {
                return;
            }
            if (OthersWorkingSetUpdater.this.fWorkingSetModel == null) {
                return;
            }
            if ("workingSetContentChange".equals(event.getProperty()) && (changedWorkingSet = (IWorkingSet)event.getNewValue()) != OthersWorkingSetUpdater.this.fWorkingSet && this.contains(activeWorkingSets = OthersWorkingSetUpdater.this.fWorkingSetModel.getActiveWorkingSets(), changedWorkingSet) && !"org.eclipse.jst.common.navigator.ui.HistoryWorkingSet".equals(changedWorkingSet.getId())) {
                OthersWorkingSetUpdater.this.updateElements(activeWorkingSets);
            }
        }

        private boolean contains(IWorkingSet[] workingSets, IWorkingSet workingSet) {
            int i = 0;
            while (i < workingSets.length) {
                if (workingSets[i] == workingSet) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

