/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.model.internal.validation.AValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.DuplicatesTable;
import org.eclipse.jst.j2ee.model.internal.validation.EJBJar11VRule;
import org.eclipse.jst.j2ee.model.internal.validation.EJBValidationRuleFactory;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb11Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.MessageLimitException;

public class EJBJar11VRule
extends AValidationRule
implements IMessagePrefixEjb11Constants {
    private DuplicatesTable _ejbName = new DuplicatesTable();
    private static final Object ID = IValidationRuleList.EJB11_EJBJAR;
    private static final Object[] DEPENDS_ON = new Object[]{IValidationRuleList.EJB11_SESSION_BEANCLASS, IValidationRuleList.EJB11_SESSION_REMOTE, IValidationRuleList.EJB11_SESSION_HOME, IValidationRuleList.EJB11_CMP_BEANCLASS, IValidationRuleList.EJB11_CMP_REMOTE, IValidationRuleList.EJB11_CMP_HOME, IValidationRuleList.EJB11_CMP_KEYCLASS, IValidationRuleList.EJB11_BMP_BEANCLASS, IValidationRuleList.EJB11_BMP_REMOTE, IValidationRuleList.EJB11_BMP_HOME, IValidationRuleList.EJB11_BMP_KEYCLASS, IValidationRuleList.EJB11_EJBEXT};
    private static final Map MESSAGE_IDS = new HashMap();

    static {
        MESSAGE_IDS.put("CHKJ2814", new String[]{"CHKJ2814.ejb11"});
        MESSAGE_IDS.put("CHKJ2825", new String[]{"CHKJ2825.ejb11"});
        MESSAGE_IDS.put("CHKJ2826", new String[]{"CHKJ2826.ejb11"});
        MESSAGE_IDS.put("CHKJ2842", new String[]{"CHKJ2842.ejb11"});
        MESSAGE_IDS.put("CHKJ2843", new String[]{"CHKJ2843.ejb11"});
        MESSAGE_IDS.put("CHKJ2844", new String[]{"CHKJ2844.ejb11"});
        MESSAGE_IDS.put("CHKJ2845", new String[]{"CHKJ2845.ejb11"});
        MESSAGE_IDS.put("CHKJ2846", new String[]{"CHKJ2846.ejb11"});
        MESSAGE_IDS.put("CHKJ2847", new String[]{"CHKJ2847.ejb11"});
        MESSAGE_IDS.put("CHKJ2850", new String[]{"CHKJ2850.ejb11"});
        MESSAGE_IDS.put("CHKJ2852", new String[]{"CHKJ2852"});
        MESSAGE_IDS.put("CHKJ2875", new String[]{"CHKJ2875.ejb11"});
        MESSAGE_IDS.put("CHKJ2895", new String[]{"CHKJ2895.ejb11"});
    }

    public final Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public final Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public final Object getId() {
        return ID;
    }

    public Object getTarget(Object parent, Object target) {
        return null;
    }

    protected void validateAssemblyDescriptorElement(IEJBValidationContext vc, EJBJar ejbJar) {
        vc.terminateIfCancelled();
        if (ejbJar == null) {
            return;
        }
        AssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        EList roles = assemblyDescriptor.getSecurityRoles();
        if (roles != null) {
            class RoleWrapper {
                private SecurityRole _role;
                final /* synthetic */ EJBJar11VRule this$0;

                public RoleWrapper(EJBJar11VRule eJBJar11VRule, SecurityRole role) {
                    this.this$0 = eJBJar11VRule;
                    this._role = null;
                    this._role = role;
                }

                public boolean equals(Object o) {
                    if (o instanceof RoleWrapper) {
                        RoleWrapper other = (RoleWrapper)o;
                        return this._role.getRoleName().equals(other.getRole().getRoleName());
                    }
                    return false;
                }

                public SecurityRole getRole() {
                    return this._role;
                }
            }
            DuplicatesTable roleNames = new DuplicatesTable();
            SecurityRole role = null;
            Iterator roleIt = roles.iterator();
            while (roleIt.hasNext()) {
                IMessage message;
                vc.terminateIfCancelled();
                role = (SecurityRole)roleIt.next();
                if (role == null) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2825", 2, ejbJar, (IValidationRule)this);
                    vc.addMessage(message);
                    continue;
                }
                if (!role.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getSecurityRole_RoleName()) || role.getRoleName().equals("")) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2825", 2, role, (IValidationRule)this);
                    vc.addMessage(message);
                    continue;
                }
                roleNames.add(new RoleWrapper(this, role));
            }
            if (roleNames.containsDuplicates()) {
                List duplicates = roleNames.getDuplicates();
                Iterator iterator = duplicates.iterator();
                while (iterator.hasNext()) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2826", 2, ((RoleWrapper)iterator.next()).getRole(), (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            roleNames.clear();
        }
        EList methTrans = assemblyDescriptor.getMethodTransactions();
        MethodTransaction mt = null;
        Iterator iterator = methTrans.iterator();
        while (iterator.hasNext()) {
            vc.terminateIfCancelled();
            try {
                mt = (MethodTransaction)iterator.next();
            }
            catch (Throwable exc) {
                Logger logger = vc.getMsgLogger();
                if (logger != null && logger.isLoggingLevel(Level.FINER)) {
                    logger.write(Level.FINER, exc);
                }
                mt = null;
            }
            if (mt == null) {
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.FINEST)) continue;
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("DDValidator.validateAssemblyDescriptorElement");
                entry.setText("mt is null");
                logger.write(Level.FINEST, (Object)entry);
                continue;
            }
            boolean hasValidMethod = this.validateMethodElements(vc, ejbJar, (List)mt.getMethodElements());
            if (hasValidMethod) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2847", 2, mt, (IValidationRule)this);
            vc.addMessage(message);
        }
        EList methodPermissions = assemblyDescriptor.getMethodPermissions();
        iterator = methodPermissions.iterator();
        while (iterator.hasNext()) {
            EList mproles;
            MethodPermission mp = (MethodPermission)iterator.next();
            boolean hasValidMethod = this.validateMethodElements(vc, ejbJar, (List)mp.getMethodElements());
            if (!hasValidMethod) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2846", 2, mp, (IValidationRule)this);
                vc.addMessage(message);
            }
            if ((mproles = mp.getRoles()) != null && mproles.size() != 0) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2845", 2, mp, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationException {
        EJBJar ejbJar = (EJBJar)target;
        EList enterpriseBeans = ejbJar.getEnterpriseBeans();
        Iterator iterator = enterpriseBeans.iterator();
        EnterpriseBean bean = null;
        Object beanName = null;
        while (true) {
            if (!iterator.hasNext()) {
                this.validateAssemblyDescriptorElement(vc, ejbJar);
                this.validateUniqueEjbNames(vc, ejbJar);
                this.validateClientJAR(vc, ejbJar);
                return;
            }
            try {
                Object var12_19;
                bean = (EnterpriseBean)iterator.next();
                this.register(vc, ejbJar, bean);
                Object id = IValidationRuleList.EJB11_ENTERPRISEBEAN;
                IValidationRule vRule = EJBValidationRuleFactory.getFactory().getRule(vc, id);
                if (vRule == null) continue;
                try {
                    try {
                        vRule.preValidate(vc, ejbJar, bean);
                        vRule.validate(vc, ejbJar, bean);
                        vRule.postValidate(vc, ejbJar, bean);
                    }
                    catch (ValidationCancelledException validationCancelledException) {
                    }
                    catch (MessageLimitException exc) {
                        throw exc;
                    }
                    catch (ValidationException e) {
                        throw e;
                    }
                    catch (Throwable exc) {
                        this.addInternalErrorMessage(vc, exc);
                    }
                }
                catch (Throwable throwable) {
                    var12_19 = null;
                    EJBValidationRuleFactory.getFactory().release(vRule);
                    throw throwable;
                }
                {
                    var12_19 = null;
                    EJBValidationRuleFactory.getFactory().release(vRule);
                    continue;
                }
            }
            catch (MessageLimitException e) {
                throw e;
            }
            catch (ValidationCancelledException e) {
                throw e;
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (Throwable exc) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2852", 2, bean, new String[]{"ejb-jar.xml", beanName}, (IValidationRule)this);
                vc.addMessage(message);
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.SEVERE)) continue;
                logger.write(Level.SEVERE, exc);
                continue;
            }
            break;
        }
    }

    public void reset() {
        super.reset();
        this._ejbName.clear();
    }

    protected void register(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        this._ejbName.add(new EjbNameWrapper(bean));
    }

    private void addInternalErrorMessage(IEJBValidationContext vc, Throwable exc) {
        Logger logger;
        IMessage mssg = vc.getMessage();
        mssg.setId("CHKJ2900");
        vc.addMessage(mssg);
        if (exc != null && (logger = vc.getMsgLogger()) != null && logger.isLoggingLevel(Level.SEVERE)) {
            logger.write(Level.SEVERE, exc);
        }
    }

    public void validateUniqueEjbNames(IEJBValidationContext vc, EJBJar ejbJar) {
        List names = this._ejbName.getDuplicates();
        if (names.size() == 0) {
            return;
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            EjbNameWrapper wrapper = (EjbNameWrapper)iterator.next();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2895", 2, wrapper.getBean(), new String[]{wrapper.getBean().getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateClientJAR(IEJBValidationContext vc, EJBJar ejbJar) {
        String clientJARName = ejbJar.getEjbClientJar();
        if (clientJARName == null) {
            return;
        }
        Boolean exists = (Boolean)vc.loadModel("EJB_CLIENTJAR", new Object[]{clientJARName});
        if (exists == null) {
            return;
        }
        if (!exists.booleanValue()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2875", 1, ejbJar, new String[]{clientJARName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected boolean validateMethodElements(IEJBValidationContext vc, EJBJar ejbJar, List elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean hasValidMethod = false;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            IMessage message;
            vc.terminateIfCancelled();
            MethodElement element = (MethodElement)iterator.next();
            EnterpriseBean bean = element.getEnterpriseBean();
            if (bean == null) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2814", 2, element, (IValidationRule)this);
                vc.addMessage(message);
                continue;
            }
            if (element.getName() != null) {
                List params;
                boolean hasMethods;
                IMessage message2;
                String[] msgParm;
                String className;
                boolean reflected = true;
                try {
                    ValidationRuleUtility.isValidType((JavaHelpers)bean.getHomeInterface());
                }
                catch (InvalidInputException e) {
                    reflected = false;
                    className = e.getJavaClass() == null ? "<home>" : e.getJavaClass().getQualifiedName();
                    msgParm = new String[]{className};
                    message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2850", 2, bean, msgParm, (IValidationRule)this);
                    vc.addMessage(message2);
                }
                try {
                    ValidationRuleUtility.isValidType((JavaHelpers)bean.getRemoteInterface());
                }
                catch (InvalidInputException e) {
                    reflected = false;
                    className = e.getJavaClass() == null ? "<remote>" : e.getJavaClass().getQualifiedName();
                    msgParm = new String[]{className};
                    message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2850", 2, bean, msgParm, (IValidationRule)this);
                    vc.addMessage(message2);
                }
                if (!reflected) continue;
                String name = element.getName();
                Method[] methods = element.getMethods();
                boolean bl = hasMethods = methods != null && methods.length > 0;
                if (!hasMethods) {
                    message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2843", 2, element, new String[]{bean.getName()}, (IValidationRule)this);
                    vc.addMessage(message2);
                    continue;
                }
                hasValidMethod = true;
                if (!name.equals("*") || (params = element.getMethodParams()) == null || params.size() <= 0) continue;
                IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2842", 2, element, (IValidationRule)this);
                vc.addMessage(message3);
                continue;
            }
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2844", 2, element, (IValidationRule)this);
            vc.addMessage(message);
        }
        return hasValidMethod;
    }

    class EjbNameWrapper {
        private EnterpriseBean _bean = null;

        public EjbNameWrapper(EnterpriseBean bean) {
            this._bean = bean;
        }

        public boolean equals(Object o) {
            if (o instanceof EjbNameWrapper) {
                EjbNameWrapper other = (EjbNameWrapper)o;
                if (this._bean.getName() == null && other.getBean().getName() == null) {
                    return true;
                }
                if (this._bean.getName() == null) {
                    return false;
                }
                if (other.getBean().getName() == null) {
                    return false;
                }
                return this._bean.getName().equals(other.getBean().getName());
            }
            return false;
        }

        public int hashCode() {
            if (this.getBean() != null && this.getBean().getName() != null) {
                return this.getBean().getName().hashCode();
            }
            return super.hashCode();
        }

        public EnterpriseBean getBean() {
            return this._bean;
        }
    }
}

