/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.NewFlexibleProjectGroup;
import org.eclipse.jst.j2ee.project.datamodel.properties.IFlexibleJavaProjectCreationDataModelProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class FlexibleProjectCreationWizardPage
extends DataModelWizardPage
implements IFlexibleJavaProjectCreationDataModelProperties {
    private static final boolean isWindows = SWT.getPlatform().toLowerCase().startsWith("win");
    protected NewFlexibleProjectGroup projectNameGroup;
    protected Composite advancedComposite;
    protected Button advancedButton;
    protected boolean showAdvanced = false;
    protected AdvancedSizeController advancedController;
    protected boolean advancedControlsBuilt = false;
    protected Combo serverTargetCombo;

    public FlexibleProjectCreationWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(J2EEUIMessages.getResourceString("FlexibleProjectCreationWizard.mainPage.title"));
        this.setDescription(J2EEUIMessages.getResourceString("FlexibleProjectCreationWizard.mainPage.desc"));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.setInfopopID("org.eclipse.jst.j2ee.ui.EAR_NEW_EAR_WIZARD_PAGE1");
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setData((Object)new GridData(1808));
        Composite composite = new Composite(top, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createProjectNameGroup(composite);
        Composite detail = new Composite(top, 0);
        detail.setLayout((Layout)new GridLayout());
        detail.setLayoutData((Object)new GridData(1808));
        this.createAdvancedComposite(detail);
        return top;
    }

    protected void createProjectNameGroup(Composite parent) {
        this.projectNameGroup = new NewFlexibleProjectGroup(parent, 0, this.model, this.synchHelper);
    }

    protected Composite createAdvancedComposite(Composite parent) {
        this.advancedControlsBuilt = true;
        this.advancedButton = new Button(parent, 2);
        this.setAdvancedLabelText();
        final Cursor hand = new Cursor((Device)this.advancedButton.getDisplay(), 21);
        this.advancedButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                hand.dispose();
            }
        });
        this.advancedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FlexibleProjectCreationWizardPage.this.toggleAdvanced(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.advancedButton.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 32) {
                    FlexibleProjectCreationWizardPage.this.advancedButton.setCursor(hand);
                }
            }
        });
        this.advancedComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData data = new GridData(768);
        this.advancedComposite.setLayoutData((Object)data);
        this.advancedComposite.setLayout((Layout)layout);
        this.addToAdvancedComposite(this.advancedComposite);
        return this.advancedComposite;
    }

    private void setAdvancedLabelText() {
        if (this.advancedControlsBuilt) {
            if (this.showAdvanced) {
                this.advancedButton.setText(J2EEUIMessages.getResourceString("J2EEProjectCreationPage_UI_0"));
            } else {
                this.advancedButton.setText(J2EEUIMessages.getResourceString("J2EEProjectCreationPage_UI_1"));
            }
        }
    }

    protected void toggleAdvanced(boolean setSize) {
        if (this.advancedControlsBuilt) {
            this.showAdvanced = !this.showAdvanced;
            this.advancedComposite.setVisible(this.showAdvanced);
            this.setAdvancedLabelText();
            if (setSize && isWindows) {
                this.advancedController.setShellSizeForAdvanced();
            }
        }
    }

    protected void enter() {
        if (this.advancedControlsBuilt) {
            if (this.isFirstTimeToPage) {
                this.initializeAdvancedController();
            }
            if (isWindows) {
                this.advancedController.setShellSizeForAdvanced();
            }
        }
        super.enter();
    }

    private void initializeAdvancedController() {
        this.advancedController = new AdvancedSizeController(this.getShell());
    }

    protected void exit() {
        if (this.advancedControlsBuilt && isWindows) {
            this.advancedController.resetOriginalShellSize();
        }
        super.exit();
    }

    protected void createServerTargetComposite(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(J2EEUIMessages.getResourceString("2"));
        this.serverTargetCombo = new Combo(parent, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(768));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText(J2EEUIMessages.getResourceString("14"));
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlexibleProjectCreationWizardPage.launchNewRuntimeWizard(FlexibleProjectCreationWizardPage.this.getShell(), FlexibleProjectCreationWizardPage.this.model.getNestedModel("IFlexibleProjectCreationDataModelProperties.NESTED_MODEL_SERVER_TARGET"));
            }
        });
        Control[] deps = new Control[]{label, newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", deps);
        if (this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected void addToAdvancedComposite(Composite parent) {
        this.createServerTargetComposite(parent);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IProjectCreationProperties.PROJECT_NAME", "IProjectCreationProperties.PROJECT_LOCATION", "IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID"};
    }

    public static boolean launchNewRuntimeWizard(Shell shell, IDataModel model) {
        DataModelPropertyDescriptor[] preAdditionDescriptors = model.getValidPropertyDescriptors("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
        boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)shell, (String)"", (String)"");
        if (isOK && model != null) {
            model.notifyPropertyChange("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", 4);
            DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID");
            Object[] preAddition = new Object[preAdditionDescriptors.length];
            int i = 0;
            while (i < preAddition.length) {
                preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                ++i;
            }
            Object[] postAddition = new Object[postAdditionDescriptors.length];
            int i2 = 0;
            while (i2 < postAddition.length) {
                postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                ++i2;
            }
            Object newAddition = ProjectUtilities.getNewObject((Object[])preAddition, (Object[])postAddition);
            model.notifyPropertyChange("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", 4);
            if (newAddition != null) {
                model.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", newAddition);
            }
        }
        return isOK;
    }

    private class AdvancedSizeController
    implements ControlListener {
        private int advancedHeight = -1;
        private Point originalSize;
        private boolean ignoreShellResize = false;

        private AdvancedSizeController(Shell aShell) {
            this.originalSize = aShell.getSize();
            aShell.addControlListener((ControlListener)this);
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            Control control;
            if (!this.ignoreShellResize && (control = (Control)e.getSource()).isVisible()) {
                this.originalSize = control.getSize();
                if (this.advancedHeight == -1) {
                    this.setShellSizeForAdvanced();
                }
            }
        }

        protected void resetOriginalShellSize() {
            this.setShellSize(this.originalSize.x, this.originalSize.y);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setShellSize(int x, int y) {
            this.ignoreShellResize = true;
            try {
                FlexibleProjectCreationWizardPage.this.getShell().setSize(x, y);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.ignoreShellResize = false;
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.ignoreShellResize = false;
                return;
            }
        }

        protected void setShellSizeForAdvanced() {
            int height = this.calculateAdvancedShellHeight();
            if (height != -1) {
                this.setShellSize(FlexibleProjectCreationWizardPage.this.getShell().getSize().x, height);
            }
        }

        private int calculateAdvancedShellHeight() {
            Point advancedCompSize = FlexibleProjectCreationWizardPage.this.advancedComposite.getSize();
            if (advancedCompSize.x == 0) {
                return -1;
            }
            int height = this.computeAdvancedHeight();
            if (!FlexibleProjectCreationWizardPage.this.showAdvanced && height != -1) {
                height -= FlexibleProjectCreationWizardPage.this.advancedComposite.getSize().y;
            }
            return height;
        }

        private int computeAdvancedHeight() {
            if (this.advancedHeight == -1) {
                Point controlSize = FlexibleProjectCreationWizardPage.this.getControl().getSize();
                if (controlSize.x != 0) {
                    int minHeight = this.originalSize.y - controlSize.y;
                    Point pageSize = FlexibleProjectCreationWizardPage.this.getControl().computeSize(-1, -1);
                    this.advancedHeight = pageSize.y + minHeight;
                }
            }
            return this.advancedHeight;
        }
    }
}

