/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceEvent;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServiceManagerListener;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class WebServicesManager
implements EditModelListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    private HashMap wsArtifactEdits;
    private HashMap wsClientArtifactEdits;
    private static WebServicesManager INSTANCE = null;
    private List listeners;
    private List removedListeners = new ArrayList();
    private boolean isNotifing = false;
    public static final String WSDL_EXT = "wsdl";
    public static final String WSIL_EXT = "wsil";

    public static WebServicesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebServicesManager();
        }
        return INSTANCE;
    }

    public WebServicesManager() {
        this.init();
    }

    private void init() {
        this.collectArtifactEdits();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    private void collectArtifactEdits() {
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            block10: {
                IVirtualComponent component;
                WSCDDArtifactEdit wscddArtifactEdit;
                block11: {
                    IProject project = projects[i];
                    WSDDArtifactEdit wsddArtifactEdit = null;
                    wscddArtifactEdit = null;
                    component = ComponentCore.createComponent((IProject)project);
                    try {
                        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) break block10;
                        if (J2EEProjectUtilities.isEARProject((IProject)project)) {
                        }
                    }
                    catch (Exception exception) {}
                    break block10;
                    try {
                        wsddArtifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead(component);
                        if (wsddArtifactEdit != null) {
                            wsddArtifactEdit.addListener(this);
                            this.getWSArtifactEdits().put(component.getProject(), wsddArtifactEdit);
                        }
                    }
                    catch (Exception exception) {
                        if (wsddArtifactEdit == null) break block11;
                        wsddArtifactEdit.dispose();
                    }
                }
                try {
                    wscddArtifactEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForRead(component);
                    if (wscddArtifactEdit != null) {
                        wscddArtifactEdit.addListener(this);
                        this.getWSClientArtifactEdits().put(component.getProject(), wscddArtifactEdit);
                    }
                }
                catch (Exception exception) {
                    if (wscddArtifactEdit == null) break block10;
                    wscddArtifactEdit.dispose();
                }
            }
            ++i;
        }
    }

    private HashMap getWSArtifactEdits() {
        if (this.wsArtifactEdits == null) {
            this.wsArtifactEdits = new HashMap();
        }
        return this.wsArtifactEdits;
    }

    private HashMap getWSClientArtifactEdits() {
        if (this.wsClientArtifactEdits == null) {
            this.wsClientArtifactEdits = new HashMap();
        }
        return this.wsClientArtifactEdits;
    }

    private List getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners;
    }

    public void addListener(WebServiceManagerListener aListener) {
        if (aListener != null && !this.getListeners().contains(aListener)) {
            this.getListeners().add(aListener);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void editModelChanged(EditModelEvent anEvent) {
        WSCDDArtifactEdit wsClientArtifactEdit;
        if (anEvent == null) {
            return;
        }
        if (anEvent.getEventCode() == 7) {
            List resources = anEvent.getChangedResources();
            int i = 0;
            while (true) {
                if (i >= resources.size()) {
                    return;
                }
                Resource res = (Resource)resources.get(i);
                if (res instanceof WsddResource || res instanceof WebServicesResource) {
                    this.notifyListeners(anEvent.getEventCode());
                }
                ++i;
            }
        }
        if (anEvent.getEventCode() != 5) return;
        ArtifactEditModel editModel = (ArtifactEditModel)anEvent.getEditModel();
        if (editModel == null) return;
        if (editModel.getProject() == null) {
            return;
        }
        WSDDArtifactEdit wsArtifactEdit = (WSDDArtifactEdit)((Object)this.getWSArtifactEdits().get(editModel.getProject()));
        if (wsArtifactEdit != null) {
            try {
                this.getWSArtifactEdits().remove(editModel.getProject());
                wsArtifactEdit.removeListener(this);
            }
            catch (Throwable throwable) {
                Object res = null;
                wsArtifactEdit.dispose();
                throw throwable;
            }
            {
                Object res = null;
            }
            wsArtifactEdit.dispose();
        }
        if ((wsClientArtifactEdit = (WSCDDArtifactEdit)((Object)this.getWSClientArtifactEdits().get(editModel.getProject()))) != null) {
            try {
                this.getWSClientArtifactEdits().remove(editModel.getProject());
                wsClientArtifactEdit.removeListener(this);
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                wsClientArtifactEdit.dispose();
                throw throwable;
            }
            {
                Object var5_11 = null;
            }
            wsClientArtifactEdit.dispose();
        }
        this.notifyListeners(anEvent.getEventCode());
    }

    private WSDDArtifactEdit getWSArtifactEdit(IProject handle) {
        WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)this.getWSArtifactEdits().get(handle));
        if (artifactEdit == null && (artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead(handle)) != null) {
            artifactEdit.addListener(this);
            this.getWSArtifactEdits().put(handle, artifactEdit);
        }
        return artifactEdit;
    }

    private WSCDDArtifactEdit getWSClientArtifactEdit(IProject handle) {
        WSCDDArtifactEdit artifactEdit = (WSCDDArtifactEdit)((Object)this.getWSClientArtifactEdits().get(handle));
        if (artifactEdit == null && (artifactEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForRead(handle)) != null) {
            artifactEdit.addListener(this);
            this.getWSClientArtifactEdits().put(handle, artifactEdit);
        }
        return artifactEdit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyListeners(int anEventType) {
        if (this.listeners == null) {
            return;
        }
        var2_2 = this;
        synchronized (var2_2) {
            this.isNotifing = true;
        }
        try {
            list = this.getListeners();
            i = 0;
            while (i < list.size()) {
                webServiceEvent = new WebServiceEvent(1);
                ((WebServiceManagerListener)list.get(i)).webServiceManagerChanged(webServiceEvent);
                ++i;
            }
        }
        catch (Throwable var6_5) {
            var5_6 = null;
            var7_8 = this;
            synchronized (var7_8) {
                this.isNotifing = false;
                if (this.removedListeners == null) throw var6_5;
                if (this.removedListeners.isEmpty() != false) throw var6_5;
                i = 0;
                while (true) {
                    if (i >= this.removedListeners.size()) {
                        this.removedListeners.clear();
                        throw var6_5;
                    }
                    this.listeners.remove(this.removedListeners.get(i));
                    ++i;
                }
            }
        }
        {
            var5_7 = null;
            var7_9 = this;
        }
        synchronized (var7_9) {
            ** try [egrp 2[TRYBLOCK] [4 : 93->176)] { 
lbl43:
            // 1 sources

            this.isNotifing = false;
            if (this.removedListeners == null) return;
            if (this.removedListeners.isEmpty() != false) return;
            i = 0;
            while (true) {
                if (i >= this.removedListeners.size()) {
                    this.removedListeners.clear();
                    return;
                }
                this.listeners.remove(this.removedListeners.get(i));
                ++i;
            }
lbl55:
            // 1 sources

            catch (Throwable v2) {
                throw v2;
            }
        }
    }

    public synchronized boolean removeListener(WebServiceManagerListener aListener) {
        if (aListener != null) {
            if (this.isNotifing) {
                return this.removedListeners.add(aListener);
            }
            return this.getListeners().remove(aListener);
        }
        return false;
    }

    private void releaseArtifactEdits() {
        EnterpriseArtifactEdit artifactEdit;
        Iterator iter = this.getWSArtifactEdits().values().iterator();
        while (iter.hasNext()) {
            artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
            artifactEdit.removeListener((EditModelListener)this);
            artifactEdit.dispose();
        }
        this.getWSArtifactEdits().clear();
        iter = this.getWSClientArtifactEdits().values().iterator();
        while (iter.hasNext()) {
            artifactEdit = (WSCDDArtifactEdit)((Object)iter.next());
            artifactEdit.removeListener((EditModelListener)this);
            artifactEdit.dispose();
        }
        this.getWSClientArtifactEdits().clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.acceptDelta(event);
    }

    protected void acceptDelta(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    public List getInternalWebServicesDescriptions() {
        ArrayList result = new ArrayList();
        List webServices = this.getInternalWebServices();
        int i = 0;
        while (i < webServices.size()) {
            WebServices webService = (WebServices)webServices.get(i);
            if (webService != null) {
                result.addAll(webService.getWebServiceDescriptions());
            }
            ++i;
        }
        return result;
    }

    public List getInternalWebServices() {
        ArrayList<WebServices> result = new ArrayList<WebServices>();
        Iterator iter = this.getWSArtifactEdits().values().iterator();
        while (iter.hasNext()) {
            WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
            WebServices webServices = artifactEdit.getWebServices();
            if (webServices == null) continue;
            result.add(webServices);
        }
        return result;
    }

    public List getInternalWSDLServices() {
        return this.getWSDLServicesFromWSDLResources(this.getInternalWSDLResources());
    }

    public List getInternalWSDLResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        List wsddWebServices = this.getInternalWebServicesDescriptions();
        int i = 0;
        while (i < wsddWebServices.size()) {
            WebServiceDescription webServices = (WebServiceDescription)wsddWebServices.get(i);
            Resource wsdl = this.getWSDLResource(webServices);
            if (wsdl != null && !result.contains(wsdl)) {
                result.add(wsdl);
            }
            ++i;
        }
        return result;
    }

    public List getExternalWSDLResources() {
        List result = this.getWorkspaceWSDLResources();
        result.removeAll(this.getInternalWSDLResources());
        List serviceRefs = this.getAllWorkspaceServiceRefs();
        int i = 0;
        while (i < serviceRefs.size()) {
            ServiceRef ref = (ServiceRef)serviceRefs.get(i);
            try {
                Resource res = WorkbenchResourceHelperBase.getResource((URI)URI.createURI((String)ref.getWsdlFile()), (boolean)true);
                if (res != null && result.contains(res)) {
                    result.remove(res);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    public boolean isServiceInternal(EObject service) {
        return this.getInternalWSDLResources().contains(this.getWSDLResource(service));
    }

    private List getWSDLServicesFromWSDLResources(List wsdlResources) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < wsdlResources.size()) {
            Resource wsdl = (Resource)wsdlResources.get(i);
            List services = this.getWSDLServices(wsdl);
            if (wsdl != null && services != null && !services.isEmpty()) {
                result.addAll(services);
            }
            ++i;
        }
        return result;
    }

    public List getExternalWSDLServices() {
        List result = this.getWsdlServicesFromWorkspaceWSILs();
        result.removeAll(this.getInternalWSDLServices());
        return result;
    }

    public List getWsdlServicesFromWorkspaceWSILs() {
        ArrayList result = new ArrayList();
        List wsilFiles = this.getWorkspaceWSILFiles();
        int i = 0;
        while (i < wsilFiles.size()) {
            IFile wsil = (IFile)wsilFiles.get(i);
            List services = this.getWsdlServicesFromWsilFile(wsil);
            if (!services.isEmpty()) {
                result.addAll(services);
            }
            ++i;
        }
        return result;
    }

    public List getWsdlServicesFromWsilFile(IFile wsil) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        return serviceHelper.getWsdlServicesFromWsilFile(wsil);
    }

    public List getAllWSDLServices() {
        ArrayList result = new ArrayList();
        result.addAll(this.getInternalWSDLServices());
        result.addAll(this.getExternalWSDLServices());
        return result;
    }

    protected void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.releaseArtifactEdits();
        INSTANCE = null;
    }

    public Resource getWSDLResource(WebServiceDescription webService) {
        if (webService == null) {
            return null;
        }
        String wsdlFileName = webService.getWsdlFile();
        Resource res = null;
        IVirtualResource[] resources = ComponentCore.createResources((IResource)WorkbenchResourceHelper.getFile((EObject)webService));
        if (resources == null) {
            return res;
        }
        WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)this.getWSArtifactEdits().get(resources[0].getComponent().getProject()));
        if (artifactEdit != null) {
            res = artifactEdit.getWsdlResource(wsdlFileName);
        }
        return res;
    }

    public List getWSDLServices(Resource wsdl) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        ArrayList<Object> result = new ArrayList();
        Object def = serviceHelper.getWSDLDefinition(wsdl);
        if (def == null) {
            return result;
        }
        result = new ArrayList(serviceHelper.getDefinitionServices(def).values());
        return result;
    }

    public EObject getWSDLServiceForWebService(WebServiceDescription webService) {
        EObject service = null;
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        Resource wsdl = this.getWSDLResource(webService);
        if (wsdl == null) {
            return service;
        }
        Object definition = serviceHelper.getWSDLDefinition(wsdl);
        if (definition == null) {
            return service;
        }
        Map services = serviceHelper.getDefinitionServices(definition);
        if (services.isEmpty()) {
            return service;
        }
        PortComponent portComp = null;
        if (webService.getPortComponents() != null && webService.getPortComponents().size() > 0) {
            portComp = (PortComponent)webService.getPortComponents().get(0);
            return this.getService(portComp);
        }
        return service;
    }

    public Resource getWSDLResource(EObject wsdlService) {
        return wsdlService.eResource();
    }

    public EObject getService(PortComponent port) {
        List services = this.getInternalWSDLServices();
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        int i = 0;
        while (i < services.size()) {
            EObject service = (EObject)services.get(i);
            if (serviceHelper.getServicePorts((Object)service).size() == 1) {
                Object wsdlPort = serviceHelper.getServicePorts((Object)service).values().toArray()[0];
                String qName = serviceHelper.getPortBindingNamespaceURI(wsdlPort);
                if (port.getWsdlPort().getNamespaceURI().equals(qName)) {
                    return service;
                }
            }
            ++i;
        }
        return null;
    }

    public PortComponent getPortComponent(String qName) {
        List wsDescs = this.getInternalWebServicesDescriptions();
        int i = 0;
        while (i < wsDescs.size()) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.get(i);
            EList ports = wsDesc.getPortComponents();
            int j = 0;
            while (j < ports.size()) {
                PortComponent portComp = (PortComponent)ports.get(j);
                if (portComp.getWsdlPort().getNamespaceURI().equals(qName)) {
                    return portComp;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public PortComponent getPortComponent(String qName, IProject project) {
        List wsDescs = this.getInternalWebServicesDescriptions();
        int i = 0;
        while (i < wsDescs.size()) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.get(i);
            EList ports = wsDesc.getPortComponents();
            int j = 0;
            while (j < ports.size()) {
                PortComponent portComp = (PortComponent)ports.get(j);
                if (project == ProjectUtilities.getProject((EObject)portComp)) {
                    return portComp;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public PortComponent getPortComponent(EObject wsdlService) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (wsdlService == null || serviceHelper.getServicePorts((Object)wsdlService).isEmpty()) {
            return null;
        }
        if (serviceHelper.getServicePorts((Object)wsdlService).size() == 1) {
            Object port = serviceHelper.getServicePorts((Object)wsdlService).values().toArray()[0];
            String qName = serviceHelper.getPortBindingNamespaceURI(port);
            return this.getPortComponent(qName, ProjectUtilities.getProject((EObject)wsdlService));
        }
        return null;
    }

    public ServiceImplBean getServiceImplBean(EObject wsdlService) {
        PortComponent port = this.getPortComponent(wsdlService);
        if (port == null) {
            return null;
        }
        return port.getServiceImplBean();
    }

    public WsddResource getWsddResource(EObject wsdlService) {
        PortComponent port = this.getPortComponent(wsdlService);
        if (port == null) {
            return null;
        }
        return (WsddResource)port.eResource();
    }

    public String getServiceEndpointInterface(EObject wsdlService) {
        PortComponent port = this.getPortComponent(wsdlService);
        if (port == null) {
            return null;
        }
        return port.getServiceEndpointInterface();
    }

    public List getAllWorkspaceServiceRefs() {
        ArrayList result = new ArrayList();
        result.addAll(this.getWorkspace13ServiceRefs());
        result.addAll(this.getWorkspace14ServiceRefs());
        return result;
    }

    public List getWorkspace13ServiceRefs() {
        ArrayList result = new ArrayList();
        Iterator iter = this.getWSClientArtifactEdits().values().iterator();
        while (iter.hasNext()) {
            WSCDDArtifactEdit artifactEdit = (WSCDDArtifactEdit)((Object)iter.next());
            WebServicesResource res = artifactEdit.getWscddXmiResource();
            if (res == null || !res.isLoaded() || res.getWebServicesClient() == null) continue;
            result.addAll(res.getWebServicesClient().getServiceRefs());
        }
        return result;
    }

    public List get13ServiceRefs(IProject handle) {
        WebServicesResource res;
        ArrayList result = new ArrayList();
        WSCDDArtifactEdit wsClientArtifactEdit = (WSCDDArtifactEdit)((Object)this.getWSClientArtifactEdits().get(handle));
        if (wsClientArtifactEdit != null && (res = wsClientArtifactEdit.getWscddXmiResource()) != null && res.isLoaded() && res.getWebServicesClient() != null) {
            result.addAll(res.getWebServicesClient().getServiceRefs());
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getWorkspace14ServiceRefs() {
        result = new ArrayList<E>();
        iter = this.getWSClientArtifactEdits().values().iterator();
        while (true) {
            if (!iter.hasNext()) {
                return result;
            }
            wscArtifactEdit = (WSCDDArtifactEdit)iter.next();
            artifactEdit = ArtifactEdit.getArtifactEditForRead((IProject)wscArtifactEdit.getProject());
            try {
                block11: {
                    block10: {
                        rootObject = artifactEdit.getContentModelRoot();
                        if (!(rootObject instanceof EJBJar)) break block10;
                        cmps = ((EJBJar)rootObject).getEnterpriseBeans();
                        j = 0;
                        while (j < cmps.size()) {
                            bean = (EnterpriseBean)cmps.get(j);
                            if (bean.getServiceRefs() != null && !bean.getServiceRefs().isEmpty()) {
                                result.addAll(bean.getServiceRefs());
                            }
                            ++j;
                        }
                        ** GOTO lbl-1000
                    }
                    if (!(rootObject instanceof WebApp)) break block11;
                    if (((WebApp)rootObject).getServiceRefs() != null && !((WebApp)rootObject).getServiceRefs().isEmpty()) {
                        result.addAll(((WebApp)rootObject).getServiceRefs());
                    }
                    ** GOTO lbl-1000
                }
                if (rootObject instanceof ApplicationClient && ((ApplicationClient)rootObject).getServiceRefs() != null && !((ApplicationClient)rootObject).getServiceRefs().isEmpty()) {
                    result.addAll(((ApplicationClient)rootObject).getServiceRefs());
                }
            }
            catch (Throwable var10_10) {
                var9_9 = null;
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                throw var10_10;
            }
lbl-1000:
            // 3 sources

            {
                var9_9 = null;
                if (artifactEdit == null) continue;
            }
            artifactEdit.dispose();
        }
    }

    public boolean isJ2EE14(ServiceRef ref) {
        return !(ref.eContainer() instanceof WebServicesClient);
    }

    public List getWorkspaceWSILFiles() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        Iterator iter = this.getWSArtifactEdits().values().iterator();
        while (iter.hasNext()) {
            WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
            List files = artifactEdit.getWSILResources();
            int j = 0;
            while (j < files.size()) {
                IFile file = (IFile)files.get(j);
                if (file != null && WSIL_EXT.equals(file.getFileExtension())) {
                    result.add(file);
                }
                ++j;
            }
        }
        return result;
    }

    public List getWorkspaceWSDLResources() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        Iterator iter = this.getWSArtifactEdits().values().iterator();
        while (iter.hasNext()) {
            List wsdlResources;
            WSDDArtifactEdit artifactEdit = (WSDDArtifactEdit)((Object)iter.next());
            IProject project = artifactEdit.getProject();
            if (project == null || (wsdlResources = artifactEdit.getWSDLResources()) == null || wsdlResources.isEmpty()) continue;
            int j = 0;
            while (j < wsdlResources.size()) {
                Resource wsdl = (Resource)wsdlResources.get(j);
                if (!result.contains(wsdl)) {
                    result.add(wsdl);
                }
                ++j;
            }
        }
        return result;
    }

    public List getWSDLServices() {
        ArrayList result = new ArrayList();
        List internalWsdls = this.getInternalWSDLServices();
        if (internalWsdls != null && !internalWsdls.isEmpty()) {
            result.addAll(internalWsdls);
        }
        return result;
    }

    public List get13ServiceRefs(EnterpriseBean bean) {
        WebServicesResource res;
        WSCDDArtifactEdit artifactEdit = (WSCDDArtifactEdit)((Object)this.getWSClientArtifactEdits().get(WorkbenchResourceHelper.getFile((EObject)bean).getProject()));
        if (artifactEdit != null && (res = artifactEdit.getWscddXmiResource()) != null && res.getWebServicesClient() != null) {
            String ejbName = bean.getName();
            EList scopes = res.getWebServicesClient().getComponentScopedRefs();
            Iterator iter = scopes.iterator();
            while (iter.hasNext()) {
                ComponentScopedRefs scope = (ComponentScopedRefs)iter.next();
                if (!scope.getComponentName().equals(ejbName)) continue;
                return scope.getServiceRefs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List get13ServiceRefs(ApplicationClient client) {
        WebServicesClient webClient;
        WebServicesResource res;
        IProject handle = this.getComponentProject(WorkbenchResourceHelper.getFile((EObject)client));
        if (handle == null) {
            return Collections.EMPTY_LIST;
        }
        WSCDDArtifactEdit artifactEdit = (WSCDDArtifactEdit)((Object)this.getWSClientArtifactEdits().get(handle));
        if (artifactEdit != null && (res = artifactEdit.getWscddXmiResource()) != null && (webClient = res.getWebServicesClient()) != null) {
            return webClient.getServiceRefs();
        }
        return Collections.EMPTY_LIST;
    }

    public List get13ServiceRefs(WebApp webapp) {
        WebServicesClient webClient;
        WebServicesResource res;
        IProject handle = this.getComponentProject(WorkbenchResourceHelper.getFile((EObject)webapp));
        if (handle == null) {
            return Collections.EMPTY_LIST;
        }
        WSCDDArtifactEdit artifactEdit = (WSCDDArtifactEdit)((Object)this.getWSClientArtifactEdits().get(handle));
        if (artifactEdit != null && (res = artifactEdit.getWscddXmiResource()) != null && (webClient = res.getWebServicesClient()) != null) {
            return webClient.getServiceRefs();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 4) {
            IProject p = (IProject)resource;
            if (delta.getKind() == 1 || (delta.getFlags() & 0x4000) != 0 && p.isAccessible()) {
                boolean state = true;
                IVirtualComponent component = ComponentCore.createComponent((IProject)p);
                if (component != null && !J2EEProjectUtilities.isEARProject((IProject)p)) {
                    WSCDDArtifactEdit wscArtifactEdit;
                    WSDDArtifactEdit wsArtifactEdit = this.getWSArtifactEdit(p);
                    if (wsArtifactEdit != null) {
                        state = false;
                    }
                    if ((wscArtifactEdit = this.getWSClientArtifactEdit(p)) != null) {
                        state = false;
                    }
                    return state;
                }
            } else if (delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 || delta.getKind() == 2) {
                boolean state = true;
                List wsddArtifactEditsToRemove = this.getAssociatedArtifactEditKeys(p, this.getWSArtifactEdits());
                int i = 0;
                while (i < wsddArtifactEditsToRemove.size()) {
                    IProject handle = (IProject)wsddArtifactEditsToRemove.get(i);
                    if (handle != null && this.getWSArtifactEdits().containsKey(handle)) {
                        WSDDArtifactEdit wsArtifactEdit = (WSDDArtifactEdit)((Object)this.getWSArtifactEdits().get(handle));
                        this.getWSArtifactEdits().remove(handle);
                        wsArtifactEdit.dispose();
                        state = false;
                    }
                    ++i;
                }
                List wscddArtifactEditsToRemove = this.getAssociatedArtifactEditKeys(p, this.getWSClientArtifactEdits());
                int i2 = 0;
                while (i2 < wscddArtifactEditsToRemove.size()) {
                    IProject handle = (IProject)wscddArtifactEditsToRemove.get(i2);
                    if (handle != null && this.getWSClientArtifactEdits().containsKey(handle)) {
                        WSCDDArtifactEdit wscArtifactEdit = (WSCDDArtifactEdit)((Object)this.getWSClientArtifactEdits().get(handle));
                        this.getWSClientArtifactEdits().remove(handle);
                        wscArtifactEdit.dispose();
                        state = false;
                    }
                    ++i2;
                }
                return state;
            }
        } else if (resource.getType() == 1 && this.isInterrestedInFile((IFile)resource)) {
            if (delta.getKind() == 1 || (delta.getFlags() & 0x2000) != 0) {
                if (resource.getFileExtension().equals(WSDL_EXT)) {
                    this.addedWsdl((IFile)resource);
                } else if (resource.getFileExtension().equals(WSIL_EXT)) {
                    this.addedWsil((IFile)resource);
                }
            } else if ((delta.getKind() == 2 || (delta.getFlags() & 0x1000) != 0) && (resource.getFileExtension().equals(WSDL_EXT) || resource.getFileExtension().equals(WSIL_EXT))) {
                this.notifyListeners(7);
            }
            return false;
        }
        return true;
    }

    private List getAssociatedArtifactEditKeys(IProject project, HashMap artifactEdits) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        Iterator iter = artifactEdits.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IProject handle = (IProject)entry.getKey();
            if (!handle.getProject().equals((Object)project)) continue;
            result.add(handle);
        }
        return result;
    }

    protected void addedWsdl(IFile wsdl) {
        if (!wsdl.exists()) {
            return;
        }
        IProject handle = this.getComponentProject(wsdl);
        if (handle != null) {
            this.getWSArtifactEdit(handle);
            this.notifyListeners(6);
        }
    }

    protected void addedWsil(IFile wsil) {
        if (!wsil.exists()) {
            return;
        }
        IProject handle = this.getComponentProject(wsil);
        if (handle != null) {
            this.getWSArtifactEdit(handle);
            this.notifyListeners(6);
        }
    }

    private IProject getComponentProject(IFile res) {
        return res.getProject();
    }

    protected boolean isInterrestedInFile(IFile aFile) {
        if (aFile != null && aFile.getFileExtension() != null) {
            String extension = aFile.getFileExtension();
            return extension.equals(WSDL_EXT) || extension.equals(WSIL_EXT);
        }
        return false;
    }

    public Collection getServiceRefs(EJBJar jar) {
        ArrayList list = new ArrayList();
        EList beans = jar.getEnterpriseBeans();
        try {
            int i = 0;
            while (i < beans.size()) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                list.addAll(this.getServiceRefs(bean));
                ++i;
            }
        }
        catch (Exception exception) {}
        return list;
    }

    public Collection getServiceRefs(EnterpriseBean bean) {
        ArrayList list = new ArrayList();
        if (bean.getEjbJar().getJ2EEVersionID() >= 14) {
            list.addAll(bean.getServiceRefs());
        } else {
            list.addAll(this.get13ServiceRefs(bean));
        }
        return list;
    }

    public Collection getServiceRefs(WebApp webapp) {
        ArrayList list = new ArrayList();
        try {
            if (webapp.getVersionID() >= 24) {
                list.addAll(webapp.getServiceRefs());
            } else {
                list.addAll(this.get13ServiceRefs(webapp));
            }
        }
        catch (Exception exception) {}
        return list;
    }

    public Collection getServiceRefs(ApplicationClient client) {
        ArrayList list = new ArrayList();
        try {
            if (client.getJ2EEVersionID() >= 14) {
                list.addAll(client.getServiceRefs());
            } else {
                list.addAll(this.get13ServiceRefs(client));
            }
        }
        catch (Exception exception) {}
        return list;
    }
}

